/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import com.mongodb.DBObject;
import lombok.NonNull;
import org.springframework.data.mongodb.core.index.IndexFilter;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;

public class PartialIndexFilter
implements IndexFilter {
    @NonNull
    private final Object filterExpression;

    public static PartialIndexFilter of(DBObject where) {
        return new PartialIndexFilter(where);
    }

    public static PartialIndexFilter of(CriteriaDefinition where) {
        return new PartialIndexFilter(where);
    }

    @Override
    public DBObject getFilterObject() {
        if (this.filterExpression instanceof DBObject) {
            return (DBObject)this.filterExpression;
        }
        if (this.filterExpression instanceof CriteriaDefinition) {
            return ((CriteriaDefinition)this.filterExpression).getCriteriaObject();
        }
        throw new IllegalArgumentException(String.format("Unknown type %s used as filter expression.", this.filterExpression.getClass()));
    }

    private PartialIndexFilter(@NonNull Object filterExpression) {
        if (filterExpression == null) {
            throw new IllegalArgumentException("filterExpression is marked @NonNull but is null");
        }
        this.filterExpression = filterExpression;
    }
}

