/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.util.Assert;

public class LookupOperation
implements FieldsExposingAggregationOperation,
FieldsExposingAggregationOperation.InheritsFieldsAggregationOperation {
    private Field from;
    private Field localField;
    private Field foreignField;
    private ExposedFields.ExposedField as;

    public LookupOperation(Field from, Field localField, Field foreignField, Field as) {
        Assert.notNull((Object)from, (String)"From must not be null!");
        Assert.notNull((Object)localField, (String)"LocalField must not be null!");
        Assert.notNull((Object)foreignField, (String)"ForeignField must not be null!");
        Assert.notNull((Object)as, (String)"As must not be null!");
        this.from = from;
        this.localField = localField;
        this.foreignField = foreignField;
        this.as = new ExposedFields.ExposedField(as, true);
    }

    private LookupOperation() {
    }

    @Override
    public ExposedFields getFields() {
        return ExposedFields.from(this.as);
    }

    @Override
    public boolean inheritsFields() {
        return true;
    }

    @Override
    public DBObject toDBObject(AggregationOperationContext context) {
        BasicDBObject lookupObject = new BasicDBObject();
        lookupObject.append("from", (Object)this.from.getTarget());
        lookupObject.append("localField", (Object)this.localField.getTarget());
        lookupObject.append("foreignField", (Object)this.foreignField.getTarget());
        lookupObject.append("as", (Object)this.as.getTarget());
        return new BasicDBObject("$lookup", (Object)lookupObject);
    }

    public static FromBuilder newLookup() {
        return new LookupOperationBuilder();
    }

    public static final class LookupOperationBuilder
    implements FromBuilder,
    LocalFieldBuilder,
    ForeignFieldBuilder,
    AsBuilder {
        private final LookupOperation lookupOperation = new LookupOperation();

        private LookupOperationBuilder() {
        }

        public static FromBuilder newBuilder() {
            return new LookupOperationBuilder();
        }

        @Override
        public LocalFieldBuilder from(String name) {
            Assert.hasText((String)name, (String)"'From' must not be null or empty!");
            this.lookupOperation.from = Fields.field(name);
            return this;
        }

        @Override
        public LookupOperation as(String name) {
            Assert.hasText((String)name, (String)"'As' must not be null or empty!");
            this.lookupOperation.as = new ExposedFields.ExposedField(Fields.field(name), true);
            return new LookupOperation(this.lookupOperation.from, this.lookupOperation.localField, this.lookupOperation.foreignField, this.lookupOperation.as);
        }

        @Override
        public AsBuilder foreignField(String name) {
            Assert.hasText((String)name, (String)"'ForeignField' must not be null or empty!");
            this.lookupOperation.foreignField = Fields.field(name);
            return this;
        }

        @Override
        public ForeignFieldBuilder localField(String name) {
            Assert.hasText((String)name, (String)"'LocalField' must not be null or empty!");
            this.lookupOperation.localField = Fields.field(name);
            return this;
        }
    }

    public static interface AsBuilder {
        public LookupOperation as(String var1);
    }

    public static interface ForeignFieldBuilder {
        public AsBuilder foreignField(String var1);
    }

    public static interface LocalFieldBuilder {
        public ForeignFieldBuilder localField(String var1);
    }

    public static interface FromBuilder {
        public LocalFieldBuilder from(String var1);
    }
}

