/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Range;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.query.TextCriteria;
import org.springframework.data.mongodb.repository.Near;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;

public class MongoParameters
extends Parameters<MongoParameters, MongoParameter> {
    private final int rangeIndex;
    private final int maxDistanceIndex;
    private final Integer fullTextIndex;
    private Integer nearIndex;

    public MongoParameters(Method method, boolean isGeoNearMethod) {
        super(method);
        List<Class<?>> parameterTypes = Arrays.asList(method.getParameterTypes());
        this.fullTextIndex = parameterTypes.indexOf(TextCriteria.class);
        ClassTypeInformation declaringClassInfo = ClassTypeInformation.from(method.getDeclaringClass());
        List parameterTypeInfo = declaringClassInfo.getParameterTypes(method);
        this.rangeIndex = this.getTypeIndex(parameterTypeInfo, Range.class, Distance.class);
        int n = this.maxDistanceIndex = this.rangeIndex == -1 ? this.getTypeIndex(parameterTypeInfo, Distance.class, null) : -1;
        if (this.nearIndex == null && isGeoNearMethod) {
            this.nearIndex = this.getNearIndex(parameterTypes);
        } else if (this.nearIndex == null) {
            this.nearIndex = -1;
        }
    }

    private MongoParameters(List<MongoParameter> parameters, int maxDistanceIndex, Integer nearIndex, Integer fullTextIndex, int rangeIndex) {
        super(parameters);
        this.nearIndex = nearIndex;
        this.fullTextIndex = fullTextIndex;
        this.maxDistanceIndex = maxDistanceIndex;
        this.rangeIndex = rangeIndex;
    }

    private final int getNearIndex(List<Class<?>> parameterTypes) {
        for (Class reference : Arrays.asList(Point.class, double[].class)) {
            int nearIndex = parameterTypes.indexOf(reference);
            if (nearIndex == -1) continue;
            if (nearIndex == parameterTypes.lastIndexOf(reference)) {
                return nearIndex;
            }
            throw new IllegalStateException("Multiple Point parameters found but none annotated with @Near!");
        }
        return -1;
    }

    protected MongoParameter createParameter(MethodParameter parameter) {
        MongoParameter mongoParameter = new MongoParameter(parameter);
        if (this.nearIndex == null && mongoParameter.isManuallyAnnotatedNearParameter()) {
            this.nearIndex = mongoParameter.getIndex();
        } else if (mongoParameter.isManuallyAnnotatedNearParameter()) {
            throw new IllegalStateException(String.format("Found multiple @Near annotations ond method %s! Only one allowed!", parameter.getMethod().toString()));
        }
        return mongoParameter;
    }

    public int getDistanceRangeIndex() {
        return -1;
    }

    @Deprecated
    public int getDistanceIndex() {
        return this.getMaxDistanceIndex();
    }

    public int getMaxDistanceIndex() {
        return this.maxDistanceIndex;
    }

    public int getNearIndex() {
        return this.nearIndex;
    }

    public int getFullTextParameterIndex() {
        return this.fullTextIndex != null ? this.fullTextIndex : -1;
    }

    public boolean hasFullTextParameter() {
        return this.fullTextIndex != null && this.fullTextIndex >= 0;
    }

    public int getRangeIndex() {
        return this.rangeIndex;
    }

    protected MongoParameters createFrom(List<MongoParameter> parameters) {
        return new MongoParameters(parameters, this.maxDistanceIndex, this.nearIndex, this.fullTextIndex, this.rangeIndex);
    }

    private int getTypeIndex(List<TypeInformation<?>> parameterTypes, Class<?> type, Class<?> componentType) {
        for (int i = 0; i < parameterTypes.size(); ++i) {
            TypeInformation<?> candidate = parameterTypes.get(i);
            if (!candidate.getType().equals(type)) continue;
            if (componentType == null) {
                return i;
            }
            if (!componentType.equals(candidate.getComponentType().getType())) continue;
            return i;
        }
        return -1;
    }

    class MongoParameter
    extends Parameter {
        private final MethodParameter parameter;

        MongoParameter(MethodParameter parameter) {
            super(parameter);
            this.parameter = parameter;
            if (!this.isPoint() && this.hasNearAnnotation()) {
                throw new IllegalArgumentException("Near annotation is only allowed at Point parameter!");
            }
        }

        public boolean isSpecialParameter() {
            return super.isSpecialParameter() || Distance.class.isAssignableFrom(this.getType()) || this.isNearParameter() || TextCriteria.class.isAssignableFrom(this.getType());
        }

        private boolean isNearParameter() {
            Integer nearIndex = MongoParameters.this.nearIndex;
            return nearIndex != null && nearIndex.equals(this.getIndex());
        }

        private boolean isManuallyAnnotatedNearParameter() {
            return this.isPoint() && this.hasNearAnnotation();
        }

        private boolean isPoint() {
            return Point.class.isAssignableFrom(this.getType()) || this.getType().equals(double[].class);
        }

        private boolean hasNearAnnotation() {
            return this.parameter.getParameterAnnotation(Near.class) != null;
        }
    }
}

