/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import com.mongodb.MongoClientURI;
import com.mongodb.MongoURI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.data.config.BeanComponentDefinitionBuilder;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.mongodb.config.MongoParsingUtils;
import org.springframework.data.mongodb.core.MongoFactoryBean;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class MongoDbFactoryParser
extends AbstractBeanDefinitionParser {
    private static final Set<String> MONGO_URI_ALLOWED_ADDITIONAL_ATTRIBUTES;

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        return StringUtils.hasText((String)id) ? id : "mongoDbFactory";
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder dbFactoryBuilder = BeanDefinitionBuilder.genericBeanDefinition(SimpleMongoDbFactory.class);
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)dbFactoryBuilder, (Element)element, (String)"write-concern", (String)"writeConcern");
        BeanDefinition mongoUri = this.getMongoUri(element, parserContext);
        if (mongoUri != null) {
            dbFactoryBuilder.addConstructorArgValue((Object)mongoUri);
            return ParsingUtils.getSourceBeanDefinition((BeanDefinitionBuilder)dbFactoryBuilder, (ParserContext)parserContext, (Element)element);
        }
        BeanComponentDefinitionBuilder helper = new BeanComponentDefinitionBuilder(element, parserContext);
        String mongoRef = element.getAttribute("mongo-ref");
        String dbname = element.getAttribute("dbname");
        BeanDefinition userCredentials = this.getUserCredentialsBeanDefinition(element, parserContext);
        if (StringUtils.hasText((String)mongoRef)) {
            dbFactoryBuilder.addConstructorArgReference(mongoRef);
        } else {
            dbFactoryBuilder.addConstructorArgValue((Object)this.registerMongoBeanDefinition(element, parserContext));
        }
        dbFactoryBuilder.addConstructorArgValue((Object)(StringUtils.hasText((String)dbname) ? dbname : "db"));
        dbFactoryBuilder.addConstructorArgValue((Object)userCredentials);
        dbFactoryBuilder.addConstructorArgValue((Object)element.getAttribute("authentication-dbname"));
        BeanDefinitionBuilder writeConcernPropertyEditorBuilder = MongoParsingUtils.getWriteConcernPropertyEditorBuilder();
        BeanComponentDefinition component = helper.getComponent(writeConcernPropertyEditorBuilder);
        parserContext.registerBeanComponent(component);
        return (AbstractBeanDefinition)helper.getComponentIdButFallback(dbFactoryBuilder, "mongoDbFactory").getBeanDefinition();
    }

    private BeanDefinition registerMongoBeanDefinition(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder mongoBuilder = BeanDefinitionBuilder.genericBeanDefinition(MongoFactoryBean.class);
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)mongoBuilder, (Element)element, (String)"host");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)mongoBuilder, (Element)element, (String)"port");
        return ParsingUtils.getSourceBeanDefinition((BeanDefinitionBuilder)mongoBuilder, (ParserContext)parserContext, (Element)element);
    }

    private BeanDefinition getUserCredentialsBeanDefinition(Element element, ParserContext context) {
        String username = element.getAttribute("username");
        String password = element.getAttribute("password");
        if (!StringUtils.hasText((String)username) && !StringUtils.hasText((String)password)) {
            return null;
        }
        BeanDefinitionBuilder userCredentialsBuilder = BeanDefinitionBuilder.genericBeanDefinition(UserCredentials.class);
        userCredentialsBuilder.addConstructorArgValue((Object)(StringUtils.hasText((String)username) ? username : null));
        userCredentialsBuilder.addConstructorArgValue((Object)(StringUtils.hasText((String)password) ? password : null));
        return ParsingUtils.getSourceBeanDefinition((BeanDefinitionBuilder)userCredentialsBuilder, (ParserContext)context, (Element)element);
    }

    private BeanDefinition getMongoUri(Element element, ParserContext parserContext) {
        boolean hasClientUri = element.hasAttribute("client-uri");
        if (!hasClientUri && !element.hasAttribute("uri")) {
            return null;
        }
        int allowedAttributesCount = 1;
        for (String attribute : MONGO_URI_ALLOWED_ADDITIONAL_ATTRIBUTES) {
            if (!element.hasAttribute(attribute)) continue;
            ++allowedAttributesCount;
        }
        if (element.getAttributes().getLength() > allowedAttributesCount) {
            parserContext.getReaderContext().error("Configure either " + (hasClientUri ? "Mongo Client URI" : "Mongo URI") + " or details individually!", parserContext.extractSource((Object)element));
        }
        Class type = hasClientUri ? MongoClientURI.class : MongoURI.class;
        String uri = hasClientUri ? element.getAttribute("client-uri") : element.getAttribute("uri");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(type);
        builder.addConstructorArgValue((Object)uri);
        return builder.getBeanDefinition();
    }

    static {
        HashSet<String> mongoUriAllowedAdditionalAttributes = new HashSet<String>();
        mongoUriAllowedAdditionalAttributes.add("id");
        mongoUriAllowedAdditionalAttributes.add("write-concern");
        MONGO_URI_ALLOWED_ADDITIONAL_ATTRIBUTES = Collections.unmodifiableSet(mongoUriAllowedAdditionalAttributes);
    }
}

