/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.ldap.repository.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.expression.ValueExpression;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.ldap.repository.query.LdapParameterAccessor;
import org.springframework.data.ldap.repository.query.LdapParameters;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.spel.ExpressionDependencies;
import org.springframework.lang.Nullable;
import org.springframework.ldap.support.LdapEncoder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class StringBasedQuery {
    private final String query;
    private final LdapParameters parameters;
    private final List<BindingContext.ParameterBinding> queryParameterBindings = new ArrayList<BindingContext.ParameterBinding>();
    private final ExpressionDependencies expressionDependencies;

    public StringBasedQuery(String query, LdapParameters parameters, ValueExpressionDelegate expressionParser) {
        this.query = ParameterBindingParser.parseAndCollectParameterBindingsFromQueryIntoBindings(query, this.queryParameterBindings, (ValueExpressionParser)expressionParser);
        this.parameters = parameters;
        this.expressionDependencies = this.createExpressionDependencies();
    }

    private ExpressionDependencies createExpressionDependencies() {
        if (this.queryParameterBindings.isEmpty()) {
            return ExpressionDependencies.none();
        }
        ArrayList<ExpressionDependencies> dependencies = new ArrayList<ExpressionDependencies>();
        for (BindingContext.ParameterBinding binding : this.queryParameterBindings) {
            if (!binding.isExpression()) continue;
            dependencies.add(binding.getRequiredExpression().getExpressionDependencies());
        }
        return ExpressionDependencies.merged(dependencies);
    }

    public ExpressionDependencies getExpressionDependencies() {
        return this.expressionDependencies;
    }

    public String bindQuery(LdapParameterAccessor parameterAccessor, Function<ValueExpression, Object> evaluator) {
        Assert.notNull((Object)parameterAccessor, (String)"LdapParameterAccessor must not be null");
        Assert.notNull(evaluator, (String)"ExpressionEvaluator must not be null");
        BindingContext bindingContext = new BindingContext(this.parameters, parameterAccessor, this.queryParameterBindings, evaluator);
        List<Object> arguments = bindingContext.getBindingValues();
        return ParameterBinder.bind(this.query, arguments);
    }

    static class ParameterBindingParser {
        private static final char CURRLY_BRACE_OPEN = '{';
        private static final char CURRLY_BRACE_CLOSE = '}';
        private static final Pattern INDEX_PARAMETER_BINDING_PATTERN = Pattern.compile("\\?(\\d+)");
        private static final Pattern NAMED_PARAMETER_BINDING_PATTERN = Pattern.compile("\\:(\\w+)");
        private static final Pattern INDEX_BASED_EXPRESSION_PATTERN = Pattern.compile("\\?\\#\\{");
        private static final Pattern NAME_BASED_EXPRESSION_PATTERN = Pattern.compile("\\:\\#\\{");
        private static final Pattern INDEX_BASED_PROPERTY_PLACEHOLDER_PATTERN = Pattern.compile("\\?\\$\\{");
        private static final Pattern NAME_BASED_PROPERTY_PLACEHOLDER_PATTERN = Pattern.compile("\\:\\$\\{");
        private static final Set<Pattern> VALUE_EXPRESSION_PATTERNS = Set.of(INDEX_BASED_EXPRESSION_PATTERN, NAME_BASED_EXPRESSION_PATTERN, INDEX_BASED_PROPERTY_PLACEHOLDER_PATTERN, NAME_BASED_PROPERTY_PLACEHOLDER_PATTERN);
        private static final String ARGUMENT_PLACEHOLDER = "?_param_?";

        ParameterBindingParser() {
        }

        public static String parseAndCollectParameterBindingsFromQueryIntoBindings(String input, List<BindingContext.ParameterBinding> bindings, ValueExpressionParser expressionParser) {
            if (!StringUtils.hasText((String)input)) {
                return input;
            }
            Assert.notNull(bindings, (String)"Parameter bindings must not be null");
            return ParameterBindingParser.transformQueryAndCollectExpressionParametersIntoBindings(input, bindings, expressionParser);
        }

        private static String transformQueryAndCollectExpressionParametersIntoBindings(String input, List<BindingContext.ParameterBinding> bindings, ValueExpressionParser expressionParser) {
            Matcher matcher;
            StringBuilder result = new StringBuilder();
            int startIndex = 0;
            int currentPosition = 0;
            while (currentPosition < input.length() && (matcher = ParameterBindingParser.findNextBindingOrExpression(input, currentPosition)) != null) {
                int exprStart;
                currentPosition = exprStart = matcher.start();
                if (ParameterBindingParser.isValueExpression(matcher)) {
                    int curlyBraceOpenCount = 1;
                    currentPosition += 3;
                    block5: while (curlyBraceOpenCount > 0 && currentPosition < input.length()) {
                        switch (input.charAt(currentPosition++)) {
                            case '{': {
                                ++curlyBraceOpenCount;
                                continue block5;
                            }
                            case '}': {
                                --curlyBraceOpenCount;
                                continue block5;
                            }
                        }
                    }
                    result.append(input.subSequence(startIndex, exprStart));
                } else {
                    result.append(input.subSequence(startIndex, exprStart));
                }
                result.append(ARGUMENT_PLACEHOLDER);
                if (ParameterBindingParser.isValueExpression(matcher)) {
                    bindings.add(BindingContext.ParameterBinding.expression(expressionParser.parse(input.substring(exprStart + 1, currentPosition)), true));
                } else {
                    if (matcher.pattern() == INDEX_PARAMETER_BINDING_PATTERN) {
                        bindings.add(BindingContext.ParameterBinding.indexed(Integer.parseInt(matcher.group(1))));
                    } else {
                        bindings.add(BindingContext.ParameterBinding.named(matcher.group(1)));
                    }
                    currentPosition = matcher.end();
                }
                startIndex = currentPosition;
            }
            return result.append(input.subSequence(currentPosition, input.length())).toString();
        }

        private static boolean isValueExpression(Matcher matcher) {
            return VALUE_EXPRESSION_PATTERNS.contains(matcher.pattern());
        }

        @Nullable
        private static Matcher findNextBindingOrExpression(String input, int startPosition) {
            ArrayList<Matcher> matchers = new ArrayList<Matcher>(6);
            matchers.add(INDEX_PARAMETER_BINDING_PATTERN.matcher(input));
            matchers.add(NAMED_PARAMETER_BINDING_PATTERN.matcher(input));
            matchers.add(INDEX_BASED_EXPRESSION_PATTERN.matcher(input));
            matchers.add(NAME_BASED_EXPRESSION_PATTERN.matcher(input));
            matchers.add(INDEX_BASED_PROPERTY_PLACEHOLDER_PATTERN.matcher(input));
            matchers.add(NAME_BASED_PROPERTY_PLACEHOLDER_PATTERN.matcher(input));
            TreeMap<Integer, Matcher> matcherMap = new TreeMap<Integer, Matcher>();
            for (Matcher matcher : matchers) {
                if (!matcher.find(startPosition)) continue;
                matcherMap.put(matcher.start(), matcher);
            }
            return matcherMap.isEmpty() ? null : (Matcher)matcherMap.values().iterator().next();
        }
    }

    static class BindingContext {
        private final LdapParameters parameters;
        private final ParameterAccessor parameterAccessor;
        private final List<ParameterBinding> bindings;
        private final Function<ValueExpression, Object> evaluator;

        BindingContext(LdapParameters parameters, ParameterAccessor parameterAccessor, List<ParameterBinding> bindings, Function<ValueExpression, Object> evaluator) {
            this.parameters = parameters;
            this.parameterAccessor = parameterAccessor;
            this.bindings = bindings;
            this.evaluator = evaluator;
        }

        private boolean hasBindings() {
            return !this.bindings.isEmpty();
        }

        public List<Object> getBindingValues() {
            if (!this.hasBindings()) {
                return Collections.emptyList();
            }
            ArrayList<Object> parameters = new ArrayList<Object>(this.bindings.size());
            for (ParameterBinding binding : this.bindings) {
                Object parameterValueForBinding = this.getParameterValueForBinding(binding);
                parameters.add(parameterValueForBinding);
            }
            return parameters;
        }

        @Nullable
        private Object getParameterValueForBinding(ParameterBinding binding) {
            if (binding.isExpression()) {
                return this.evaluator.apply(binding.getRequiredExpression());
            }
            int index = binding.isNamed() ? this.getParameterIndex(this.parameters, binding.getRequiredParameterName()) : binding.getParameterIndex();
            Object value = this.parameterAccessor.getBindableValue(index);
            if (value == null) {
                return null;
            }
            String toString = value.toString();
            LdapParameters.LdapParameter parameter = (LdapParameters.LdapParameter)this.parameters.getBindableParameter(index);
            return parameter.hasLdapEncoder() ? parameter.getLdapEncoder().encode(toString) : LdapEncoder.filterEncode((String)toString);
        }

        private int getParameterIndex(Parameters<?, ?> parameters, String parameterName) {
            for (Parameter parameter : parameters) {
                if (!parameter.getName().filter(it -> it.equals(parameterName)).isPresent()) continue;
                return parameter.getIndex();
            }
            throw new IllegalArgumentException(String.format("Invalid parameter name; Cannot resolve parameter [%s]", parameterName));
        }

        static class ParameterBinding {
            private final int parameterIndex;
            @Nullable
            private final ValueExpression expression;
            @Nullable
            private final String parameterName;

            private ParameterBinding(int parameterIndex, @Nullable ValueExpression expression, @Nullable String parameterName) {
                this.parameterIndex = parameterIndex;
                this.expression = expression;
                this.parameterName = parameterName;
            }

            static ParameterBinding expression(ValueExpression expression, boolean quoted) {
                return new ParameterBinding(-1, expression, null);
            }

            static ParameterBinding indexed(int parameterIndex) {
                return new ParameterBinding(parameterIndex, null, null);
            }

            static ParameterBinding named(String name) {
                return new ParameterBinding(-1, null, name);
            }

            boolean isNamed() {
                return this.parameterName != null;
            }

            int getParameterIndex() {
                return this.parameterIndex;
            }

            ValueExpression getRequiredExpression() {
                Assert.state((this.expression != null ? 1 : 0) != 0, (String)"ParameterBinding is not an expression");
                return this.expression;
            }

            boolean isExpression() {
                return this.expression != null;
            }

            String getRequiredParameterName() {
                Assert.state((this.parameterName != null ? 1 : 0) != 0, (String)"ParameterBinding is not named");
                return this.parameterName;
            }
        }
    }

    static class ParameterBinder {
        private static final String ARGUMENT_PLACEHOLDER = "?_param_?";
        private static final Pattern ARGUMENT_PLACEHOLDER_PATTERN = Pattern.compile(Pattern.quote("?_param_?"));

        ParameterBinder() {
        }

        public static String bind(String input, List<Object> parameters) {
            if (parameters.isEmpty()) {
                return input;
            }
            StringBuilder result = new StringBuilder();
            int startIndex = 0;
            int currentPosition = 0;
            int parameterIndex = 0;
            Matcher matcher = ARGUMENT_PLACEHOLDER_PATTERN.matcher(input);
            while (currentPosition < input.length() && matcher.find()) {
                int exprStart = matcher.start();
                result.append(input.subSequence(startIndex, exprStart)).append(parameters.get(parameterIndex));
                ++parameterIndex;
                startIndex = currentPosition = matcher.end();
            }
            return result.append(input.subSequence(currentPosition, input.length())).toString();
        }
    }
}

