/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.ldap.repository.support;

import javax.naming.Name;
import org.springframework.data.ldap.repository.support.LdapRepositoryFactory;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.lang.Nullable;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.util.Assert;

public class LdapRepositoryFactoryBean<T extends Repository<S, Name>, S>
extends RepositoryFactoryBeanSupport<T, S, Name> {
    @Nullable
    private LdapOperations ldapOperations;

    public LdapRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setLdapOperations(LdapOperations ldapOperations) {
        this.ldapOperations = ldapOperations;
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        Assert.state((this.ldapOperations != null ? 1 : 0) != 0, (String)"LdapOperations must be set");
        return new LdapRepositoryFactory(this.ldapOperations);
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.ldapOperations, (String)"LdapOperations must be set");
        super.afterPropertiesSet();
    }
}

