/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.ldap.repository.query;

import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.ldap.repository.query.LdapQueryMethod;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.util.Assert;

public abstract class AbstractLdapRepositoryQuery
implements RepositoryQuery {
    private final LdapQueryMethod queryMethod;
    private final Class<?> entityType;
    private final LdapOperations ldapOperations;

    public AbstractLdapRepositoryQuery(LdapQueryMethod queryMethod, Class<?> entityType, LdapOperations ldapOperations) {
        Assert.notNull((Object)((Object)queryMethod), (String)"MongoQueryMethod must not be null!");
        Assert.notNull(entityType, (String)"Entity type must not be null!");
        Assert.notNull((Object)ldapOperations, (String)"LdapOperations must not be null!");
        this.queryMethod = queryMethod;
        this.entityType = entityType;
        this.ldapOperations = ldapOperations;
    }

    public final Object execute(Object[] parameters) {
        LdapQuery query = this.createQuery(parameters);
        if (this.queryMethod.isCollectionQuery()) {
            return this.ldapOperations.find(query, this.entityType);
        }
        try {
            return this.ldapOperations.findOne(query, this.entityType);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    protected abstract LdapQuery createQuery(Object[] var1);

    protected Class<?> getEntityClass() {
        return this.entityType;
    }

    public final QueryMethod getQueryMethod() {
        return this.queryMethod;
    }
}

