/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.ldap.repository.query;

import java.util.Iterator;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.ldap.odm.annotations.Entry;
import org.springframework.ldap.odm.core.ObjectDirectoryMapper;
import org.springframework.ldap.query.ConditionCriteria;
import org.springframework.ldap.query.ContainerCriteria;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.util.Assert;

class LdapQueryCreator
extends AbstractQueryCreator<LdapQuery, ContainerCriteria> {
    private final Class<?> entityType;
    private final ObjectDirectoryMapper mapper;

    LdapQueryCreator(PartTree tree, Parameters<?, ?> parameters, Class<?> entityType, ObjectDirectoryMapper mapper, Object[] values) {
        super(tree, (ParameterAccessor)new ParametersParameterAccessor(parameters, values));
        Assert.notNull(entityType, (String)"Entity type must not be null!");
        Assert.notNull((Object)mapper, (String)"ObjectDirectoryMapper must not be null!");
        this.entityType = entityType;
        this.mapper = mapper;
    }

    protected ContainerCriteria create(Part part, Iterator<Object> iterator) {
        String base = this.entityType.getAnnotation(Entry.class).base();
        ConditionCriteria criteria = LdapQueryBuilder.query().base(base).where(this.getAttribute(part));
        return this.appendCondition(part, iterator, criteria);
    }

    private ContainerCriteria appendCondition(Part part, Iterator<Object> iterator, ConditionCriteria criteria) {
        Part.Type type = part.getType();
        String value = null;
        if (iterator.hasNext()) {
            value = iterator.next().toString();
        }
        switch (type) {
            case NEGATING_SIMPLE_PROPERTY: {
                return criteria.not().is(value);
            }
            case SIMPLE_PROPERTY: {
                return criteria.is(value);
            }
            case STARTING_WITH: {
                return criteria.like(value + "*");
            }
            case ENDING_WITH: {
                return criteria.like("*" + value);
            }
            case CONTAINING: {
                return criteria.like("*" + value + "*");
            }
            case LIKE: {
                return criteria.like(value);
            }
            case NOT_LIKE: {
                return criteria.not().like(value);
            }
            case GREATER_THAN_EQUAL: {
                return criteria.gte(value);
            }
            case LESS_THAN_EQUAL: {
                return criteria.lte(value);
            }
            case IS_NOT_NULL: {
                return criteria.isPresent();
            }
            case IS_NULL: {
                return criteria.not().isPresent();
            }
        }
        throw new IllegalArgumentException(String.format("%s queries are not supported for LDAP repositories", type));
    }

    private String getAttribute(Part part) {
        PropertyPath path = part.getProperty();
        if (path.hasNext()) {
            throw new IllegalArgumentException("Nested properties are not supported");
        }
        return this.mapper.attributeFor(this.entityType, path.getSegment());
    }

    protected ContainerCriteria and(Part part, ContainerCriteria base, Iterator<Object> iterator) {
        ConditionCriteria criteria = base.and(this.getAttribute(part));
        return this.appendCondition(part, iterator, criteria);
    }

    protected ContainerCriteria or(ContainerCriteria base, ContainerCriteria criteria) {
        return base.or(criteria);
    }

    protected LdapQuery complete(ContainerCriteria criteria, Sort sort) {
        return criteria;
    }
}

