/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.repository.support;

import com.querydsl.collections.AbstractCollQuery;
import com.querydsl.collections.CollQuery;
import com.querydsl.core.NonUniqueResultException;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.PathBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.convert.DtoInstantiatingConverter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.repository.support.KeyValueQuerydslUtils;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.ListQuerydslPredicateExecutor;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.util.Assert;

public class QuerydslKeyValuePredicateExecutor<T>
implements ListQuerydslPredicateExecutor<T> {
    private static final EntityPathResolver DEFAULT_ENTITY_PATH_RESOLVER = SimpleEntityPathResolver.INSTANCE;
    private final MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> context;
    private final PathBuilder<T> builder;
    private final Supplier<List<T>> findAll;
    private final EntityInformation<T, ?> entityInformation;
    private final ProjectionFactory projectionFactory;
    private final EntityInstantiators entityInstantiators = new EntityInstantiators();

    public QuerydslKeyValuePredicateExecutor(EntityInformation<T, ?> entityInformation, KeyValueOperations operations) {
        this(entityInformation, (ProjectionFactory)new SpelAwareProxyProjectionFactory(), operations, DEFAULT_ENTITY_PATH_RESOLVER);
    }

    public QuerydslKeyValuePredicateExecutor(EntityInformation<T, ?> entityInformation, ProjectionFactory projectionFactory, KeyValueOperations operations, EntityPathResolver resolver) {
        Assert.notNull(entityInformation, (String)"EntityInformation must not be null");
        Assert.notNull((Object)projectionFactory, (String)"ProjectionFactory must not be null");
        Assert.notNull((Object)operations, (String)"KeyValueOperations must not be null");
        Assert.notNull((Object)resolver, (String)"EntityPathResolver must not be null");
        this.projectionFactory = projectionFactory;
        this.context = operations.getMappingContext();
        EntityPath path = resolver.createPath(entityInformation.getJavaType());
        this.builder = new PathBuilder(path.getType(), path.getMetadata());
        this.entityInformation = entityInformation;
        this.findAll = () -> IterableConverter.toList(operations.findAll(entityInformation.getJavaType()));
    }

    public Optional<T> findOne(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        try {
            return Optional.ofNullable(this.prepareQuery(predicate).fetchOne());
        }
        catch (NonUniqueResultException o_O) {
            throw new IncorrectResultSizeDataAccessException("Expected one or no result but found more than one", 1, (Throwable)o_O);
        }
    }

    public List<T> findAll(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        return this.prepareQuery(predicate).fetchResults().getResults();
    }

    public List<T> findAll(Predicate predicate, OrderSpecifier<?> ... orders) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        Assert.notNull(orders, (String)"OrderSpecifiers must not be null");
        AbstractCollQuery<T, ?> query = this.prepareQuery(predicate);
        query.orderBy(orders);
        return query.fetchResults().getResults();
    }

    public List<T> findAll(Predicate predicate, Sort sort) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        return this.findAll(predicate, (OrderSpecifier[])KeyValueQuerydslUtils.toOrderSpecifier(sort, this.builder));
    }

    public Page<T> findAll(Predicate predicate, Pageable pageable) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        Assert.notNull((Object)pageable, (String)"Pageable must not be null");
        AbstractCollQuery<T, ?> query = this.prepareQuery(predicate);
        if (pageable.isPaged() || pageable.getSort().isSorted()) {
            query.offset(pageable.getOffset());
            query.limit((long)pageable.getPageSize());
            if (pageable.getSort().isSorted()) {
                query.orderBy(KeyValueQuerydslUtils.toOrderSpecifier(pageable.getSort(), this.builder));
            }
        }
        return new PageImpl(query.fetchResults().getResults(), pageable, this.count(predicate));
    }

    public List<T> findAll(OrderSpecifier<?> ... orders) {
        Assert.notNull(orders, (String)"OrderSpecifiers must not be null");
        if (orders.length == 0) {
            return this.findAll.get();
        }
        AbstractCollQuery<T, ?> query = this.prepareQuery(null);
        query.orderBy(orders);
        return query.fetchResults().getResults();
    }

    public long count(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        return this.prepareQuery(predicate).fetchCount();
    }

    public boolean exists(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        return this.count(predicate) > 0L;
    }

    public <S extends T, R> R findBy(Predicate predicate, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        Assert.notNull(queryFunction, (String)"Query function must not be null");
        return queryFunction.apply(new FluentQuerydsl(predicate, this.entityInformation.getJavaType()));
    }

    protected AbstractCollQuery<T, ?> prepareQuery(@Nullable Predicate predicate) {
        CollQuery query = new CollQuery();
        query.from(this.builder, (Iterable)this.findAll.get());
        return predicate != null ? (AbstractCollQuery)query.where(predicate) : query;
    }

    class FluentQuerydsl<R>
    implements FluentQuery.FetchableFluentQuery<R> {
        private final Predicate predicate;
        private final Sort sort;
        private final Class<?> entityType;
        private final Class<R> resultType;
        private final List<String> fieldsToInclude;

        FluentQuerydsl(Predicate predicate, Class<R> resultType) {
            this(predicate, Sort.unsorted(), resultType, resultType, Collections.emptyList());
        }

        public FluentQuerydsl(Predicate predicate, Sort sort, Class<?> entityType, Class<R> resultType, List<String> fieldsToInclude) {
            this.predicate = predicate;
            this.sort = sort;
            this.entityType = entityType;
            this.resultType = resultType;
            this.fieldsToInclude = fieldsToInclude;
        }

        public FluentQuery.FetchableFluentQuery<R> sortBy(Sort sort) {
            Assert.notNull((Object)sort, (String)"Sort must not be null");
            return new FluentQuerydsl<R>(this.predicate, sort, this.entityType, this.resultType, this.fieldsToInclude);
        }

        public <NR> FluentQuery.FetchableFluentQuery<NR> as(Class<NR> projection) {
            Assert.notNull(projection, (String)"Projection target type must not be null");
            return new FluentQuerydsl<NR>(this.predicate, this.sort, this.entityType, projection, this.fieldsToInclude);
        }

        public FluentQuery.FetchableFluentQuery<R> project(Collection<String> properties) {
            Assert.notNull(properties, (String)"Projection properties must not be null");
            return new FluentQuerydsl<R>(this.predicate, this.sort, this.entityType, this.resultType, new ArrayList<String>(properties));
        }

        public @Nullable R oneValue() {
            List results = ((AbstractCollQuery)this.createQuery().limit(2L)).fetch();
            if (results.isEmpty()) {
                return null;
            }
            if (results.size() > 1) {
                throw new IncorrectResultSizeDataAccessException(1);
            }
            Object one = results.get(0);
            return this.getConversionFunction().apply(one);
        }

        public @Nullable R firstValue() {
            List results = ((AbstractCollQuery)this.createQuery().limit(1L)).fetch();
            if (results.isEmpty()) {
                return null;
            }
            Object one = results.get(0);
            return this.getConversionFunction().apply(one);
        }

        public List<R> all() {
            List results = this.createQuery().fetch();
            return this.mapResults(results);
        }

        public Page<R> page(Pageable pageable) {
            Assert.notNull((Object)pageable, (String)"Pageable must not be null");
            AbstractCollQuery query = this.createQuery();
            if (pageable.isPaged() || pageable.getSort().isSorted()) {
                query.offset(pageable.getOffset());
                query.limit((long)pageable.getPageSize());
                if (pageable.getSort().isSorted()) {
                    query.orderBy(KeyValueQuerydslUtils.toOrderSpecifier(pageable.getSort(), QuerydslKeyValuePredicateExecutor.this.builder));
                }
            }
            QueryResults results = ((AbstractCollQuery)((AbstractCollQuery)query.limit((long)pageable.getPageSize())).offset(pageable.getOffset())).fetchResults();
            return new PageImpl(this.mapResults(results.getResults()), pageable, results.getTotal());
        }

        public Stream<R> stream() {
            return this.createQuery().stream().map(this.getConversionFunction());
        }

        public long count() {
            return this.createQuery().fetchCount();
        }

        public boolean exists() {
            return this.count() > 0L;
        }

        private AbstractCollQuery<T, ?> createQuery() {
            AbstractCollQuery query = QuerydslKeyValuePredicateExecutor.this.prepareQuery(this.predicate);
            if (this.sort.isSorted()) {
                query.orderBy(KeyValueQuerydslUtils.toOrderSpecifier(this.sort, QuerydslKeyValuePredicateExecutor.this.builder));
            }
            return query;
        }

        private List<R> mapResults(List<T> results) {
            if (this.entityType == this.resultType) {
                return results;
            }
            ArrayList<R> mapped = new ArrayList<R>(results.size());
            Function<Object, R> converter = this.getConversionFunction();
            for (Object result : results) {
                mapped.add(converter.apply(result));
            }
            return mapped;
        }

        private <P> Function<Object, P> getConversionFunction(Class<?> inputType, Class<P> targetType) {
            if (targetType.isAssignableFrom(inputType)) {
                return Function.identity();
            }
            if (targetType.isInterface()) {
                return o -> QuerydslKeyValuePredicateExecutor.this.projectionFactory.createProjection(targetType, o);
            }
            DtoInstantiatingConverter converter = new DtoInstantiatingConverter(targetType, QuerydslKeyValuePredicateExecutor.this.context, QuerydslKeyValuePredicateExecutor.this.entityInstantiators);
            return o -> converter.convert(o);
        }

        private Function<Object, R> getConversionFunction() {
            return this.getConversionFunction(this.entityType, this.resultType);
        }
    }
}

