/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.keyvalue.core.SimplePropertyPathAccessor;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.lang.Contract;

public class PropertyPathComparator<T>
implements Comparator<T> {
    private static final Comparator<?> NULLS_FIRST = Comparator.nullsFirst(Comparator.naturalOrder());
    private static final Comparator<?> NULLS_LAST = Comparator.nullsLast(Comparator.naturalOrder());
    private final String path;
    private boolean asc = true;
    private boolean nullsFirst = true;
    private final Map<Class<?>, PropertyPath> pathCache = new HashMap(2);

    public PropertyPathComparator(String path) {
        this.path = path;
    }

    @Override
    public int compare(@Nullable T o1, @Nullable T o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return this.nullsFirst ? 1 : -1;
        }
        if (o2 == null) {
            return this.nullsFirst ? 1 : -1;
        }
        PropertyPath propertyPath = this.pathCache.computeIfAbsent(o1.getClass(), it -> PropertyPath.from((String)this.path, (Class)it));
        Object value1 = this.getCompareValue(o1, propertyPath);
        Object value2 = this.getCompareValue(o2, propertyPath);
        return this.getComparator().compare(value1, value2) * (this.asc ? 1 : -1);
    }

    protected <S> @Nullable Object getCompareValue(S object, PropertyPath propertyPath) {
        return new SimplePropertyPathAccessor(object).getValue(propertyPath);
    }

    private Comparator<@Nullable Object> getComparator() {
        return this.nullsFirst ? NULLS_FIRST : NULLS_LAST;
    }

    @Contract(value="-> this")
    public PropertyPathComparator<@Nullable T> asc() {
        this.asc = true;
        return this;
    }

    @Contract(value="-> this")
    public PropertyPathComparator<@Nullable T> desc() {
        this.asc = false;
        return this;
    }

    @Contract(value="-> this")
    public PropertyPathComparator<@Nullable T> nullsFirst() {
        this.nullsFirst = true;
        return this;
    }

    @Contract(value="-> this")
    public PropertyPathComparator<@Nullable T> nullsLast() {
        this.nullsFirst = false;
        return this;
    }
}

