/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import java.io.Serializable;
import java.util.Collection;
import org.springframework.data.keyvalue.core.KeyValueAdapter;
import org.springframework.data.keyvalue.core.QueryEngine;
import org.springframework.data.keyvalue.core.SpelQueryEngine;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;

public abstract class AbstractKeyValueAdapter
implements KeyValueAdapter {
    private final QueryEngine<? extends KeyValueAdapter, ?, ?> engine;

    protected AbstractKeyValueAdapter() {
        this(null);
    }

    protected AbstractKeyValueAdapter(QueryEngine<? extends KeyValueAdapter, ?, ?> engine) {
        this.engine = engine != null ? engine : new SpelQueryEngine();
        this.engine.registerAdapter(this);
    }

    protected QueryEngine<? extends KeyValueAdapter, ?, ?> getQueryEngine() {
        return this.engine;
    }

    public Collection<?> find(KeyValueQuery<?> query, Serializable keyspace) {
        return this.engine.execute(query, keyspace);
    }

    @Override
    public long count(KeyValueQuery<?> query, Serializable keyspace) {
        return this.engine.count(query, keyspace);
    }
}

