/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.repository.support;

import com.mysema.query.collections.CollQuery;
import com.mysema.query.support.ProjectableQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.path.PathBuilder;
import java.io.Serializable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.repository.support.KeyValueQuerydslUtils;
import org.springframework.data.keyvalue.repository.support.SimpleKeyValueRepository;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class QuerydslKeyValueRepository<T, ID extends Serializable>
extends SimpleKeyValueRepository<T, ID>
implements QueryDslPredicateExecutor<T> {
    private static final EntityPathResolver DEFAULT_ENTITY_PATH_RESOLVER = SimpleEntityPathResolver.INSTANCE;
    private final EntityPath<T> path;
    private final PathBuilder<T> builder;

    public QuerydslKeyValueRepository(EntityInformation<T, ID> entityInformation, KeyValueOperations operations) {
        this(entityInformation, operations, DEFAULT_ENTITY_PATH_RESOLVER);
    }

    public QuerydslKeyValueRepository(EntityInformation<T, ID> entityInformation, KeyValueOperations operations, EntityPathResolver resolver) {
        super(entityInformation, operations);
        Assert.notNull((Object)resolver, (String)"EntityPathResolver must not be null!");
        this.path = resolver.createPath(entityInformation.getJavaType());
        this.builder = new PathBuilder(this.path.getType(), this.path.getMetadata());
    }

    @Override
    public T findOne(Predicate predicate) {
        return (T)this.prepareQuery(predicate).uniqueResult(this.builder);
    }

    public Iterable<T> findAll(Predicate predicate) {
        return this.prepareQuery(predicate).list(this.builder);
    }

    public Iterable<T> findAll(Predicate predicate, OrderSpecifier<?> ... orders) {
        ProjectableQuery<?> query = this.prepareQuery(predicate);
        query.orderBy(orders);
        return query.list(this.builder);
    }

    public Iterable<T> findAll(Predicate predicate, Sort sort) {
        return this.findAll(predicate, KeyValueQuerydslUtils.toOrderSpecifier(sort, this.builder));
    }

    public Page<T> findAll(Predicate predicate, Pageable pageable) {
        ProjectableQuery<?> query = this.prepareQuery(predicate);
        if (pageable != null) {
            query.offset((long)pageable.getOffset());
            query.limit((long)pageable.getPageSize());
            if (pageable.getSort() != null) {
                query.orderBy(KeyValueQuerydslUtils.toOrderSpecifier(pageable.getSort(), this.builder));
            }
        }
        return new PageImpl(query.list(this.builder), pageable, this.count(predicate));
    }

    public Iterable<T> findAll(OrderSpecifier<?> ... orders) {
        if (ObjectUtils.isEmpty((Object[])orders)) {
            return this.findAll();
        }
        ProjectableQuery<?> query = this.prepareQuery(null);
        query.orderBy(orders);
        return query.list(this.builder);
    }

    public long count(Predicate predicate) {
        return this.prepareQuery(predicate).count();
    }

    @Override
    public boolean exists(Predicate predicate) {
        return this.prepareQuery(predicate).exists();
    }

    protected ProjectableQuery<?> prepareQuery(Predicate predicate) {
        CollQuery query = new CollQuery();
        query.from(this.builder, this.findAll());
        if (predicate != null) {
            query.where(predicate);
        }
        return query;
    }
}

