/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.domain;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.StreamSupport;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jpa.domain.PredicateSpecification;
import org.springframework.data.jpa.domain.SpecificationComposition;
import org.springframework.lang.CheckReturnValue;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;

@FunctionalInterface
public interface Specification<T>
extends Serializable {
    public static <T> Specification<T> unrestricted() {
        return (root, query, builder) -> null;
    }

    public static <T> Specification<T> where(Specification<T> spec) {
        Assert.notNull(spec, (String)"Specification must not be null");
        return spec;
    }

    public static <T> Specification<T> where(PredicateSpecification<T> spec) {
        Assert.notNull(spec, (String)"PredicateSpecification must not be null");
        return (root, update, criteriaBuilder) -> spec.toPredicate((From)root, criteriaBuilder);
    }

    @Contract(value="_ -> new")
    @CheckReturnValue
    default public Specification<T> and(Specification<T> other) {
        Assert.notNull(other, (String)"Other specification must not be null");
        return SpecificationComposition.composed(this, other, CriteriaBuilder::and);
    }

    @Contract(value="_ -> new")
    @CheckReturnValue
    default public Specification<T> and(PredicateSpecification<T> other) {
        Assert.notNull(other, (String)"Other specification must not be null");
        return SpecificationComposition.composed(this, Specification.where(other), CriteriaBuilder::and);
    }

    @Contract(value="_ -> new")
    @CheckReturnValue
    default public Specification<T> or(Specification<T> other) {
        Assert.notNull(other, (String)"Other specification must not be null");
        return SpecificationComposition.composed(this, other, CriteriaBuilder::or);
    }

    @Contract(value="_ -> new")
    @CheckReturnValue
    default public Specification<T> or(PredicateSpecification<T> other) {
        Assert.notNull(other, (String)"Other specification must not be null");
        return SpecificationComposition.composed(this, Specification.where(other), CriteriaBuilder::or);
    }

    public static <T> Specification<T> not(Specification<T> spec) {
        Assert.notNull(spec, (String)"Specification must not be null");
        return (root, query, builder) -> {
            Predicate predicate = spec.toPredicate(root, query, builder);
            return predicate != null ? builder.not((Expression)predicate) : null;
        };
    }

    @SafeVarargs
    public static <T> Specification<T> allOf(Specification<T> ... specifications) {
        return Specification.allOf(Arrays.asList(specifications));
    }

    public static <T> Specification<T> allOf(Iterable<Specification<T>> specifications) {
        return StreamSupport.stream(specifications.spliterator(), false).reduce(Specification.unrestricted(), Specification::and);
    }

    @SafeVarargs
    public static <T> Specification<T> anyOf(Specification<T> ... specifications) {
        return Specification.anyOf(Arrays.asList(specifications));
    }

    public static <T> Specification<T> anyOf(Iterable<Specification<T>> specifications) {
        return StreamSupport.stream(specifications.spliterator(), false).reduce(Specification.unrestricted(), Specification::or);
    }

    @Nullable
    public Predicate toPredicate(Root<T> var1, CriteriaQuery<?> var2, CriteriaBuilder var3);
}

