/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.config;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.auditing.config.AuditingHandlerBeanDefinitionParser;
import org.springframework.data.config.ParsingUtils;
import org.springframework.util.ClassUtils;
import org.w3c.dom.Element;

public class AuditingBeanDefinitionParser
implements BeanDefinitionParser {
    static final String AUDITING_ENTITY_LISTENER_CLASS_NAME = "org.springframework.data.jpa.domain.support.AuditingEntityListener";
    private static final String AUDITING_BFPP_CLASS_NAME = "org.springframework.data.jpa.domain.support.AuditingBeanFactoryPostProcessor";
    private final AuditingHandlerBeanDefinitionParser auditingHandlerParser = new AuditingHandlerBeanDefinitionParser("jpaMappingContext");
    private final SpringConfiguredBeanDefinitionParser springConfiguredParser = new SpringConfiguredBeanDefinitionParser();

    public BeanDefinition parse(Element element, ParserContext parser) {
        this.springConfiguredParser.parse(element, parser);
        this.auditingHandlerParser.parse(element, parser);
        Object source = parser.getReaderContext().extractSource((Object)element);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)AUDITING_ENTITY_LISTENER_CLASS_NAME);
        builder.addPropertyValue("auditingHandler", (Object)ParsingUtils.getObjectFactoryBeanDefinition((String)this.auditingHandlerParser.getResolvedBeanName(), (Object)source));
        builder.setScope("prototype");
        this.registerInfrastructureBeanWithId(builder.getRawBeanDefinition(), AUDITING_ENTITY_LISTENER_CLASS_NAME, parser, element);
        RootBeanDefinition def = new RootBeanDefinition(AUDITING_BFPP_CLASS_NAME);
        this.registerInfrastructureBeanWithId((AbstractBeanDefinition)def, AUDITING_BFPP_CLASS_NAME, parser, element);
        return null;
    }

    private void registerInfrastructureBeanWithId(AbstractBeanDefinition def, String id, ParserContext context, Element element) {
        def.setRole(2);
        def.setSource(context.extractSource((Object)element));
        context.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)def, id));
    }

    private static class SpringConfiguredBeanDefinitionParser
    implements BeanDefinitionParser {
        private static final String BEAN_CONFIGURER_ASPECT_BEAN_NAME = "org.springframework.context.config.internalBeanConfigurerAspect";
        private static final String BEAN_CONFIGURER_ASPECT_CLASS_NAME = "org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect";

        private SpringConfiguredBeanDefinitionParser() {
        }

        @Nullable
        public BeanDefinition parse(Element element, ParserContext parserContext) {
            if (!parserContext.getRegistry().containsBeanDefinition(BEAN_CONFIGURER_ASPECT_BEAN_NAME)) {
                if (!ClassUtils.isPresent((String)BEAN_CONFIGURER_ASPECT_CLASS_NAME, (ClassLoader)this.getClass().getClassLoader())) {
                    parserContext.getReaderContext().error("Could not configure Spring Data JPA auditing-feature because spring-aspects.jar is not on the classpath;\nIf you want to use auditing please add spring-aspects.jar to the classpath", (Object)element);
                }
                RootBeanDefinition def = new RootBeanDefinition();
                def.setBeanClassName(BEAN_CONFIGURER_ASPECT_CLASS_NAME);
                def.setFactoryMethodName("aspectOf");
                def.setRole(2);
                def.setSource(parserContext.extractSource((Object)element));
                parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)def, BEAN_CONFIGURER_ASPECT_BEAN_NAME));
            }
            return null;
        }
    }
}

