/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jpa.repository.query.QueryInformation;
import org.springframework.data.jpa.repository.query.QueryRenderer;
import org.springframework.data.jpa.repository.query.QueryToken;
import org.springframework.data.jpa.repository.query.QueryTokenStream;
import org.springframework.data.jpa.repository.query.QueryTokens;

class QueryInformationHolder {
    @Nullable
    private String primaryFromAlias = null;
    @Nullable
    private List<QueryToken> projection;
    private boolean projectionProcessed;
    private boolean hasConstructorExpression = false;
    private @Nullable QueryInformation.StatementType statementType;

    QueryInformationHolder() {
    }

    @Nullable
    public String getAlias() {
        return this.primaryFromAlias;
    }

    public void capturePrimaryAlias(String alias) {
        if (this.primaryFromAlias != null) {
            return;
        }
        this.primaryFromAlias = alias;
    }

    public boolean hasConstructorExpression() {
        return this.hasConstructorExpression;
    }

    public void constructorExpressionPresent() {
        this.hasConstructorExpression = true;
    }

    public QueryInformation.StatementType getStatementType() {
        return this.statementType == null ? QueryInformation.StatementType.OTHER : this.statementType;
    }

    public void setStatementType(QueryInformation.StatementType statementType) {
        if (this.statementType == null) {
            this.statementType = statementType;
        }
    }

    public List<QueryToken> getProjection() {
        return this.projection == null ? List.of() : List.copyOf(this.projection);
    }

    public <C> void captureProjection(Collection<C> selections, Function<C, QueryTokenStream> tokenStreamFunction) {
        if (this.projectionProcessed) {
            return;
        }
        ArrayList<QueryToken> selectItemTokens = new ArrayList<QueryToken>(selections.size() * 2);
        for (C selection : selections) {
            if (!selectItemTokens.isEmpty()) {
                selectItemTokens.add(QueryTokens.TOKEN_COMMA);
            }
            selectItemTokens.add(QueryTokens.token(QueryRenderer.from(tokenStreamFunction.apply(selection)).render()));
        }
        this.projection = selectItemTokens;
        this.projectionProcessed = true;
    }
}

