/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.aot;

import jakarta.persistence.Converter;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.spi.PersistenceUnitInfo;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.engine.jdbc.connections.internal.UserSuppliedConnectionProviderImpl;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.hibernate.jpa.boot.internal.EntityManagerFactoryBuilderImpl;
import org.hibernate.jpa.boot.internal.PersistenceUnitInfoDescriptor;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.jspecify.annotations.Nullable;
import org.springframework.data.repository.config.AotRepositoryContext;
import org.springframework.data.util.Lazy;
import org.springframework.orm.jpa.persistenceunit.PersistenceManagedTypes;
import org.springframework.orm.jpa.persistenceunit.SpringPersistenceUnitInfo;

class AotMetamodel
implements Metamodel {
    private final Lazy<EntityManagerFactory> entityManagerFactory;
    private final Lazy<EntityManager> entityManager = Lazy.of(() -> this.getEntityManagerFactory().createEntityManager());

    public AotMetamodel(AotRepositoryContext repositoryContext) {
        this(repositoryContext.getResolvedTypes().stream().filter(AotMetamodel::isJakartaAnnotated).map(Class::getName).toList(), null);
    }

    private static boolean isJakartaAnnotated(Class<?> cls) {
        return cls.isAnnotationPresent(Entity.class) || cls.isAnnotationPresent(Embeddable.class) || cls.isAnnotationPresent(MappedSuperclass.class) || cls.isAnnotationPresent(Converter.class);
    }

    public AotMetamodel(PersistenceManagedTypes managedTypes) {
        this(managedTypes.getManagedClassNames(), managedTypes.getPersistenceUnitRootUrl());
    }

    public AotMetamodel(Collection<String> managedTypes, @Nullable URL persistenceUnitRootUrl) {
        SpringPersistenceUnitInfo persistenceUnitInfo = new SpringPersistenceUnitInfo(managedTypes.getClass().getClassLoader());
        persistenceUnitInfo.setPersistenceUnitName("AotMetamodel");
        persistenceUnitInfo.setPersistenceUnitRootUrl(persistenceUnitRootUrl);
        this.entityManagerFactory = AotMetamodel.init(() -> {
            managedTypes.forEach(arg_0 -> ((SpringPersistenceUnitInfo)persistenceUnitInfo).addManagedClassName(arg_0));
            persistenceUnitInfo.setPersistenceProviderClassName(HibernatePersistenceProvider.class.getName());
            return new PersistenceUnitInfoDescriptor(persistenceUnitInfo.asStandardPersistenceUnitInfo());
        });
    }

    public AotMetamodel(PersistenceUnitInfo unitInfo) {
        this.entityManagerFactory = AotMetamodel.init(() -> new PersistenceUnitInfoDescriptor(unitInfo));
    }

    static Lazy<EntityManagerFactory> init(Supplier<PersistenceUnitInfoDescriptor> unitInfo) {
        return Lazy.of(() -> new EntityManagerFactoryBuilderImpl((PersistenceUnitDescriptor)unitInfo.get(), Map.of("hibernate.dialect", H2Dialect.class.getName(), "hibernate.boot.allow_jdbc_metadata_access", "false", "hibernate.connection.provider_class", new UserSuppliedConnectionProviderImpl())).build());
    }

    private Metamodel getMetamodel() {
        return this.getEntityManagerFactory().getMetamodel();
    }

    public <X> EntityType<X> entity(Class<X> cls) {
        return this.getMetamodel().entity(cls);
    }

    public EntityType<?> entity(String s) {
        return this.getMetamodel().entity(s);
    }

    public <X> ManagedType<X> managedType(Class<X> cls) {
        return this.getMetamodel().managedType(cls);
    }

    public <X> EmbeddableType<X> embeddable(Class<X> cls) {
        return this.getMetamodel().embeddable(cls);
    }

    public Set<ManagedType<?>> getManagedTypes() {
        return this.getMetamodel().getManagedTypes();
    }

    public Set<EntityType<?>> getEntities() {
        return this.getMetamodel().getEntities();
    }

    public Set<EmbeddableType<?>> getEmbeddables() {
        return this.getMetamodel().getEmbeddables();
    }

    public EntityManager entityManager() {
        return (EntityManager)this.entityManager.get();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return (EntityManagerFactory)this.entityManagerFactory.get();
    }
}

