/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.EntityManager;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jpa.repository.query.AbstractStringBasedJpaQuery;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.JpaQueryConfiguration;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;

class SimpleJpaQuery
extends AbstractStringBasedJpaQuery {
    public SimpleJpaQuery(JpaQueryMethod method, EntityManager em, DeclaredQuery query, @Nullable DeclaredQuery countQuery, JpaQueryConfiguration queryConfiguration) {
        super(method, em, query, countQuery, queryConfiguration);
        this.validateQuery(this.getQuery().getQueryString(), "Validation failed for query for method %s", new Object[]{method});
        if (method.isPageQuery()) {
            this.validateQuery(this.getCountQuery().getQueryString(), String.format("Count query validation failed for method %s", new Object[]{method}), new Object[0]);
        }
    }

    private void validateQuery(String query, String errorMessage, Object ... arguments) {
        if (this.getQueryMethod().isProcedureQuery()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (EntityManager validatingEm = this.getEntityManager().getEntityManagerFactory().createEntityManager();){
                validatingEm.createQuery(query);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(String.format(errorMessage, arguments), e);
        }
    }
}

