/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.mapping;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.persistence.Access;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.persistence.metamodel.Metamodel;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.annotation.AccessType;
import org.springframework.data.jpa.mapping.JpaPersistentProperty;
import org.springframework.data.jpa.util.JpaMetamodel;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

class JpaPersistentPropertyImpl
extends AnnotationBasedPersistentProperty<JpaPersistentProperty>
implements JpaPersistentProperty {
    private static final Collection<Class<? extends Annotation>> ASSOCIATION_ANNOTATIONS;
    private static final Collection<Class<? extends Annotation>> ID_ANNOTATIONS;
    private static final Collection<Class<? extends Annotation>> UPDATEABLE_ANNOTATIONS;
    private final Boolean usePropertyAccess;
    private final TypeInformation<?> associationTargetType;
    private final boolean updateable;
    private final JpaMetamodel metamodel;

    public JpaPersistentPropertyImpl(Metamodel metamodel, Field field, PropertyDescriptor propertyDescriptor, PersistentEntity<?, JpaPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder) {
        super(field, propertyDescriptor, owner, simpleTypeHolder);
        Assert.notNull((Object)metamodel, (String)"Metamodel must not be null!");
        this.usePropertyAccess = this.detectPropertyAccess();
        this.associationTargetType = this.isAssociation() ? this.detectAssociationTargetType() : null;
        this.updateable = this.detectUpdatability();
        this.metamodel = new JpaMetamodel(metamodel);
    }

    public Class<?> getActualType() {
        return this.associationTargetType == null ? super.getActualType() : this.associationTargetType.getType();
    }

    public Iterable<? extends TypeInformation<?>> getPersistentEntityType() {
        return this.associationTargetType == null ? super.getPersistentEntityType() : Collections.singleton(this.associationTargetType);
    }

    public boolean isIdProperty() {
        for (Class<? extends Annotation> annotation : ID_ANNOTATIONS) {
            if (!this.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }

    public boolean isEntity() {
        return this.metamodel.isJpaManaged(this.getActualType());
    }

    public boolean isAssociation() {
        for (Class<? extends Annotation> annotationType : ASSOCIATION_ANNOTATIONS) {
            if (this.findAnnotation(annotationType) == null) continue;
            return true;
        }
        return this.getType().isAnnotationPresent(Embeddable.class);
    }

    public boolean isTransient() {
        return this.isAnnotationPresent(Transient.class) || super.isTransient();
    }

    protected Association<JpaPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    public boolean usePropertyAccess() {
        return this.usePropertyAccess != null ? this.usePropertyAccess.booleanValue() : super.usePropertyAccess();
    }

    public boolean isVersionProperty() {
        return this.isAnnotationPresent(Version.class);
    }

    public boolean isWritable() {
        return this.updateable && super.isWritable();
    }

    private Boolean detectPropertyAccess() {
        AccessType accessType = (AccessType)this.findAnnotation(AccessType.class);
        if (accessType != null) {
            return AccessType.Type.PROPERTY.equals((Object)accessType.value());
        }
        Access access = (Access)this.findAnnotation(Access.class);
        if (access != null) {
            return javax.persistence.AccessType.PROPERTY.equals((Object)access.value());
        }
        accessType = (AccessType)this.findPropertyOrOwnerAnnotation(AccessType.class);
        if (accessType != null) {
            return AccessType.Type.PROPERTY.equals((Object)accessType.value());
        }
        access = (Access)this.findPropertyOrOwnerAnnotation(Access.class);
        return access == null ? null : Boolean.valueOf(javax.persistence.AccessType.PROPERTY.equals((Object)access.value()));
    }

    private TypeInformation<?> detectAssociationTargetType() {
        for (Class<? extends Annotation> associationAnnotation : ASSOCIATION_ANNOTATIONS) {
            Annotation annotation = this.findAnnotation(associationAnnotation);
            Object targetEntity = AnnotationUtils.getValue((Annotation)annotation, (String)"targetEntity");
            if (targetEntity == null || Void.TYPE.equals(targetEntity)) continue;
            return ClassTypeInformation.from((Class)((Class)targetEntity));
        }
        return null;
    }

    private final boolean detectUpdatability() {
        for (Class<? extends Annotation> annotationType : UPDATEABLE_ANNOTATIONS) {
            Annotation annotation = this.findAnnotation(annotationType);
            if (annotation == null || !AnnotationUtils.getValue((Annotation)annotation, (String)"updatable").equals(Boolean.FALSE)) continue;
            return false;
        }
        return true;
    }

    static {
        HashSet<Class<OrderColumn>> annotations = new HashSet<Class<OrderColumn>>();
        annotations.add(OneToMany.class);
        annotations.add(OneToOne.class);
        annotations.add(ManyToMany.class);
        annotations.add(ManyToOne.class);
        annotations.add(Embedded.class);
        ASSOCIATION_ANNOTATIONS = Collections.unmodifiableSet(annotations);
        annotations = new HashSet();
        annotations.add(Id.class);
        annotations.add(EmbeddedId.class);
        ID_ANNOTATIONS = Collections.unmodifiableSet(annotations);
        annotations = new HashSet();
        annotations.add(Column.class);
        annotations.add(OrderColumn.class);
        UPDATEABLE_ANNOTATIONS = Collections.unmodifiableSet(annotations);
    }
}

