/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.Query;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.util.Assert;

public class ParameterBinder {
    private final Parameters parameters;
    private final Object[] values;

    public ParameterBinder(Parameters parameters, Object[] values) {
        Assert.notNull((Object)parameters);
        Assert.notNull((Object)values);
        Assert.isTrue((parameters.getNumberOfParameters() == values.length ? 1 : 0) != 0, (String)"Invalid number of parameters given!");
        this.parameters = parameters;
        this.values = (Object[])values.clone();
    }

    ParameterBinder(Parameters parameters) {
        this(parameters, new Object[0]);
    }

    public Pageable getPageable() {
        if (!this.parameters.hasPageableParameter()) {
            return null;
        }
        return (Pageable)this.values[this.parameters.getPageableIndex()];
    }

    public Sort getSort() {
        if (this.parameters.hasSortParameter()) {
            return (Sort)this.values[this.parameters.getSortIndex()];
        }
        if (this.parameters.hasPageableParameter() && this.getPageable() != null) {
            return this.getPageable().getSort();
        }
        return null;
    }

    public Query bind(Query query) {
        int methodParameterPosition = 0;
        int queryParameterPosition = 1;
        for (Parameter parameter : this.parameters) {
            if (parameter.isBindable()) {
                Object value = this.values[methodParameterPosition];
                this.bind(query, parameter, value, queryParameterPosition++);
            }
            ++methodParameterPosition;
        }
        return query;
    }

    protected void bind(Query query, Parameter parameter, Object value, int position) {
        if (this.hasNamedParameter(query) && parameter.isNamedParameter()) {
            query.setParameter(parameter.getName(), value);
        } else {
            query.setParameter(position, value);
        }
    }

    public Query bindAndPrepare(Query query) {
        return this.bindAndPrepare(query, this.parameters);
    }

    private Query bindAndPrepare(Query query, Parameters parameters) {
        Query result = this.bind(query);
        if (!parameters.hasPageableParameter() || this.getPageable() == null) {
            return result;
        }
        result.setFirstResult(this.getPageable().getOffset());
        result.setMaxResults(this.getPageable().getPageSize());
        return result;
    }

    boolean hasNamedParameter(Query query) {
        return QueryUtils.hasNamedParameter(query);
    }
}

