/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import org.springframework.data.jdbc.core.convert.SequenceEntityCallbackDelegate;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.conversion.MutableAggregateChange;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.mapping.event.BeforeSaveCallback;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.util.Assert;

public class IdGeneratingEntityCallback
implements BeforeSaveCallback<Object> {
    private final MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context;
    private final SequenceEntityCallbackDelegate delegate;

    public IdGeneratingEntityCallback(MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context, Dialect dialect, NamedParameterJdbcOperations operations) {
        this.context = context;
        this.delegate = new SequenceEntityCallbackDelegate(dialect, operations);
    }

    public Object onBeforeSave(Object aggregate, MutableAggregateChange<Object> aggregateChange) {
        Assert.notNull((Object)aggregate, (String)"Aggregate must not be null");
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(aggregate.getClass());
        if (!entity.hasIdProperty()) {
            return aggregate;
        }
        RelationalPersistentProperty property = (RelationalPersistentProperty)entity.getRequiredIdProperty();
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(aggregate);
        if (!entity.isNew(aggregate) || this.delegate.hasValue((PersistentProperty<?>)property, (PersistentPropertyAccessor<Object>)accessor) || !property.hasSequence()) {
            return aggregate;
        }
        this.delegate.generateSequenceValue(property, (PersistentPropertyAccessor<Object>)accessor);
        return accessor.getBean();
    }
}

