/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.Identifier;
import org.springframework.data.jdbc.core.convert.InsertSubject;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.JdbcIdentifierBuilder;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.PersistentPropertyPathAccessor;
import org.springframework.data.relational.core.conversion.DbAction;
import org.springframework.data.relational.core.conversion.DbActionExecutionResult;
import org.springframework.data.relational.core.conversion.IdValueSource;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.OptimisticLockingUtils;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.LockMode;
import org.springframework.data.util.Pair;
import org.springframework.util.Assert;

class JdbcAggregateChangeExecutionContext {
    private final RelationalMappingContext context;
    private final JdbcConverter converter;
    private final DataAccessStrategy accessStrategy;
    private final Map<DbAction<?>, DbActionExecutionResult> results = new LinkedHashMap();

    JdbcAggregateChangeExecutionContext(JdbcConverter converter, DataAccessStrategy accessStrategy) {
        this.converter = converter;
        this.context = converter.getMappingContext();
        this.accessStrategy = accessStrategy;
    }

    <T> void executeInsertRoot(DbAction.InsertRoot<T> insert) {
        Object id = this.accessStrategy.insert(insert.entity(), insert.getEntityType(), Identifier.empty(), insert.idValueSource());
        this.add(new DbActionExecutionResult(insert, id));
    }

    <T> void executeBatchInsertRoot(DbAction.BatchInsertRoot<T> batchInsertRoot) {
        List inserts = batchInsertRoot.getActions();
        List insertSubjects = inserts.stream().map(insert -> InsertSubject.describedBy(insert.entity(), Identifier.empty())).collect(Collectors.toList());
        Object[] ids = this.accessStrategy.insert(insertSubjects, batchInsertRoot.getEntityType(), (IdValueSource)batchInsertRoot.getBatchValue());
        for (int i = 0; i < inserts.size(); ++i) {
            this.add(new DbActionExecutionResult((DbAction.WithEntity)inserts.get(i), ids.length > 0 ? ids[i] : null));
        }
    }

    <T> void executeInsert(DbAction.Insert<T> insert) {
        Identifier parentKeys = this.getParentKeys((DbAction.WithDependingOn<?>)insert, this.converter);
        Object id = this.accessStrategy.insert(insert.entity(), insert.getEntityType(), parentKeys, insert.idValueSource());
        this.add(new DbActionExecutionResult(insert, id));
    }

    <T> void executeBatchInsert(DbAction.BatchInsert<T> batchInsert) {
        List inserts = batchInsert.getActions();
        List insertSubjects = inserts.stream().map(insert -> InsertSubject.describedBy(insert.entity(), this.getParentKeys((DbAction.WithDependingOn<?>)insert, this.converter))).collect(Collectors.toList());
        Object[] ids = this.accessStrategy.insert(insertSubjects, batchInsert.getEntityType(), (IdValueSource)batchInsert.getBatchValue());
        for (int i = 0; i < inserts.size(); ++i) {
            this.add(new DbActionExecutionResult((DbAction.WithEntity)inserts.get(i), ids.length > 0 ? ids[i] : null));
        }
    }

    <T> void executeUpdateRoot(DbAction.UpdateRoot<T> update) {
        if (update.getPreviousVersion() != null) {
            this.updateWithVersion(update);
        } else {
            this.updateWithoutVersion(update);
        }
        this.add(new DbActionExecutionResult(update));
    }

    <T> void executeDeleteRoot(DbAction.DeleteRoot<T> delete) {
        if (delete.previousVersion() != null) {
            this.accessStrategy.deleteWithVersion(delete.id(), delete.getEntityType(), delete.previousVersion());
        } else {
            this.accessStrategy.delete(delete.id(), delete.getEntityType());
        }
    }

    <T> void executeBatchDeleteRoot(DbAction.BatchDeleteRoot<T> batchDelete) {
        List<Object> rootIds = batchDelete.getActions().stream().map(DbAction.DeleteRoot::id).toList();
        this.accessStrategy.delete(rootIds, batchDelete.getEntityType());
    }

    <T> void executeDelete(DbAction.Delete<T> delete) {
        this.accessStrategy.delete(delete.rootId(), (PersistentPropertyPath<RelationalPersistentProperty>)delete.propertyPath());
    }

    <T> void executeBatchDelete(DbAction.BatchDelete<T> batchDelete) {
        List<Object> rootIds = batchDelete.getActions().stream().map(DbAction.Delete::rootId).toList();
        this.accessStrategy.delete(rootIds, (PersistentPropertyPath<RelationalPersistentProperty>)((PersistentPropertyPath)batchDelete.getBatchValue()));
    }

    <T> void executeDeleteAllRoot(DbAction.DeleteAllRoot<T> deleteAllRoot) {
        this.accessStrategy.deleteAll(deleteAllRoot.getEntityType());
    }

    <T> void executeDeleteAll(DbAction.DeleteAll<T> delete) {
        this.accessStrategy.deleteAll((PersistentPropertyPath<RelationalPersistentProperty>)delete.propertyPath());
    }

    <T> void executeAcquireLock(DbAction.AcquireLockRoot<T> acquireLock) {
        this.accessStrategy.acquireLockById(acquireLock.getId(), LockMode.PESSIMISTIC_WRITE, acquireLock.getEntityType());
    }

    <T> void executeAcquireLockAllRoot(DbAction.AcquireLockAllRoot<T> acquireLock) {
        this.accessStrategy.acquireLockAll(LockMode.PESSIMISTIC_WRITE, acquireLock.getEntityType());
    }

    private void add(DbActionExecutionResult result) {
        this.results.put((DbAction<?>)result.getAction(), result);
    }

    private Identifier getParentKeys(DbAction.WithDependingOn<?> action, JdbcConverter converter) {
        Object id = this.getParentId(action);
        AggregatePath aggregatePath = this.context.getAggregatePath(action.propertyPath());
        JdbcIdentifierBuilder identifier = JdbcIdentifierBuilder.forBackReferences(converter, aggregatePath, JdbcAggregateChangeExecutionContext.getIdMapper(id, aggregatePath, converter));
        for (Map.Entry qualifier : action.qualifiers().entrySet()) {
            identifier = identifier.withQualifier(this.context.getAggregatePath((PersistentPropertyPath)qualifier.getKey()), qualifier.getValue());
        }
        return identifier.build();
    }

    static Function<AggregatePath, Object> getIdMapper(Object idValue, AggregatePath path, JdbcConverter converter) {
        RelationalPersistentProperty idProperty = path.getIdDefiningParentPath().getRequiredIdProperty();
        RelationalPersistentEntity entity = converter.getMappingContext().getPersistentEntity(idProperty);
        if (entity == null) {
            return aggregatePath -> idValue;
        }
        PersistentPropertyPathAccessor propertyPathAccessor = entity.getPropertyPathAccessor(idValue);
        return aggregatePath -> propertyPathAccessor.getProperty(aggregatePath.getSubPathBasedOn(idProperty.getActualType()).getRequiredPersistentPropertyPath());
    }

    private Object getParentId(DbAction.WithDependingOn<?> action) {
        DbAction.WithEntity<?> idOwningAction = this.getIdOwningAction((DbAction.WithEntity<?>)action, this.context.getAggregatePath(action.propertyPath()).getIdDefiningParentPath());
        return this.getPotentialGeneratedIdFrom(idOwningAction);
    }

    private DbAction.WithEntity<?> getIdOwningAction(DbAction.WithEntity<?> action, AggregatePath idPath) {
        if (!(action instanceof DbAction.WithDependingOn)) {
            Assert.state((boolean)idPath.isRoot(), (String)"When the id path is not empty the id providing action should be of type WithDependingOn");
            return action;
        }
        DbAction.WithDependingOn withDependingOn = (DbAction.WithDependingOn)action;
        if (idPath.equals((Object)this.context.getAggregatePath(withDependingOn.propertyPath()))) {
            return action;
        }
        return this.getIdOwningAction(withDependingOn.dependingOn(), idPath);
    }

    private Object getPotentialGeneratedIdFrom(DbAction.WithEntity<?> idOwningAction) {
        DbActionExecutionResult dbActionExecutionResult;
        Object generatedId;
        if (IdValueSource.GENERATED.equals((Object)idOwningAction.idValueSource()) && (generatedId = Optional.ofNullable(dbActionExecutionResult = this.results.get(idOwningAction)).map(DbActionExecutionResult::getGeneratedId).orElse(null)) != null) {
            return generatedId;
        }
        return this.getIdFrom(idOwningAction);
    }

    private Object getIdFrom(DbAction.WithEntity<?> idOwningAction) {
        RelationalPersistentEntity persistentEntity = this.getRequiredPersistentEntity(idOwningAction.getEntityType());
        Object identifier = persistentEntity.getIdentifierAccessor(idOwningAction.entity()).getIdentifier();
        Assert.state((identifier != null ? 1 : 0) != 0, () -> "Couldn't obtain a required id value for " + String.valueOf(persistentEntity));
        return identifier;
    }

    <T> List<T> populateIdsIfNecessary() {
        ArrayList<DbActionExecutionResult> reverseResults = new ArrayList<DbActionExecutionResult>(this.results.values());
        Collections.reverse(reverseResults);
        StagedValues cascadingValues = new StagedValues();
        ArrayList<Object> roots = new ArrayList<Object>(reverseResults.size());
        for (DbActionExecutionResult result : reverseResults) {
            Object qualifierValue;
            DbAction.WithEntity action = result.getAction();
            Object newEntity = this.setIdAndCascadingProperties(action, result.getGeneratedId(), cascadingValues);
            if (action instanceof DbAction.InsertRoot || action instanceof DbAction.UpdateRoot) {
                roots.add(newEntity);
            }
            if (!(action instanceof DbAction.Insert)) continue;
            DbAction.Insert insert = (DbAction.Insert)action;
            Pair qualifier = insert.getQualifier();
            Object object = qualifierValue = qualifier == null ? null : qualifier.getSecond();
            if (newEntity != action.entity()) {
                cascadingValues.stage((DbAction<?>)insert.dependingOn(), insert.propertyPath(), qualifierValue, newEntity);
                continue;
            }
            if (!((RelationalPersistentProperty)insert.propertyPath().getLeafProperty()).isCollectionLike()) continue;
            cascadingValues.gather((DbAction<?>)insert.dependingOn(), insert.propertyPath(), qualifierValue, newEntity);
        }
        if (roots.isEmpty()) {
            throw new IllegalStateException(String.format("Cannot retrieve the resulting instance(s) unless a %s or %s action was successfully executed", DbAction.InsertRoot.class.getName(), DbAction.UpdateRoot.class.getName()));
        }
        Collections.reverse(roots);
        return roots;
    }

    private <S> Object setIdAndCascadingProperties(DbAction.WithEntity<S> action, @Nullable Object generatedId, StagedValues cascadingValues) {
        Object originalEntity = action.entity();
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(action.getEntityType());
        PersistentPropertyPathAccessor propertyAccessor = this.converter.getPropertyAccessor((PersistentEntity)persistentEntity, originalEntity);
        if (IdValueSource.GENERATED.equals((Object)action.idValueSource())) {
            propertyAccessor.setProperty(persistentEntity.getRequiredIdProperty(), generatedId);
        }
        cascadingValues.forEachPath((DbAction<?>)action, (persistentPropertyPath, o) -> propertyAccessor.setProperty(this.getRelativePath((DbAction<?>)action, (PersistentPropertyPath<?>)persistentPropertyPath), o));
        return propertyAccessor.getBean();
    }

    private PersistentPropertyPath<?> getRelativePath(DbAction<?> action, PersistentPropertyPath<?> pathToValue) {
        if (action instanceof DbAction.Insert) {
            DbAction.Insert insert = (DbAction.Insert)action;
            return pathToValue.getExtensionForBaseOf(insert.propertyPath());
        }
        if (action instanceof DbAction.InsertRoot) {
            return pathToValue;
        }
        if (action instanceof DbAction.UpdateRoot) {
            return pathToValue;
        }
        throw new IllegalArgumentException(String.format("DbAction of type %s is not supported", action.getClass()));
    }

    private <T> RelationalPersistentEntity<T> getRequiredPersistentEntity(Class<T> type) {
        return (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(type);
    }

    private <T> void updateWithoutVersion(DbAction.UpdateRoot<T> update) {
        this.accessStrategy.update(update.entity(), update.getEntityType());
    }

    private <T> void updateWithVersion(DbAction.UpdateRoot<T> update) {
        Number previousVersion = update.getPreviousVersion();
        Assert.notNull((Object)previousVersion, (String)"The root aggregate cannot be updated because the version property is null");
        if (!this.accessStrategy.updateWithVersion(update.entity(), update.getEntityType(), previousVersion)) {
            throw OptimisticLockingUtils.updateFailed((Object)update.entity(), (Object)previousVersion, this.getRequiredPersistentEntity(update.getEntityType()));
        }
    }

    private static class StagedValues {
        static final List<MultiValueAggregator<?>> aggregators = Arrays.asList(SetAggregator.INSTANCE, MapAggregator.INSTANCE, ListAggregator.INSTANCE, SingleElementAggregator.INSTANCE);
        Map<DbAction, Map<PersistentPropertyPath, StagedValue>> values = new HashMap<DbAction, Map<PersistentPropertyPath, StagedValue>>();

        private StagedValues() {
        }

        void stage(DbAction<?> action, PersistentPropertyPath path, @Nullable Object qualifier, Object value) {
            StagedValue gather = this.gather(action, path, qualifier, value);
            gather.isStaged = true;
        }

        <T> StagedValue gather(DbAction<?> action, PersistentPropertyPath path, @Nullable Object qualifier, Object value) {
            MultiValueAggregator<Object> aggregator = this.getAggregatorFor(path);
            Map valuesForPath = this.values.computeIfAbsent(action, dbAction -> new HashMap());
            StagedValue stagedValue = valuesForPath.computeIfAbsent(path, persistentPropertyPath -> new StagedValue(aggregator.createEmptyInstance()));
            Object currentValue = stagedValue.value;
            stagedValue.value = aggregator.add(currentValue, qualifier, value);
            valuesForPath.put(path, stagedValue);
            return stagedValue;
        }

        private <T> MultiValueAggregator<T> getAggregatorFor(PersistentPropertyPath path) {
            PersistentProperty property = path.getLeafProperty();
            for (MultiValueAggregator<?> aggregator : aggregators) {
                if (!aggregator.handles(property)) continue;
                return aggregator;
            }
            throw new IllegalStateException(String.format("Can't handle path %s", path));
        }

        void forEachPath(DbAction<?> dbAction, BiConsumer<PersistentPropertyPath, Object> action) {
            this.values.getOrDefault(dbAction, Collections.emptyMap()).forEach((persistentPropertyPath, stagedValue) -> {
                if (stagedValue.isStaged) {
                    action.accept((PersistentPropertyPath)persistentPropertyPath, stagedValue.value);
                }
            });
        }
    }

    private static class StagedValue {
        @Nullable Object value;
        boolean isStaged;

        public StagedValue(@Nullable Object value) {
            this.value = value;
        }
    }

    private static enum SingleElementAggregator implements MultiValueAggregator<Object>
    {
        INSTANCE;


        @Override
        public @Nullable Object createEmptyInstance() {
            return null;
        }

        @Override
        public Object add(@Nullable Object __null, @Nullable Object qualifier, Object value) {
            return value;
        }
    }

    private static enum MapAggregator implements MultiValueAggregator<Map>
    {
        INSTANCE;


        @Override
        public Class<Map> handledType() {
            return Map.class;
        }

        @Override
        public Map createEmptyInstance() {
            return new HashMap();
        }

        @Override
        public Map add(@Nullable Map map, @Nullable Object qualifier, Object value) {
            Assert.notNull((Object)map, (String)"Map must not be null");
            map.put(qualifier, value);
            return map;
        }
    }

    private static enum ListAggregator implements MultiValueAggregator<List>
    {
        INSTANCE;


        @Override
        public boolean handles(PersistentProperty property) {
            return property.isCollectionLike();
        }

        @Override
        public List createEmptyInstance() {
            return new ArrayList();
        }

        @Override
        public List add(@Nullable List list, @Nullable Object qualifier, Object value) {
            Assert.notNull((Object)list, (String)"List must not be null");
            Assert.notNull((Object)qualifier, (String)"ListAggregator can't handle a null qualifier");
            int index = (Integer)qualifier;
            if (index >= list.size()) {
                list.add(value);
            } else {
                list.add(index, value);
            }
            return list;
        }
    }

    private static enum SetAggregator implements MultiValueAggregator<Set>
    {
        INSTANCE;


        @Override
        public Class<Set> handledType() {
            return Set.class;
        }

        @Override
        public Set createEmptyInstance() {
            return new HashSet();
        }

        @Override
        public Set add(@Nullable Set set, @Nullable Object qualifier, Object value) {
            Assert.notNull((Object)set, (String)"Set must not be null");
            set.add(value);
            return set;
        }
    }

    static interface MultiValueAggregator<T> {
        default public Class<? super T> handledType() {
            return Object.class;
        }

        default public boolean handles(PersistentProperty property) {
            return this.handledType().isAssignableFrom(property.getType());
        }

        public @Nullable T createEmptyInstance();

        public T add(@Nullable T var1, @Nullable Object var2, Object var3);
    }
}

