/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.aot;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.jdbc.core.JdbcAggregateOperations;
import org.springframework.data.jdbc.core.convert.QueryMappingConfiguration;
import org.springframework.data.jdbc.core.dialect.JdbcDialect;
import org.springframework.data.jdbc.repository.aot.AotQueries;
import org.springframework.data.jdbc.repository.aot.AotRepositoryFragmentSupport;
import org.springframework.data.jdbc.repository.aot.JdbcCodeBlocks;
import org.springframework.data.jdbc.repository.aot.QueriesFactory;
import org.springframework.data.jdbc.repository.query.JdbcQueryMethod;
import org.springframework.data.jdbc.repository.query.Modifying;
import org.springframework.data.jdbc.repository.query.Query;
import org.springframework.data.jdbc.repository.query.RowMapperFactory;
import org.springframework.data.jdbc.repository.support.BeanFactoryAwareRowMapperFactory;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.repository.Lock;
import org.springframework.data.repository.aot.generate.AotRepositoryClassBuilder;
import org.springframework.data.repository.aot.generate.AotRepositoryConstructorBuilder;
import org.springframework.data.repository.aot.generate.MethodContributor;
import org.springframework.data.repository.aot.generate.RepositoryContributor;
import org.springframework.data.repository.config.AotRepositoryContext;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.TypeName;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class JdbcRepositoryContributor
extends RepositoryContributor {
    private final RelationalMappingContext mappingContext;
    private final QueriesFactory queriesFactory;
    private final @Nullable String jdbcAggregateOperationsRef;

    public JdbcRepositoryContributor(AotRepositoryContext repositoryContext, JdbcDialect dialect, RelationalMappingContext mappingContext) {
        super(repositoryContext);
        this.mappingContext = mappingContext;
        RepositoryConfigurationSource configurationSource = repositoryContext.getConfigurationSource();
        this.queriesFactory = new QueriesFactory(configurationSource, dialect, mappingContext, repositoryContext.getRequiredClassLoader(), ValueExpressionDelegate.create());
        this.jdbcAggregateOperationsRef = configurationSource.getAttribute("jdbcAggregateOperationsRef").orElse(null);
    }

    protected void customizeClass(AotRepositoryClassBuilder classBuilder) {
        classBuilder.customize(builder -> builder.superclass(TypeName.get(AotRepositoryFragmentSupport.class)));
    }

    protected void customizeConstructor(AotRepositoryConstructorBuilder constructorBuilder) {
        constructorBuilder.addParameter("operations", JdbcAggregateOperations.class, customizer -> customizer.origin((BeanReference)(StringUtils.hasText((String)this.jdbcAggregateOperationsRef) ? new RuntimeBeanReference(this.jdbcAggregateOperationsRef, JdbcAggregateOperations.class) : new RuntimeBeanReference(JdbcAggregateOperations.class))));
        constructorBuilder.addParameter("rowMapperFactory", RowMapperFactory.class, customizer -> customizer.origin(ctx -> {
            String rowMapperFactory = ctx.localVariable("rowMapperFactory");
            String operations = ctx.localVariable("operations");
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.addStatement("$1T $2L = new $1T($4L, $3L, $4L.getBeanProvider($5T.class).getIfUnique(() -> $5T.EMPTY))", new Object[]{BeanFactoryAwareRowMapperFactory.class, rowMapperFactory, operations, ctx.beanFactory(), QueryMappingConfiguration.class});
            return AotRepositoryConstructorBuilder.ParameterOrigin.of((String)rowMapperFactory, (CodeBlock)builder.build());
        }));
        constructorBuilder.addParameter("context", RepositoryFactoryBeanSupport.FragmentCreationContext.class, false);
    }

    protected @Nullable MethodContributor<? extends QueryMethod> contributeQueryMethod(Method method) {
        JdbcQueryMethod queryMethod = new JdbcQueryMethod(method, (RepositoryMetadata)this.getRepositoryInformation(), this.getProjectionFactory(), this.queriesFactory.getNamedQueries(), (MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty>)this.mappingContext);
        ReturnedType returnedType = queryMethod.getResultProcessor().getReturnedType();
        MergedAnnotation query = MergedAnnotations.from((AnnotatedElement)method).get(Query.class);
        AotQueries aotQueries = this.queriesFactory.createQueries(this.getRepositoryInformation(), returnedType, (MergedAnnotation<Query>)query, queryMethod);
        if (queryMethod.isModifyingQuery()) {
            TypeInformation returnType = this.getRepositoryInformation().getReturnType(method);
            boolean returnsCount = JdbcCodeBlocks.QueryExecutionBlockBuilder.returnsModifying(returnType.getType());
            boolean isVoid = ClassUtils.isVoidType((Class)returnType.getType());
            if (!returnsCount && !isVoid) {
                return MethodContributor.forQueryMethod((QueryMethod)queryMethod).metadataOnly(aotQueries.toMetadata());
            }
        }
        return MethodContributor.forQueryMethod((QueryMethod)queryMethod).withMetadata(aotQueries.toMetadata()).contribute(context -> {
            CodeBlock.Builder body = CodeBlock.builder();
            MergedAnnotation modifying = context.getAnnotation(Modifying.class);
            MergedAnnotation lock = context.getAnnotation(Lock.class);
            String queryVariable = context.localVariable("query");
            String parameterSourceVariable = context.localVariable("parameterSource");
            body.add(JdbcCodeBlocks.queryBuilder(context, queryMethod).filter(aotQueries).usingQueryVariableName(queryVariable).parameterSource(parameterSourceVariable).lock((MergedAnnotation<Lock>)lock).build());
            body.add("\n", new Object[0]);
            body.add(JdbcCodeBlocks.executionBuilder(context, queryMethod).modifying((MergedAnnotation<Modifying>)modifying).usingQueryVariableName(queryVariable).parameterSource(parameterSourceVariable).queries(aotQueries).queryAnnotation((MergedAnnotation<Query>)query).build());
            return body.build();
        });
    }
}

