/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.dialect;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.data.jdbc.core.dialect.JdbcArrayColumns;
import org.springframework.data.jdbc.core.dialect.JdbcArrayColumnsAdapter;
import org.springframework.data.jdbc.core.dialect.JdbcDb2Dialect;
import org.springframework.data.jdbc.core.dialect.JdbcDialect;
import org.springframework.data.jdbc.core.dialect.JdbcH2Dialect;
import org.springframework.data.jdbc.core.dialect.JdbcHsqlDbDialect;
import org.springframework.data.jdbc.core.dialect.JdbcMariaDbDialect;
import org.springframework.data.jdbc.core.dialect.JdbcMySqlDialect;
import org.springframework.data.jdbc.core.dialect.JdbcOracleDialect;
import org.springframework.data.jdbc.core.dialect.JdbcPostgresDialect;
import org.springframework.data.jdbc.core.dialect.JdbcSqlServerDialect;
import org.springframework.data.jdbc.repository.config.DialectResolver;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.dialect.Escaper;
import org.springframework.data.relational.core.dialect.IdGeneration;
import org.springframework.data.relational.core.dialect.InsertRenderContext;
import org.springframework.data.relational.core.dialect.LimitClause;
import org.springframework.data.relational.core.dialect.LockClause;
import org.springframework.data.relational.core.dialect.OrderByNullPrecedence;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.SimpleFunction;
import org.springframework.data.relational.core.sql.render.SelectRenderContext;
import org.springframework.data.util.Optionals;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.util.StringUtils;

public class DialectResolver {
    private static final Log LOG = LogFactory.getLog(DialectResolver.class);
    private static final List<JdbcDialectProvider> DETECTORS = SpringFactoriesLoader.loadFactories(JdbcDialectProvider.class, (ClassLoader)DialectResolver.class.getClassLoader());
    private static final List<DialectResolver.JdbcDialectProvider> LEGACY_DETECTORS = SpringFactoriesLoader.loadFactories(DialectResolver.JdbcDialectProvider.class, (ClassLoader)DialectResolver.class.getClassLoader());

    private DialectResolver() {
    }

    public static JdbcDialect getDialect(JdbcOperations operations) {
        return Stream.concat(LEGACY_DETECTORS.stream(), DETECTORS.stream()).map(it -> it.getDialect(operations)).flatMap(xva$0 -> Optionals.toStream((Optional[])new Optional[]{xva$0})).map(it -> {
            JdbcDialect jdbcDialect;
            if (it instanceof JdbcDialect) {
                JdbcDialect jd = (JdbcDialect)it;
                jdbcDialect = jd;
            } else {
                jdbcDialect = new JdbcDialectAdapter((Dialect)it);
            }
            return jdbcDialect;
        }).findFirst().orElseThrow(() -> new NoDialectException(String.format("Cannot determine a dialect for %s; Please provide a Dialect", operations)));
    }

    public static class NoDialectException
    extends NonTransientDataAccessException {
        protected NoDialectException(String msg) {
            super(msg);
        }
    }

    private static class JdbcDialectAdapter
    implements JdbcDialect {
        private final Dialect delegate;
        private final JdbcArrayColumnsAdapter arrayColumns;

        public JdbcDialectAdapter(Dialect delegate) {
            this.delegate = delegate;
            this.arrayColumns = new JdbcArrayColumnsAdapter(delegate.getArraySupport());
        }

        public LimitClause limit() {
            return this.delegate.limit();
        }

        public LockClause lock() {
            return this.delegate.lock();
        }

        @Override
        public JdbcArrayColumns getArraySupport() {
            return this.arrayColumns;
        }

        public SelectRenderContext getSelectContext() {
            return this.delegate.getSelectContext();
        }

        public IdentifierProcessing getIdentifierProcessing() {
            return this.delegate.getIdentifierProcessing();
        }

        public Escaper getLikeEscaper() {
            return this.delegate.getLikeEscaper();
        }

        public IdGeneration getIdGeneration() {
            return this.delegate.getIdGeneration();
        }

        public Collection<Object> getConverters() {
            return this.delegate.getConverters();
        }

        public Set<Class<?>> simpleTypes() {
            return this.delegate.simpleTypes();
        }

        public InsertRenderContext getInsertRenderContext() {
            return this.delegate.getInsertRenderContext();
        }

        public OrderByNullPrecedence orderByNullHandling() {
            return this.delegate.orderByNullHandling();
        }

        public SimpleFunction getExistsFunction() {
            return this.delegate.getExistsFunction();
        }

        public boolean supportsSingleQueryLoading() {
            return this.delegate.supportsSingleQueryLoading();
        }
    }

    public static interface JdbcDialectProvider {
        public Optional<Dialect> getDialect(JdbcOperations var1);
    }

    public static class DefaultDialectProvider
    implements JdbcDialectProvider {
        @Override
        public Optional<Dialect> getDialect(JdbcOperations operations) {
            return Optional.ofNullable((Dialect)operations.execute(DefaultDialectProvider::getDialect));
        }

        private static @Nullable JdbcDialect getDialect(Connection connection) throws SQLException {
            DatabaseMetaData metaData = connection.getMetaData();
            String name = metaData.getDatabaseProductName().toLowerCase(Locale.ENGLISH);
            if (name.contains("hsql")) {
                return JdbcHsqlDbDialect.INSTANCE;
            }
            if (name.contains("h2")) {
                return JdbcH2Dialect.INSTANCE;
            }
            if (name.contains("mysql")) {
                return new JdbcMySqlDialect(DefaultDialectProvider.getIdentifierProcessing(metaData));
            }
            if (name.contains("mariadb")) {
                return new JdbcMariaDbDialect(DefaultDialectProvider.getIdentifierProcessing(metaData));
            }
            if (name.contains("postgresql")) {
                return JdbcPostgresDialect.INSTANCE;
            }
            if (name.contains("microsoft")) {
                return JdbcSqlServerDialect.INSTANCE;
            }
            if (name.contains("db2")) {
                return JdbcDb2Dialect.INSTANCE;
            }
            if (name.contains("oracle")) {
                return JdbcOracleDialect.INSTANCE;
            }
            LOG.info((Object)String.format("Couldn't determine Dialect for \"%s\"", name));
            return null;
        }

        private static IdentifierProcessing getIdentifierProcessing(DatabaseMetaData metaData) throws SQLException {
            IdentifierProcessing.Quoting quoting;
            String quoteString = metaData.getIdentifierQuoteString();
            IdentifierProcessing.Quoting quoting2 = quoting = StringUtils.hasText((String)quoteString) ? new IdentifierProcessing.Quoting(quoteString) : IdentifierProcessing.Quoting.NONE;
            IdentifierProcessing.LetterCasing letterCasing = metaData.supportsMixedCaseIdentifiers() ? IdentifierProcessing.LetterCasing.AS_IS : (metaData.storesUpperCaseIdentifiers() ? IdentifierProcessing.LetterCasing.UPPER_CASE : (metaData.storesLowerCaseIdentifiers() ? IdentifierProcessing.LetterCasing.LOWER_CASE : IdentifierProcessing.LetterCasing.UPPER_CASE));
            return IdentifierProcessing.create((IdentifierProcessing.Quoting)quoting, (IdentifierProcessing.LetterCasing)letterCasing);
        }
    }
}

