/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import java.lang.reflect.Array;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jdbc.core.convert.JdbcColumnTypes;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.mapping.JdbcValue;
import org.springframework.data.jdbc.repository.query.JdbcParameters;
import org.springframework.data.jdbc.support.JdbcUtil;
import org.springframework.data.util.TypeInformation;

public abstract class JdbcValueBindUtil {
    private JdbcValueBindUtil() {
    }

    public static JdbcValue getBindValue(JdbcConverter converter, @Nullable Object value, JdbcParameters.JdbcParameter parameter) {
        return JdbcValueBindUtil.getBindValue(converter, value, parameter.getTypeInformation(), parameter.getSqlType(), parameter.getActualSqlType());
    }

    private static JdbcValue getBindValue(JdbcConverter converter, @Nullable Object value, TypeInformation<?> typeInformation, SQLType sqlType, SQLType actualSqlType) {
        if (value == null) {
            return JdbcValue.of(value, sqlType);
        }
        if (typeInformation.isCollectionLike() && value instanceof Collection) {
            Collection collection = (Collection)value;
            TypeInformation actualType = typeInformation.getActualType();
            if (actualType != null && actualType.getType().isArray() && !actualType.getType().equals(byte[].class)) {
                TypeInformation nestedElementType = actualType.getRequiredActualType();
                return JdbcValueBindUtil.writeCollection(collection, actualSqlType, array -> JdbcValueBindUtil.writeArrayValue(converter, actualSqlType, array, nestedElementType));
            }
            return JdbcValueBindUtil.writeCollection(collection, actualSqlType, it -> converter.writeJdbcValue(it, typeInformation.getRequiredActualType(), actualSqlType));
        }
        return converter.writeJdbcValue(value, typeInformation, sqlType);
    }

    private static JdbcValue writeCollection(Collection<?> value, SQLType defaultType, Function<Object, Object> mapper) {
        if (value.isEmpty()) {
            return JdbcValue.of(value, defaultType);
        }
        ArrayList<Object> mapped = new ArrayList<Object>(value.size());
        SQLType jdbcType = null;
        for (Object o : value) {
            Object mappedValue = mapper.apply(o);
            if (mappedValue instanceof JdbcValue) {
                JdbcValue jv = (JdbcValue)mappedValue;
                if (jdbcType == null) {
                    jdbcType = jv.getJdbcType();
                }
                mappedValue = jv.getValue();
            }
            mapped.add(mappedValue);
        }
        JdbcValue jdbcValue = JdbcValue.of(mapped, jdbcType == null ? defaultType : jdbcType);
        return jdbcValue;
    }

    private static JdbcValue writeArrayValue(JdbcConverter converter, SQLType actualSqlType, Object array, TypeInformation<?> nestedElementType) {
        int length = Array.getLength(array);
        Object[] mappedArray = new Object[length];
        SQLType sqlType = null;
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(array, i);
            JdbcValue converted = converter.writeJdbcValue(element, nestedElementType, actualSqlType);
            if (sqlType == null && converted.getJdbcType() != null) {
                sqlType = converted.getJdbcType();
            }
            mappedArray[i] = converted.getValue();
        }
        if (sqlType == null) {
            sqlType = JdbcUtil.targetSqlTypeFor(JdbcColumnTypes.INSTANCE.resolvePrimitiveType(nestedElementType.getType()));
        }
        return JdbcValue.of(mappedArray, sqlType);
    }
}

