/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.aot;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.domain.Sort;
import org.springframework.data.javapoet.LordOfTheStrings;
import org.springframework.data.jdbc.repository.aot.AotQueries;
import org.springframework.data.jdbc.repository.aot.AotQuery;
import org.springframework.data.jdbc.repository.aot.DerivedAotQuery;
import org.springframework.data.jdbc.repository.aot.PlaceholderAccessor;
import org.springframework.data.jdbc.repository.aot.StringAotQuery;
import org.springframework.data.jdbc.repository.query.JdbcQueryMethod;
import org.springframework.data.jdbc.repository.query.Modifying;
import org.springframework.data.jdbc.repository.query.ParameterBinding;
import org.springframework.data.jdbc.repository.query.Query;
import org.springframework.data.jdbc.repository.query.StatementFactory;
import org.springframework.data.relational.core.query.Criteria;
import org.springframework.data.relational.core.query.CriteriaDefinition;
import org.springframework.data.relational.core.sql.LockMode;
import org.springframework.data.relational.repository.Lock;
import org.springframework.data.repository.aot.generate.AotQueryMethodGenerationContext;
import org.springframework.data.repository.aot.generate.MethodReturn;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.data.util.Pair;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.TypeName;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class JdbcCodeBlocks {
    JdbcCodeBlocks() {
    }

    public static QueryBlockBuilder queryBuilder(AotQueryMethodGenerationContext context, JdbcQueryMethod queryMethod) {
        return new QueryBlockBuilder(context, queryMethod);
    }

    static QueryExecutionBlockBuilder executionBuilder(AotQueryMethodGenerationContext context, JdbcQueryMethod queryMethod) {
        return new QueryExecutionBlockBuilder(context, queryMethod);
    }

    static class QueryBlockBuilder {
        private final AotQueryMethodGenerationContext context;
        private final JdbcQueryMethod queryMethod;
        private final String parameterNames;
        private String queryVariableName = "undefined";
        private String parameterSourceVariableName = "undefined";
        private @Nullable AotQueries queries;
        private MergedAnnotation<Lock> lock = MergedAnnotation.missing();

        private QueryBlockBuilder(AotQueryMethodGenerationContext context, JdbcQueryMethod queryMethod) {
            this.context = context;
            this.queryMethod = queryMethod;
            String parameterNames = StringUtils.collectionToDelimitedString((Collection)context.getAllParameterNames(), (String)", ");
            this.parameterNames = StringUtils.hasText((String)parameterNames) ? ", " + parameterNames : "";
        }

        public QueryBlockBuilder usingQueryVariableName(String queryVariableName) {
            this.queryVariableName = queryVariableName;
            return this;
        }

        public QueryBlockBuilder parameterSource(String parameterSource) {
            this.parameterSourceVariableName = parameterSource;
            return this;
        }

        public QueryBlockBuilder filter(AotQueries query) {
            this.queries = query;
            return this;
        }

        public QueryBlockBuilder lock(MergedAnnotation<Lock> lock) {
            this.lock = lock;
            return this;
        }

        public CodeBlock build() {
            Assert.notNull((Object)this.queries, (String)"Queries must not be null");
            AotQuery aotQuery = this.queries.result();
            if (aotQuery instanceof DerivedAotQuery) {
                DerivedAotQuery derivedCountQuery;
                DerivedAotQuery derivedQuery = (DerivedAotQuery)aotQuery;
                AotQuery aotQuery2 = this.queries.count();
                return this.createDerivedQuery(derivedQuery, aotQuery2 instanceof DerivedAotQuery ? (derivedCountQuery = (DerivedAotQuery)aotQuery2) : null);
            }
            aotQuery = this.queries.result();
            if (aotQuery instanceof StringAotQuery) {
                StringAotQuery stringQuery = (StringAotQuery)aotQuery;
                return this.createStringQuery(this.queryVariableName, this.parameterSourceVariableName, stringQuery);
            }
            throw new IllegalArgumentException("Unsupported AOT query type: " + String.valueOf(this.queries.result()));
        }

        private CodeBlock createDerivedQuery(DerivedAotQuery entityQuery, @Nullable DerivedAotQuery countQuery) {
            CriteriaDefinition criteria = entityQuery.getCriteria();
            CodeBlock.Builder builder = CodeBlock.builder();
            if (!criteria.isEmpty()) {
                builder.add(this.buildCriteria(criteria, (criteriaDefinition, b) -> {
                    Assert.state((criteriaDefinition.getColumn() != null ? 1 : 0) != 0, (String)"Criteria must have a column");
                    b.add("$[$1T $2L = $1T.where($3S)", new Object[]{Criteria.class, this.context.localVariable("criteria"), criteriaDefinition.getColumn().getReference()});
                }, b -> b.add(";\n$]", new Object[0])));
            }
            builder.add(this.buildQuery(false, entityQuery, criteria, this.parameterSourceVariableName, this.queryVariableName));
            if (countQuery != null) {
                CodeBlock.Builder countAll = CodeBlock.builder();
                countAll.beginControlFlow("$T $L = () ->", new Object[]{LongSupplier.class, this.context.localVariable("countAll")});
                String parameterSourceVariableName = this.context.localVariable("count" + StringUtils.capitalize((String)this.parameterSourceVariableName));
                String queryVariableName = this.context.localVariable("count" + StringUtils.capitalize((String)this.queryVariableName));
                countAll.add(this.buildQuery(true, countQuery, criteria, parameterSourceVariableName, queryVariableName));
                countAll.addStatement("$1T $2L = queryForObject($3L, $4L, new $5T<>($1T.class))", new Object[]{Number.class, this.context.localVariable("count"), queryVariableName, parameterSourceVariableName, SingleColumnRowMapper.class});
                countAll.addStatement("return $1L != null ? $1L.longValue() : 0L", new Object[]{this.context.localVariable("count")});
                countAll.unindent();
                countAll.add("};\n", new Object[0]);
                builder.add("\n", new Object[0]);
                builder.add(countAll.build());
            }
            return builder.build();
        }

        private CodeBlock buildQuery(boolean count, DerivedAotQuery aotQuery, CriteriaDefinition criteria, String parameterSourceVariableName, String queryVariableName) {
            CodeBlock.Builder builder = CodeBlock.builder();
            String selection = this.context.localVariable(count ? "countBuilder" : "builder");
            String rawParameterSource = this.context.localVariable(count ? "countRawParameterSource" : "rawParameterSource");
            String method = aotQuery.isCount() ? "count($T.class)" : (aotQuery.isExists() ? "exists($T.class)" : (this.queryMethod.isSliceQuery() ? "slice($T.class)" : "select($T.class)"));
            builder.add("$[", new Object[0]);
            builder.add("$T $L = getStatementFactory()." + method, new Object[]{StatementFactory.SelectionBuilder.class, selection, this.context.getRepositoryInformation().getDomainType()});
            if (!aotQuery.isCount() && !aotQuery.isExists()) {
                Sort sort;
                if (aotQuery.isLimited()) {
                    builder.add(".limit($L)", new Object[]{aotQuery.getLimit().max()});
                } else if (StringUtils.hasText((String)this.context.getLimitParameterName())) {
                    builder.add(".limit($L)", new Object[]{this.context.getLimitParameterName()});
                }
                if (StringUtils.hasText((String)this.context.getPageableParameterName())) {
                    builder.add(".page($L)", new Object[]{this.context.getPageableParameterName()});
                }
                if ((sort = aotQuery.getSort()).isSorted()) {
                    builder.add(".orderBy($L)", new Object[]{QueryBlockBuilder.buildSort(sort)});
                }
                if (StringUtils.hasText((String)this.context.getSortParameterName())) {
                    builder.add(".orderBy($L)", new Object[]{this.context.getSortParameterName()});
                }
            }
            if (this.lock.isPresent()) {
                builder.add(".lock($T.$L)", new Object[]{LockMode.class, ((LockMode)this.lock.getEnum("value", LockMode.class)).name()});
            }
            if (!criteria.isEmpty()) {
                builder.add(".filter($L)", new Object[]{this.context.localVariable("criteria")});
            }
            builder.add(";\n$]", new Object[0]);
            builder.addStatement("$1T $2L = new $1T()", new Object[]{MapSqlParameterSource.class, rawParameterSource});
            builder.addStatement("$T $L = $L.build($L)", new Object[]{String.class, queryVariableName, selection, rawParameterSource});
            builder.addStatement("$1T $2L = escapingParameterSource($3L)", new Object[]{SqlParameterSource.class, parameterSourceVariableName, rawParameterSource});
            return builder.build();
        }

        private static CodeBlock buildSort(Sort sort) {
            CodeBlock.Builder sortBuilder = CodeBlock.builder();
            sortBuilder.add("$T.by(", new Object[]{Sort.class});
            boolean first = true;
            for (Sort.Order order : sort) {
                sortBuilder.add("$T.$L($S)", new Object[]{Sort.Order.class, order.isAscending() ? "asc" : "desc", order.getProperty()});
                if (order.isIgnoreCase()) {
                    sortBuilder.add(".ignoreCase()", new Object[0]);
                }
                if (first) {
                    first = false;
                    continue;
                }
                sortBuilder.add(", ", new Object[0]);
            }
            sortBuilder.add(")", new Object[0]);
            return sortBuilder.build();
        }

        private CodeBlock buildCriteria(CriteriaDefinition criteria, BiConsumer<CriteriaDefinition, CodeBlock.Builder> preamble, Consumer<CodeBlock.Builder> end) {
            CriteriaDefinition current = criteria;
            HashMap<CriteriaDefinition, CriteriaDefinition> forwardChain = new HashMap<CriteriaDefinition, CriteriaDefinition>();
            CodeBlock.Builder builder = CodeBlock.builder();
            while (current.hasPrevious()) {
                forwardChain.put(current.getRequiredPrevious(), current);
                current = current.getRequiredPrevious();
            }
            preamble.accept(current, builder);
            this.appendCriteria(current, builder);
            while ((current = (CriteriaDefinition)forwardChain.get(current)) != null) {
                if (current.isEmpty()) continue;
                if (current.isGroup()) {
                    String suffix;
                    builder.add(".$L(", new Object[]{current.getCombinator().name().toLowerCase(Locale.ROOT)});
                    if (current.getGroup().size() == 1) {
                        suffix = ")";
                    } else {
                        suffix = "))";
                        builder.add("$T.of(", new Object[]{List.class});
                    }
                    for (CriteriaDefinition nested : current.getGroup()) {
                        builder.add(this.buildCriteria(nested, (criteriaDefinition, start) -> {
                            Assert.state((criteriaDefinition.getColumn() != null ? 1 : 0) != 0, (String)"Criteria must have a column");
                            start.add("$T.where($S)", new Object[]{Criteria.class, criteriaDefinition.getColumn().getReference()});
                        }, b -> {}));
                    }
                    builder.add(suffix, new Object[0]);
                    continue;
                }
                Assert.state((current.getColumn() != null ? 1 : 0) != 0, (String)"Criteria must have a column");
                builder.add(".$L($S)", new Object[]{builder.add(".$L(", new Object[]{current.getCombinator().name().toLowerCase(Locale.ROOT)}), current.getColumn().getReference()});
                this.appendCriteria(current, builder);
            }
            end.accept(builder);
            return builder.build();
        }

        private void appendCriteria(CriteriaDefinition current, CodeBlock.Builder builder) {
            Object value = current.getValue();
            Assert.notNull((Object)current.getComparator(), (String)"Comparator must not be null");
            switch (current.getComparator()) {
                case INITIAL: {
                    break;
                }
                case EQ: {
                    builder.add(".is($L)", new Object[]{this.renderPlaceholder(value)});
                    break;
                }
                case NEQ: {
                    builder.add(".not($L)", new Object[]{this.renderPlaceholder(value)});
                    break;
                }
                case BETWEEN: {
                    builder.add(".between($L, $L)", new Object[]{this.renderPlaceholder(value, 0), this.renderPlaceholder(value, 1)});
                    break;
                }
                case NOT_BETWEEN: {
                    builder.add(".notBetween($L, $L)", new Object[]{this.renderPlaceholder(value, 0), this.renderPlaceholder(value, 1)});
                    break;
                }
                case LT: {
                    builder.add(".lessThan($L)", new Object[]{this.renderPlaceholder(value)});
                    break;
                }
                case LTE: {
                    builder.add(".lessThanOrEquals($L)", new Object[]{this.renderPlaceholder(value)});
                    break;
                }
                case GT: {
                    builder.add(".greaterThan($L)", new Object[]{this.renderPlaceholder(value)});
                    break;
                }
                case GTE: {
                    builder.add(".greaterThanEquals($L)", new Object[]{this.renderPlaceholder(value)});
                    break;
                }
                case IS_NULL: {
                    builder.add(".isNull()", new Object[0]);
                    break;
                }
                case IS_NOT_NULL: {
                    builder.add(".isNotNull()", new Object[0]);
                    break;
                }
                case LIKE: {
                    this.applyLike(builder, "like", value);
                    break;
                }
                case NOT_LIKE: {
                    this.applyLike(builder, "notLike", value);
                    break;
                }
                case NOT_IN: {
                    builder.add(".notIn($L)", new Object[]{this.renderPlaceholder(value)});
                    break;
                }
                case IN: {
                    builder.add(".in($L)", new Object[]{this.renderPlaceholder(value)});
                    break;
                }
                case IS_TRUE: {
                    builder.add(".isTrue()", new Object[0]);
                    break;
                }
                case IS_FALSE: {
                    builder.add(".isFalse()", new Object[0]);
                }
            }
            if (current.isIgnoreCase()) {
                builder.addStatement(".ignoreCase(true)", new Object[0]);
            }
        }

        private void applyLike(CodeBlock.Builder builder, String method, @Nullable Object value) {
            PlaceholderAccessor.CapturingJdbcValue captured = PlaceholderAccessor.unwrap(value);
            String likeValue = "$L";
            ParameterBinding parameterBinding = captured.getBinding();
            if (parameterBinding instanceof ParameterBinding.LikeParameterBinding) {
                ParameterBinding.LikeParameterBinding lpb = (ParameterBinding.LikeParameterBinding)parameterBinding;
                if (lpb.getType() == Part.Type.CONTAINING) {
                    likeValue = "\"%\" + escape($L) + \"%\"";
                } else if (lpb.getType() == Part.Type.STARTING_WITH) {
                    likeValue = "escape($L) + \"%\"";
                } else if (lpb.getType() == Part.Type.ENDING_WITH) {
                    likeValue = "\"%\" + escape($L)";
                }
            }
            builder.add(".$L(" + likeValue + ")", new Object[]{method, this.renderPlaceholder(value)});
        }

        private String renderPlaceholder(@Nullable Object value) {
            PlaceholderAccessor.CapturingJdbcValue captured = PlaceholderAccessor.unwrap(value);
            ParameterBinding binding = captured.getBinding();
            ParameterBinding.MethodInvocationArgument argument = (ParameterBinding.MethodInvocationArgument)binding.getOrigin();
            ParameterBinding.BindingIdentifier identifier = argument.identifier();
            return identifier.hasName() ? identifier.getName() : Objects.requireNonNull(this.context.getParameterName(identifier.getPosition()));
        }

        private Object renderPlaceholder(@Nullable Object value, int index) {
            Assert.isInstanceOf(Pair.class, (Object)value, (String)"Value must be of type Pair");
            return this.renderPlaceholder(index == 0 ? ((Pair)value).getFirst() : ((Pair)value).getSecond());
        }

        private CodeBlock createStringQuery(String queryVariableName, String parameterSourceName, StringAotQuery query) {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.addStatement("$T $L = $S", new Object[]{String.class, queryVariableName, query.getQueryString()});
            builder.addStatement("$1T $2L = new $1T()", new Object[]{MapSqlParameterSource.class, parameterSourceName});
            for (ParameterBinding binding : query.getParameterBindings()) {
                String parameterIdentifier = this.getParameterName(binding.getIdentifier());
                builder.add(this.bindValue(parameterIdentifier, binding.getOrigin()));
            }
            return builder.build();
        }

        private String getParameterName(ParameterBinding.BindingIdentifier identifier) {
            return identifier.hasName() ? identifier.getName() : Integer.toString(identifier.getPosition());
        }

        private CodeBlock bindValue(String parameterName, ParameterBinding.ParameterOrigin origin) {
            if (origin.isMethodArgument() && origin instanceof ParameterBinding.MethodInvocationArgument) {
                String identifier;
                String parameterReference;
                ParameterBinding.MethodInvocationArgument mia = (ParameterBinding.MethodInvocationArgument)origin;
                if (mia.identifier().hasPosition()) {
                    parameterReference = this.context.getRequiredBindableParameterName(mia.identifier().getPosition() - 1);
                    identifier = Integer.toString(mia.identifier().getPosition() - 1);
                } else {
                    parameterReference = this.context.getRequiredBindableParameterName(mia.identifier().getName());
                    identifier = mia.identifier().getName();
                }
                CodeBlock.Builder builder = CodeBlock.builder();
                builder.addStatement("getBindableValue($L, $L, $L).bind($S, $L)", new Object[]{this.context.getExpressionMarker().enclosingMethod(), parameterReference, identifier, parameterName, this.parameterSourceVariableName});
                return builder.build();
            }
            if (origin.isExpression() && origin instanceof ParameterBinding.Expression) {
                ParameterBinding.Expression expr = (ParameterBinding.Expression)origin;
                CodeBlock.Builder builder = CodeBlock.builder();
                Object expressionString = expr.expression().getExpressionString();
                if (!((String)expressionString).startsWith("$")) {
                    expressionString = "#{" + (String)expressionString + "}";
                }
                builder.addStatement("evaluate($L, $S$L).bind($S, $L)", new Object[]{this.context.getExpressionMarker().enclosingMethod(), expressionString, this.parameterNames, parameterName, this.parameterSourceVariableName});
                return builder.build();
            }
            throw new UnsupportedOperationException("Not supported yet for: " + String.valueOf(origin));
        }
    }

    static class QueryExecutionBlockBuilder {
        private final AotQueryMethodGenerationContext context;
        private final JdbcQueryMethod queryMethod;
        private @Nullable AotQuery aotQuery;
        private String queryVariableName = "undefined";
        private String parameterSourceVariableName = "undefined";
        private @Nullable String rowMapperRef;
        private @Nullable Class<?> rowMapperClass;
        private @Nullable String resultSetExtractorRef;
        private @Nullable Class<?> resultSetExtractorClass;
        private MergedAnnotation<Modifying> modifying = MergedAnnotation.missing();

        private QueryExecutionBlockBuilder(AotQueryMethodGenerationContext context, JdbcQueryMethod queryMethod) {
            this.context = context;
            this.queryMethod = queryMethod;
        }

        public QueryExecutionBlockBuilder queryAnnotation(MergedAnnotation<Query> query) {
            if (query.isPresent()) {
                this.rowMapper(query.getClass("rowMapperClass"));
                this.rowMapper(query.getString("rowMapperRef"));
                this.resultSetExtractor(query.getClass("resultSetExtractorClass"));
                this.resultSetExtractor(query.getString("resultSetExtractorRef"));
            }
            return this;
        }

        public QueryExecutionBlockBuilder rowMapper(String rowMapperRef) {
            this.rowMapperRef = rowMapperRef;
            return this;
        }

        public QueryExecutionBlockBuilder rowMapper(Class<?> rowMapperClass) {
            this.rowMapperClass = rowMapperClass == RowMapper.class ? null : rowMapperClass;
            return this;
        }

        public QueryExecutionBlockBuilder resultSetExtractor(String resultSetExtractorRef) {
            this.resultSetExtractorRef = resultSetExtractorRef;
            return this;
        }

        public QueryExecutionBlockBuilder resultSetExtractor(Class<?> resultSetExtractorClass) {
            this.resultSetExtractorClass = resultSetExtractorClass == ResultSetExtractor.class ? null : resultSetExtractorClass;
            return this;
        }

        public QueryExecutionBlockBuilder usingQueryVariableName(String queryVariableName) {
            this.queryVariableName = queryVariableName;
            return this;
        }

        public QueryExecutionBlockBuilder parameterSource(String parameterSourceVariableName) {
            this.parameterSourceVariableName = parameterSourceVariableName;
            return this;
        }

        public QueryExecutionBlockBuilder queries(AotQueries aotQueries) {
            this.aotQuery = aotQueries.result();
            return this;
        }

        public QueryExecutionBlockBuilder modifying(MergedAnnotation<Modifying> modifying) {
            this.modifying = modifying;
            return this;
        }

        public CodeBlock build() {
            TypeName queryResultTypeRef;
            Assert.state((this.aotQuery != null ? 1 : 0) != 0, (String)"AOT Query must not be null");
            CodeBlock.Builder builder = CodeBlock.builder();
            MethodReturn methodReturn = this.context.getMethodReturn();
            boolean isProjecting = methodReturn.isProjecting() || StringUtils.hasText((String)this.context.getDynamicProjectionParameterName());
            Class actualReturnType = isProjecting ? methodReturn.getActualReturnClass() : this.context.getRepositoryInformation().getDomainType();
            Class returnType = this.context.getMethodReturn().toClass();
            TypeName queryResultType = methodReturn.getActualClassName();
            String result = this.context.localVariable("result");
            String rowMapper = this.context.localVariable("rowMapper");
            if (this.modifying.isPresent()) {
                return this.update(returnType);
            }
            if (this.aotQuery.isCount()) {
                return this.count(result, returnType, queryResultType);
            }
            if (this.aotQuery.isExists()) {
                return this.exists(queryResultType);
            }
            if (this.aotQuery.isDelete()) {
                return this.delete(rowMapper, result, queryResultType, returnType, actualReturnType);
            }
            String resultSetExtractor = null;
            if (this.rowMapperClass != null) {
                builder.addStatement("$T $L = new $T()", new Object[]{RowMapper.class, rowMapper, this.rowMapperClass});
            } else if (StringUtils.hasText((String)this.rowMapperRef)) {
                builder.addStatement("$T $L = getRowMapperFactory().getRowMapper($S)", new Object[]{RowMapper.class, rowMapper, this.rowMapperRef});
            } else if (this.resultSetExtractorClass == null) {
                Class typeToRead = isProjecting ? this.context.getReturnedType().getDomainType() : methodReturn.getActualReturnClass();
                builder.addStatement("$T $L = getRowMapperFactory().create($T.class)", new Object[]{RowMapper.class, rowMapper, typeToRead});
            }
            if (StringUtils.hasText((String)this.resultSetExtractorRef) || this.resultSetExtractorClass != null) {
                resultSetExtractor = this.context.localVariable("resultSetExtractor");
                if (this.resultSetExtractorClass != null && (this.rowMapperClass != null || StringUtils.hasText((String)this.rowMapperRef))) {
                    builder.addStatement("$T $L = new $T($L)", new Object[]{ResultSetExtractor.class, resultSetExtractor, this.resultSetExtractorClass, rowMapper});
                } else if (this.resultSetExtractorClass != null) {
                    builder.addStatement("$T $L = new $T()", new Object[]{ResultSetExtractor.class, resultSetExtractor, this.resultSetExtractorClass});
                } else if (StringUtils.hasText((String)this.resultSetExtractorRef)) {
                    builder.addStatement("$T $L = getRowMapperFactory().getResultSetExtractor($S)", new Object[]{ResultSetExtractor.class, resultSetExtractor, this.resultSetExtractorRef});
                }
            }
            if (StringUtils.hasText(resultSetExtractor)) {
                builder.addStatement("return ($T) getJdbcOperations().query($L, $L, $L)", new Object[]{queryResultType, this.queryVariableName, this.parameterSourceVariableName, resultSetExtractor});
                return builder.build();
            }
            boolean dynamicProjection = StringUtils.hasText((String)this.context.getDynamicProjectionParameterName());
            Object object = queryResultTypeRef = dynamicProjection ? this.context.getDynamicProjectionParameterName() : queryResultType;
            if (this.queryMethod.isCollectionQuery() || this.queryMethod.isSliceQuery() || this.queryMethod.isPageQuery()) {
                builder.addStatement("$1T $2L = ($1T) getJdbcOperations().query($3L, $4L, new $5T<>($6L))", new Object[]{List.class, result, this.queryVariableName, this.parameterSourceVariableName, RowMapperResultSetExtractor.class, rowMapper});
                if (this.queryMethod.isSliceQuery() || this.queryMethod.isPageQuery()) {
                    String pageable = this.context.getPageableParameterName();
                    builder.addStatement("$1T $2L = ($1T) convertMany($3L, %s)".formatted(dynamicProjection ? "$4L" : "$4T.class"), new Object[]{List.class, this.context.localVariable("converted"), result, queryResultTypeRef});
                    if (this.queryMethod.isPageQuery()) {
                        builder.addStatement("return $1T.getPage($2L, $3L, $4L)", new Object[]{PageableExecutionUtils.class, this.context.localVariable("converted"), pageable, this.context.localVariable("countAll")});
                    } else {
                        builder.addStatement("boolean $1L = $2L.isPaged() && $3L.size() > $2L.getPageSize()", new Object[]{this.context.localVariable("hasNext"), pageable, this.context.localVariable("converted")});
                        builder.addStatement("return new $1T($2L ? $3L.subList(0, $4L.getPageSize()) : $3L, $4L, $2L)", new Object[]{SliceImpl.class, this.context.localVariable("hasNext"), this.context.localVariable("converted"), pageable});
                    }
                    return builder.build();
                }
                builder.addStatement("return ($T) convertMany($L, %s)".formatted(dynamicProjection ? "$L" : "$T.class"), new Object[]{methodReturn.getTypeName(), result, queryResultTypeRef});
            } else if (this.queryMethod.isStreamQuery()) {
                builder.addStatement("$1T $2L = getJdbcOperations().queryForStream($3L, $4L, $5L)", new Object[]{Stream.class, result, this.queryVariableName, this.parameterSourceVariableName, rowMapper});
                builder.addStatement("return ($T) convertMany($L, $T.class)", new Object[]{methodReturn.getTypeName(), result, queryResultTypeRef});
            } else {
                builder.addStatement("$T $L = queryForObject($L, $L, $L)", new Object[]{Object.class, result, this.queryVariableName, this.parameterSourceVariableName, rowMapper});
                if (methodReturn.isOptional()) {
                    builder.addStatement("return ($1T) $1T.ofNullable(convertOne($2L, %s))".formatted(dynamicProjection ? "$3L" : "$3T.class"), new Object[]{Optional.class, result, queryResultTypeRef});
                } else {
                    builder.addStatement("return ($T) convertOne($L, %s)".formatted(dynamicProjection ? "$L" : "$T.class"), new Object[]{methodReturn.getTypeName(), result, queryResultTypeRef});
                }
            }
            return builder.build();
        }

        private CodeBlock update(Class<?> returnType) {
            String result = this.context.localVariable("result");
            CodeBlock.Builder builder = CodeBlock.builder();
            LordOfTheStrings.InvocationBuilder invoke = LordOfTheStrings.invoke((String)"getJdbcOperations().update($L, $L)", (Object[])new Object[]{this.queryVariableName, this.parameterSourceVariableName});
            if (this.context.getMethodReturn().isVoid()) {
                builder.addStatement(invoke.build());
            } else {
                builder.addStatement(invoke.assignTo("int $L", new Object[]{result}));
            }
            builder.addStatement(LordOfTheStrings.returning(returnType).whenBoolean("$L != 0", new Object[]{result}).whenBoxedLong("(long) $L", new Object[]{result}).otherwise("$L", new Object[]{result}).build());
            return builder.build();
        }

        private CodeBlock delete(String rowMapper, String result, TypeName queryResultType, Class<?> returnType, Type actualReturnType) {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.addStatement("$T $L = getRowMapperFactory().create($T.class)", new Object[]{RowMapper.class, rowMapper, this.context.getRepositoryInformation().getDomainType()});
            builder.addStatement("$1T $2L = ($1T) getJdbcOperations().query($3L, $4L, new $5T<>($6L))", new Object[]{List.class, result, this.queryVariableName, this.parameterSourceVariableName, RowMapperResultSetExtractor.class, rowMapper});
            builder.addStatement("$L.forEach(getOperations()::delete)", new Object[]{result});
            builder.addStatement(LordOfTheStrings.returning(returnType).when(Collection.class.isAssignableFrom(this.context.getMethodReturn().toClass()), "($T) convertMany($L, $T.class)", new Object[]{this.context.getMethodReturn().getTypeName(), result, queryResultType}).when(this.context.getRepositoryInformation().getDomainType(), "($1T) ($2L.isEmpty() ? null : $2L.iterator().next())", new Object[]{actualReturnType, result}).whenBoolean("!$L.isEmpty()", new Object[]{result}).whenBoxedLong("(long) $L.size()", new Object[]{result}).otherwise("$L.size()", new Object[]{result}).build());
            return builder.build();
        }

        private CodeBlock count(String result, Class<?> returnType, TypeName queryResultType) {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.addStatement("$1T $2L = queryForObject($3L, $4L, new $5T<>($1T.class))", new Object[]{Number.class, result, this.queryVariableName, this.parameterSourceVariableName, SingleColumnRowMapper.class});
            builder.addStatement(LordOfTheStrings.returning(returnType).number(result).otherwise("($T) convertOne($L, $T.class)", new Object[]{this.context.getMethodReturn().getTypeName(), result, queryResultType}).build());
            return builder.build();
        }

        private CodeBlock exists(TypeName queryResultType) {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.addStatement("return ($T) getJdbcOperations().query($L, $L, $T::next)", new Object[]{queryResultType, this.queryVariableName, this.parameterSourceVariableName, ResultSet.class});
            return builder.build();
        }

        public static boolean returnsModifying(Class<?> returnType) {
            return ClassUtils.resolvePrimitiveIfNecessary(returnType) == Integer.class || ClassUtils.resolvePrimitiveIfNecessary(returnType) == Long.class;
        }
    }
}

