/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.aot;

import java.lang.reflect.Method;
import java.sql.SQLType;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.data.convert.DtoInstantiatingConverter;
import org.springframework.data.domain.Slice;
import org.springframework.data.expression.ValueEvaluationContext;
import org.springframework.data.expression.ValueEvaluationContextProvider;
import org.springframework.data.expression.ValueExpression;
import org.springframework.data.jdbc.core.JdbcAggregateOperations;
import org.springframework.data.jdbc.core.convert.JdbcColumnTypes;
import org.springframework.data.jdbc.core.mapping.JdbcValue;
import org.springframework.data.jdbc.repository.query.EscapingParameterSource;
import org.springframework.data.jdbc.repository.query.JdbcParameters;
import org.springframework.data.jdbc.repository.query.JdbcValueBindUtil;
import org.springframework.data.jdbc.repository.query.RowMapperFactory;
import org.springframework.data.jdbc.repository.query.StatementFactory;
import org.springframework.data.jdbc.support.JdbcUtil;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersSource;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.util.Lazy;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.util.ConcurrentLruCache;

public class AotRepositoryFragmentSupport {
    private static final ConversionService CONVERSION_SERVICE;
    private final RowMapperFactory rowMapperFactory;
    private final JdbcAggregateOperations operations;
    private final StatementFactory statementFactory;
    private final ProjectionFactory projectionFactory;
    private final Lazy<ConcurrentLruCache<String, ValueExpression>> expressions;
    private final Lazy<ConcurrentLruCache<Method, JdbcParameters>> parameters;
    private final Lazy<ConcurrentLruCache<Method, ValueEvaluationContextProvider>> contextProviders;

    protected AotRepositoryFragmentSupport(JdbcAggregateOperations operations, RowMapperFactory rowMapperFactory, RepositoryFactoryBeanSupport.FragmentCreationContext context) {
        this(operations, rowMapperFactory, context.getRepositoryMetadata(), context.getValueExpressionDelegate(), context.getProjectionFactory());
    }

    protected AotRepositoryFragmentSupport(JdbcAggregateOperations operations, RowMapperFactory rowMapperFactory, RepositoryMetadata repositoryMetadata, ValueExpressionDelegate valueExpressions, ProjectionFactory projectionFactory) {
        this.rowMapperFactory = rowMapperFactory;
        this.operations = operations;
        this.statementFactory = new StatementFactory(operations.getConverter(), operations.getDataAccessStrategy().getDialect());
        this.projectionFactory = projectionFactory;
        this.expressions = Lazy.of(() -> new ConcurrentLruCache(32, arg_0 -> ((ValueExpressionDelegate)valueExpressions).parse(arg_0)));
        this.parameters = Lazy.of(() -> new ConcurrentLruCache(32, it -> new JdbcParameters(ParametersSource.of((RepositoryMetadata)repositoryMetadata, (Method)it))));
        this.contextProviders = Lazy.of(() -> new ConcurrentLruCache(32, it -> valueExpressions.createValueContextProvider((Parameters)((ConcurrentLruCache)this.parameters.get()).get(it))));
    }

    protected RowMapperFactory getRowMapperFactory() {
        return this.rowMapperFactory;
    }

    protected StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    protected Dialect getDialect() {
        return this.operations.getDataAccessStrategy().getDialect();
    }

    protected JdbcAggregateOperations getOperations() {
        return this.operations;
    }

    protected NamedParameterJdbcOperations getJdbcOperations() {
        return this.operations.getDataAccessStrategy().getJdbcOperations();
    }

    protected <T> @Nullable T queryForObject(String sql, SqlParameterSource paramSource, RowMapper<T> rowMapper) throws DataAccessException {
        List results = this.getJdbcOperations().query(sql, paramSource, rowMapper);
        return (T)DataAccessUtils.uniqueResult((Collection)results);
    }

    protected SqlParameterSource escapingParameterSource(SqlParameterSource parameterSource) {
        return new EscapingParameterSource(parameterSource, this.getDialect().getLikeEscaper());
    }

    protected @Nullable Object escape(@Nullable Object value) {
        if (value == null) {
            return value;
        }
        return this.getDialect().getLikeEscaper().escape(value.toString());
    }

    protected BindValue getBindableValue(Method method, @Nullable Object value, String parameterReference) {
        return this.getBindableValue(((JdbcParameters)((Object)((ConcurrentLruCache)this.parameters.get()).get((Object)method))).getParameter(parameterReference), value);
    }

    protected BindValue getBindableValue(Method method, @Nullable Object value, int parameterIndex) {
        return this.getBindableValue(((JdbcParameters)((Object)((ConcurrentLruCache)this.parameters.get()).get((Object)method))).getParameter(parameterIndex), value);
    }

    private BindValue getBindableValue(JdbcParameters.JdbcParameter parameter, @Nullable Object value) {
        JdbcValue jdbcValue = JdbcValueBindUtil.getBindValue(this.operations.getConverter(), value, parameter);
        SQLType jdbcType = jdbcValue.getJdbcType();
        return (parameterName, parameterSource) -> {
            if (jdbcType == null) {
                parameterSource.addValue(parameterName, jdbcValue.getValue());
            } else {
                parameterSource.addValue(parameterName, jdbcValue.getValue(), jdbcType.getVendorTypeNumber().intValue());
            }
        };
    }

    protected BindValue evaluate(Method method, String expressionString, Object ... args) {
        ValueExpression expression = (ValueExpression)((ConcurrentLruCache)this.expressions.get()).get((Object)expressionString);
        ValueEvaluationContextProvider contextProvider = (ValueEvaluationContextProvider)((ConcurrentLruCache)this.contextProviders.get()).get((Object)method);
        ValueEvaluationContext context = contextProvider.getEvaluationContext((Object)args, expression.getExpressionDependencies());
        Object evaluatedValue = expression.evaluate(context);
        Class valueType = expression.getValueType(context);
        SQLType sqlType = valueType == null ? (evaluatedValue != null ? AotRepositoryFragmentSupport.getSqlType(evaluatedValue.getClass()) : null) : AotRepositoryFragmentSupport.getSqlType(valueType);
        return (parameterName, parameterSource) -> {
            if (sqlType != null) {
                parameterSource.addValue(parameterName, evaluatedValue, sqlType.getVendorTypeNumber().intValue());
            } else {
                parameterSource.addValue(parameterName, evaluatedValue);
            }
        };
    }

    private static SQLType getSqlType(Class<?> valueType) {
        return JdbcUtil.targetSqlTypeFor(JdbcColumnTypes.INSTANCE.resolvePrimitiveType(valueType));
    }

    protected <T> @Nullable T convertOne(@Nullable Object result, Class<T> projection) {
        if (result == null) {
            return null;
        }
        if (projection.isInstance(result)) {
            return projection.cast(result);
        }
        if (CONVERSION_SERVICE.canConvert(result.getClass(), projection)) {
            return (T)CONVERSION_SERVICE.convert(result, projection);
        }
        if (!projection.isInterface()) {
            RelationalMappingContext mappingContext = this.operations.getConverter().getMappingContext();
            DtoInstantiatingConverter converter = new DtoInstantiatingConverter(projection, (MappingContext)mappingContext, this.operations.getConverter().getEntityInstantiators());
            return (T)converter.convert(result);
        }
        return (T)this.projectionFactory.createProjection(projection, result);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @Nullable Object convertMany(@Nullable Object result, Class<?> projection) {
        if (result == null) {
            return null;
        }
        if (projection.isInstance(result)) {
            return result;
        }
        if (result instanceof Stream) {
            Stream stream = (Stream)result;
            return stream.map(it -> this.convertOne(it, projection));
        }
        if (result instanceof Slice) {
            Slice slice = (Slice)result;
            return slice.map(it -> this.convertOne(it, projection));
        }
        if (result instanceof Collection) {
            Collection collection = (Collection)result;
            @Nullable Collection target = CollectionFactory.createCollection(collection.getClass(), (int)collection.size());
            for (Object o : collection) {
                target.add(this.convertOne(o, projection));
            }
            return target;
        }
        throw new UnsupportedOperationException("Cannot create projection for %s".formatted(result));
    }

    static {
        DefaultConversionService conversionService = new DefaultConversionService();
        conversionService.removeConvertible(Collection.class, Object.class);
        conversionService.removeConvertible(Object.class, Optional.class);
        CONVERSION_SERVICE = conversionService;
    }

    protected static interface BindValue {
        public void bind(String var1, MapSqlParameterSource var2);
    }
}

