/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.support;

import java.util.Optional;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.jdbc.core.JdbcAggregateOperations;
import org.springframework.data.jdbc.core.JdbcAggregateTemplate;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.QueryMappingConfiguration;
import org.springframework.data.jdbc.repository.support.JdbcQueryLookupStrategy;
import org.springframework.data.jdbc.repository.support.SimpleJdbcRepository;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.repository.query.RelationalEntityInformation;
import org.springframework.data.relational.repository.support.MappingRelationalEntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.CachingValueExpressionDelegate;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JdbcRepositoryFactory
extends RepositoryFactorySupport
implements ApplicationEventPublisherAware {
    private final JdbcAggregateOperations operations;
    private final NamedParameterJdbcOperations jdbcOperations;
    private EntityCallbacks entityCallbacks = EntityCallbacks.create();
    private ApplicationEventPublisher publisher;
    @Nullable
    private BeanFactory beanFactory;
    private QueryMappingConfiguration queryMappingConfiguration;

    public JdbcRepositoryFactory(JdbcAggregateOperations operations) {
        this.publisher = event -> {};
        this.queryMappingConfiguration = QueryMappingConfiguration.EMPTY;
        Assert.notNull((Object)operations, (String)"JdbcAggregateOperations must not be null");
        this.operations = operations;
        this.jdbcOperations = operations.getDataAccessStrategy().getJdbcOperations();
    }

    public JdbcRepositoryFactory(DataAccessStrategy dataAccessStrategy, RelationalMappingContext context, JdbcConverter converter, Dialect dialect, ApplicationEventPublisher publisher, NamedParameterJdbcOperations jdbcOperations) {
        this.publisher = event -> {};
        this.queryMappingConfiguration = QueryMappingConfiguration.EMPTY;
        Assert.notNull((Object)dataAccessStrategy, (String)"DataAccessStrategy must not be null");
        Assert.notNull((Object)context, (String)"RelationalMappingContext must not be null");
        Assert.notNull((Object)converter, (String)"RelationalConverter must not be null");
        Assert.notNull((Object)publisher, (String)"ApplicationEventPublisher must not be null");
        Assert.notNull((Object)jdbcOperations, (String)"NamedParameterJdbcOperations must not be null");
        this.operations = new JdbcAggregateTemplate(publisher, context, converter, dataAccessStrategy);
        this.jdbcOperations = jdbcOperations;
        this.publisher = publisher;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        Assert.notNull((Object)publisher, (String)"ApplicationEventPublisher must not be null");
        this.publisher = publisher;
    }

    public void setEntityCallbacks(EntityCallbacks entityCallbacks) {
        Assert.notNull((Object)entityCallbacks, (String)"EntityCallbacks must not be null");
        this.entityCallbacks = entityCallbacks;
    }

    public void setBeanFactory(@Nullable BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (this.entityCallbacks == null && beanFactory != null) {
            this.setEntityCallbacks(EntityCallbacks.create((BeanFactory)beanFactory));
        }
    }

    public void setQueryMappingConfiguration(QueryMappingConfiguration queryMappingConfiguration) {
        Assert.notNull((Object)queryMappingConfiguration, (String)"QueryMappingConfiguration must not be null");
        this.queryMappingConfiguration = queryMappingConfiguration;
    }

    public RelationalEntityInformation<?, ?> getEntityInformation(RepositoryMetadata metadata) {
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(metadata.getDomainType());
        return new MappingRelationalEntityInformation(entity);
    }

    private RelationalMappingContext getMappingContext() {
        return this.operations.getConverter().getMappingContext();
    }

    protected Object getTargetRepository(RepositoryInformation repositoryInformation) {
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(repositoryInformation.getDomainType());
        return this.getTargetRepositoryViaReflection(repositoryInformation, new Object[]{this.operations, persistentEntity, this.operations.getConverter()});
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata repositoryMetadata) {
        return SimpleJdbcRepository.class;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, ValueExpressionDelegate valueExpressionDelegate) {
        DataAccessStrategy strategy = this.operations.getDataAccessStrategy();
        JdbcConverter converter = this.operations.getConverter();
        return Optional.of(JdbcQueryLookupStrategy.create(key, this.publisher, this.entityCallbacks, converter, strategy.getDialect(), this.queryMappingConfiguration, this.jdbcOperations, this.beanFactory, (ValueExpressionDelegate)new CachingValueExpressionDelegate(valueExpressionDelegate)));
    }
}

