/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.support;

import java.io.Serializable;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.DataAccessStrategyFactory;
import org.springframework.data.jdbc.core.convert.InsertStrategyFactory;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.QueryMappingConfiguration;
import org.springframework.data.jdbc.core.convert.SqlGeneratorSource;
import org.springframework.data.jdbc.core.convert.SqlParametersFactory;
import org.springframework.data.jdbc.repository.support.JdbcRepositoryFactory;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.core.support.TransactionalRepositoryFactoryBeanSupport;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.util.Assert;

public class JdbcRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends TransactionalRepositoryFactoryBeanSupport<T, S, ID>
implements ApplicationEventPublisherAware {
    private @Nullable ApplicationEventPublisher publisher;
    private @Nullable BeanFactory beanFactory;
    private @Nullable RelationalMappingContext mappingContext;
    private @Nullable JdbcConverter converter;
    private @Nullable DataAccessStrategy dataAccessStrategy;
    private @Nullable QueryMappingConfiguration queryMappingConfiguration;
    private @Nullable NamedParameterJdbcOperations operations;
    private EntityCallbacks entityCallbacks = EntityCallbacks.create();
    private @Nullable Dialect dialect;

    public JdbcRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        super.setApplicationEventPublisher(publisher);
        this.publisher = publisher;
    }

    protected RepositoryFactorySupport doCreateRepositoryFactory() {
        Assert.state((this.dataAccessStrategy != null ? 1 : 0) != 0, (String)"DataAccessStrategy is required and must not be null");
        Assert.state((this.mappingContext != null ? 1 : 0) != 0, (String)"MappingContext is required and must not be null");
        Assert.state((this.converter != null ? 1 : 0) != 0, (String)"RelationalConverter is required and must not be null");
        Assert.state((this.dialect != null ? 1 : 0) != 0, (String)"Dialect is required and must not be null");
        Assert.state((this.publisher != null ? 1 : 0) != 0, (String)"ApplicationEventPublisher is required and must not be null");
        Assert.state((this.operations != null ? 1 : 0) != 0, (String)"NamedParameterJdbcOperations is required and must not be null");
        Assert.state((this.queryMappingConfiguration != null ? 1 : 0) != 0, (String)"RelationalConverter is required and must not be null");
        JdbcRepositoryFactory jdbcRepositoryFactory = new JdbcRepositoryFactory(this.dataAccessStrategy, this.mappingContext, this.converter, this.dialect, this.publisher, this.operations);
        jdbcRepositoryFactory.setQueryMappingConfiguration(this.queryMappingConfiguration);
        jdbcRepositoryFactory.setEntityCallbacks(this.entityCallbacks);
        jdbcRepositoryFactory.setBeanFactory(this.beanFactory);
        return jdbcRepositoryFactory;
    }

    public void setMappingContext(RelationalMappingContext mappingContext) {
        Assert.notNull((Object)mappingContext, (String)"MappingContext must not be null");
        super.setMappingContext((MappingContext)mappingContext);
        this.mappingContext = mappingContext;
    }

    public void setDialect(Dialect dialect) {
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        this.dialect = dialect;
    }

    public void setDataAccessStrategy(DataAccessStrategy dataAccessStrategy) {
        Assert.notNull((Object)dataAccessStrategy, (String)"DataAccessStrategy must not be null");
        this.dataAccessStrategy = dataAccessStrategy;
    }

    public void setQueryMappingConfiguration(QueryMappingConfiguration queryMappingConfiguration) {
        Assert.notNull((Object)queryMappingConfiguration, (String)"QueryMappingConfiguration must not be null");
        this.queryMappingConfiguration = queryMappingConfiguration;
    }

    public void setJdbcOperations(NamedParameterJdbcOperations operations) {
        Assert.notNull((Object)operations, (String)"NamedParameterJdbcOperations must not be null");
        this.operations = operations;
    }

    public void setConverter(JdbcConverter converter) {
        Assert.notNull((Object)converter, (String)"JdbcConverter must not be null");
        this.converter = converter;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        this.entityCallbacks = EntityCallbacks.create((BeanFactory)beanFactory);
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() {
        Assert.state((this.converter != null ? 1 : 0) != 0, (String)"RelationalConverter is required and must not be null");
        if (this.mappingContext == null) {
            this.mappingContext = this.converter.getMappingContext();
        }
        if (this.operations == null) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"If no JdbcOperations are set a BeanFactory must be available");
            this.operations = (NamedParameterJdbcOperations)this.beanFactory.getBean(NamedParameterJdbcOperations.class);
        }
        if (this.queryMappingConfiguration == null) {
            this.queryMappingConfiguration = this.beanFactory == null ? QueryMappingConfiguration.EMPTY : (QueryMappingConfiguration)this.beanFactory.getBeanProvider(QueryMappingConfiguration.class).getIfAvailable(() -> QueryMappingConfiguration.EMPTY);
        }
        if (this.dataAccessStrategy == null && this.beanFactory != null) {
            this.dataAccessStrategy = (DataAccessStrategy)this.beanFactory.getBeanProvider(DataAccessStrategy.class).getIfAvailable();
        }
        if (this.dataAccessStrategy == null) {
            Assert.state((this.dialect != null ? 1 : 0) != 0, (String)"Dialect is required and must not be null");
            DataAccessStrategyFactory factory = JdbcRepositoryFactoryBean.getDataAccessStrategyFactory(this.mappingContext, this.converter, this.dialect, this.operations, this.queryMappingConfiguration);
            this.dataAccessStrategy = factory.create();
        }
        super.afterPropertiesSet();
    }

    private static DataAccessStrategyFactory getDataAccessStrategyFactory(RelationalMappingContext mappingContext, JdbcConverter converter, Dialect dialect, NamedParameterJdbcOperations operations, QueryMappingConfiguration queryMapping) {
        SqlGeneratorSource source = new SqlGeneratorSource(mappingContext, converter, dialect);
        SqlParametersFactory spf = new SqlParametersFactory(mappingContext, converter);
        InsertStrategyFactory isf = new InsertStrategyFactory(operations, dialect);
        return new DataAccessStrategyFactory(source, converter, operations, spf, isf, queryMapping);
    }
}

