/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.sql.SQLType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.springframework.data.jdbc.core.convert.Identifier;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.SqlGenerator;
import org.springframework.data.jdbc.core.convert.SqlIdentifierParameterSource;
import org.springframework.data.jdbc.core.mapping.JdbcValue;
import org.springframework.data.jdbc.support.JdbcUtil;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PersistentPropertyPathAccessor;
import org.springframework.data.relational.core.conversion.IdValueSource;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.mapping.RelationalPredicates;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.lang.Nullable;

public class SqlParametersFactory {
    private final RelationalMappingContext context;
    private final JdbcConverter converter;

    public SqlParametersFactory(RelationalMappingContext context, JdbcConverter converter) {
        this.context = context;
        this.converter = converter;
    }

    <T> SqlIdentifierParameterSource forInsert(T instance, Class<T> domainType, Identifier identifier, IdValueSource idValueSource) {
        RelationalPersistentEntity<T> persistentEntity = this.getRequiredPersistentEntity(domainType);
        SqlIdentifierParameterSource parameterSource = this.getParameterSource(instance, persistentEntity, "", PersistentProperty::isIdProperty);
        identifier.forEach((name, value, type) -> this.addConvertedPropertyValue(parameterSource, name, value, type));
        if (IdValueSource.PROVIDED.equals((Object)idValueSource)) {
            PersistentPropertyPathAccessor propertyPathAccessor = persistentEntity.getPropertyPathAccessor(instance);
            AggregatePath.ColumnInfos columnInfos = this.context.getAggregatePath(persistentEntity).getTableInfo().idColumnInfos();
            columnInfos.forEach((ap, __) -> {
                Object idValue = propertyPathAccessor.getProperty(ap.getRequiredPersistentPropertyPath());
                RelationalPersistentProperty idProperty = ap.getRequiredLeafProperty();
                this.addConvertedPropertyValue(parameterSource, idProperty, idValue, idProperty.getColumnName());
            });
        }
        return parameterSource;
    }

    <T> SqlIdentifierParameterSource forUpdate(T instance, Class<T> domainType) {
        return this.getParameterSource(instance, this.getRequiredPersistentEntity(domainType), "", RelationalPersistentProperty::isInsertOnly);
    }

    <T> SqlIdentifierParameterSource forQueryById(Object id, Class<T> domainType) {
        return this.doWithIdentifiers(domainType, (columns, idProperty, complexId) -> {
            SqlIdentifierParameterSource parameterSource = new SqlIdentifierParameterSource();
            BiFunction<Object, AggregatePath, Object> valueExtractor = this.getIdMapper(complexId);
            columns.forEach((ap, ci) -> this.addConvertedPropertyValue(parameterSource, ap.getRequiredLeafProperty(), valueExtractor.apply(id, (AggregatePath)ap), ci.name()));
            return parameterSource;
        });
    }

    <T> SqlIdentifierParameterSource forQueryByIds(Iterable<?> ids, Class<T> domainType) {
        return this.doWithIdentifiers(domainType, (columns, idProperty, complexId) -> {
            int n;
            SqlIdentifierParameterSource parameterSource = new SqlIdentifierParameterSource();
            BiFunction<Object, AggregatePath, Object> valueExtractor = this.getIdMapper(complexId);
            if (ids instanceof Collection) {
                Collection c = (Collection)ids;
                n = c.size();
            } else {
                n = 16;
            }
            ArrayList<Object[]> parameterValues = new ArrayList<Object[]>(n);
            for (Object id : ids) {
                Object[] tupleList = new Object[columns.size()];
                int i = 0;
                for (AggregatePath path : columns.paths()) {
                    tupleList[i++] = valueExtractor.apply(id, path);
                }
                parameterValues.add(tupleList);
            }
            parameterSource.addValue(SqlGenerator.IDS_SQL_PARAMETER, parameterValues);
            return parameterSource;
        });
    }

    private <T> T doWithIdentifiers(Class<?> domainType, IdentifierCallback<T> callback) {
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(domainType);
        RelationalPersistentProperty idProperty = (RelationalPersistentProperty)entity.getRequiredIdProperty();
        RelationalPersistentEntity complexId = this.context.getPersistentEntity(idProperty);
        AggregatePath.ColumnInfos columns = this.context.getAggregatePath(entity).getTableInfo().idColumnInfos();
        return callback.doWithIdentifiers(columns, idProperty, complexId);
    }

    SqlIdentifierParameterSource forQueryByIdentifier(Identifier identifier) {
        SqlIdentifierParameterSource parameterSource = new SqlIdentifierParameterSource();
        identifier.toMap().forEach((name, value) -> this.addConvertedPropertyValue(parameterSource, (SqlIdentifier)name, value, value.getClass()));
        return parameterSource;
    }

    private BiFunction<Object, AggregatePath, Object> getIdMapper(@Nullable RelationalPersistentEntity<?> complexId) {
        if (complexId == null) {
            return (id, aggregatePath) -> id;
        }
        return (id, aggregatePath) -> {
            PersistentPropertyAccessor accessor = complexId.getPropertyAccessor(id);
            return accessor.getProperty((PersistentProperty)aggregatePath.getRequiredLeafProperty());
        };
    }

    private void addConvertedPropertyValue(SqlIdentifierParameterSource parameterSource, RelationalPersistentProperty property, @Nullable Object value, SqlIdentifier name) {
        this.addConvertedValue(parameterSource, value, name, this.converter.getColumnType(property), this.converter.getTargetSqlType(property));
    }

    private void addConvertedPropertyValue(SqlIdentifierParameterSource parameterSource, SqlIdentifier name, Object value, Class<?> javaType) {
        this.addConvertedValue(parameterSource, value, name, javaType, JdbcUtil.targetSqlTypeFor(javaType));
    }

    private void addConvertedValue(SqlIdentifierParameterSource parameterSource, @Nullable Object value, SqlIdentifier paramName, Class<?> javaType, SQLType sqlType) {
        JdbcValue jdbcValue = this.converter.writeJdbcValue(value, javaType, sqlType);
        parameterSource.addValue(paramName, jdbcValue.getValue(), jdbcValue.getJdbcType().getVendorTypeNumber());
    }

    private <S> RelationalPersistentEntity<S> getRequiredPersistentEntity(Class<S> domainType) {
        return (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(domainType);
    }

    private <S, T> SqlIdentifierParameterSource getParameterSource(@Nullable S instance, RelationalPersistentEntity<S> persistentEntity, String prefix, Predicate<RelationalPersistentProperty> skipProperty) {
        SqlIdentifierParameterSource parameters = new SqlIdentifierParameterSource();
        PersistentPropertyAccessor propertyAccessor = instance != null ? persistentEntity.getPropertyAccessor(instance) : NoValuePropertyAccessor.instance();
        persistentEntity.doWithAll(property -> {
            if (skipProperty.test((RelationalPersistentProperty)property) || !property.isWritable()) {
                return;
            }
            if (RelationalPredicates.isRelation((RelationalPersistentProperty)property)) {
                return;
            }
            if (property.isEmbedded()) {
                Object value = propertyAccessor.getProperty(property);
                RelationalPersistentEntity embeddedEntity = (RelationalPersistentEntity)this.context.getPersistentEntity(property.getTypeInformation());
                SqlIdentifierParameterSource additionalParameters = this.getParameterSource(value, embeddedEntity, prefix + property.getEmbeddedPrefix(), skipProperty);
                parameters.addAll(additionalParameters);
            } else {
                Object value = propertyAccessor.getProperty(property);
                SqlIdentifier paramName = property.getColumnName().transform(prefix::concat);
                this.addConvertedPropertyValue(parameters, (RelationalPersistentProperty)property, value, paramName);
            }
        });
        return parameters;
    }

    static interface IdentifierCallback<T> {
        public T doWithIdentifiers(AggregatePath.ColumnInfos var1, RelationalPersistentProperty var2, RelationalPersistentEntity<?> var3);
    }

    static class NoValuePropertyAccessor<T>
    implements PersistentPropertyAccessor<T> {
        private static final NoValuePropertyAccessor INSTANCE = new NoValuePropertyAccessor();

        NoValuePropertyAccessor() {
        }

        static <T> NoValuePropertyAccessor<T> instance() {
            return INSTANCE;
        }

        public void setProperty(PersistentProperty<?> property, @Nullable Object value) {
            throw new UnsupportedOperationException("Cannot set value on 'null' target object");
        }

        public Object getProperty(PersistentProperty<?> property) {
            return null;
        }

        public T getBean() {
            return null;
        }
    }
}

