/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jdbc.core.convert.BindParameterNameSanitizer;
import org.springframework.data.jdbc.core.convert.Identifier;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.QueryMapper;
import org.springframework.data.jdbc.core.convert.SqlContext;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.InvalidPersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.dialect.RenderContextFactory;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.query.CriteriaDefinition;
import org.springframework.data.relational.core.query.Query;
import org.springframework.data.relational.core.sql.Assignments;
import org.springframework.data.relational.core.sql.BindMarker;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Comparison;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Conditions;
import org.springframework.data.relational.core.sql.Delete;
import org.springframework.data.relational.core.sql.DeleteBuilder;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Expressions;
import org.springframework.data.relational.core.sql.Functions;
import org.springframework.data.relational.core.sql.In;
import org.springframework.data.relational.core.sql.Insert;
import org.springframework.data.relational.core.sql.InsertBuilder;
import org.springframework.data.relational.core.sql.LockMode;
import org.springframework.data.relational.core.sql.OrderByField;
import org.springframework.data.relational.core.sql.SQL;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.SelectBuilder;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.StatementBuilder;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.data.relational.core.sql.TupleExpression;
import org.springframework.data.relational.core.sql.Update;
import org.springframework.data.relational.core.sql.UpdateBuilder;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.SqlRenderer;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.Predicates;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SqlGenerator {
    static final SqlIdentifier VERSION_SQL_PARAMETER = SqlIdentifier.unquoted((String)"___oldOptimisticLockingVersion");
    static final SqlIdentifier IDS_SQL_PARAMETER = SqlIdentifier.unquoted((String)"ids");
    private static final int FIRST_NON_ROOT_LENGTH = 2;
    private final RelationalPersistentEntity<?> entity;
    private final RelationalMappingContext mappingContext;
    private final SqlContext sqlContext;
    private final SqlRenderer sqlRenderer;
    private final Columns columns;
    private final Lazy<String> findOneSql = Lazy.of(this::createFindOneSql);
    private final Lazy<String> findAllSql = Lazy.of(this::createFindAllSql);
    private final Lazy<String> findAllInListSql = Lazy.of(this::createFindAllInListSql);
    private final Lazy<String> existsSql = Lazy.of(this::createExistsSql);
    private final Lazy<String> countSql = Lazy.of(this::createCountSql);
    private final Lazy<String> updateSql = Lazy.of(this::createUpdateSql);
    private final Lazy<String> updateWithVersionSql = Lazy.of(this::createUpdateWithVersionSql);
    private final Lazy<String> deleteByIdSql = Lazy.of(this::createDeleteByIdSql);
    private final Lazy<String> deleteByIdInSql = Lazy.of(this::createDeleteByIdInSql);
    private final Lazy<String> deleteByIdAndVersionSql = Lazy.of(this::createDeleteByIdAndVersionSql);
    private final Lazy<String> deleteByListSql = Lazy.of(this::createDeleteByListSql);
    private final QueryMapper queryMapper;
    private final Dialect dialect;

    SqlGenerator(RelationalMappingContext mappingContext, JdbcConverter converter, RelationalPersistentEntity<?> entity, Dialect dialect) {
        this.mappingContext = mappingContext;
        this.entity = entity;
        this.sqlContext = new SqlContext(entity);
        this.sqlRenderer = SqlRenderer.create((RenderContext)new RenderContextFactory(dialect).createRenderContext());
        this.columns = new Columns(entity, (MappingContext<RelationalPersistentEntity<?>, RelationalPersistentProperty>)mappingContext, converter);
        this.queryMapper = new QueryMapper(converter);
        this.dialect = dialect;
    }

    public SelectBuilder.SelectWhere createSelectBuilder(Table table, Predicate<AggregatePath> pathFilter) {
        return this.createSelectBuilder(table, pathFilter, Collections.emptyList(), Query.empty());
    }

    private static boolean isFirstNonRoot(AggregatePath path) {
        return path.getLength() == 2;
    }

    private static boolean isDeeplyNested(AggregatePath path) {
        return path.getLength() > 2;
    }

    private Condition getSubselectCondition(AggregatePath path, Function<Map<AggregatePath, Column>, Condition> conditionFunction, Map<AggregatePath, Column> columns) {
        AggregatePath parentPath = path.getParentPath();
        if (!parentPath.hasIdProperty()) {
            if (SqlGenerator.isDeeplyNested(parentPath)) {
                return this.getSubselectCondition(parentPath, conditionFunction, columns);
            }
            return conditionFunction.apply(columns);
        }
        AggregatePath.TableInfo parentPathTableInfo = parentPath.getTableInfo();
        Table subSelectTable = Table.create((SqlIdentifier)parentPathTableInfo.qualifiedTableName());
        Map selectFilterColumns = parentPathTableInfo.effectiveIdColumnInfos().toMap(subSelectTable);
        Condition innerCondition = SqlGenerator.isFirstNonRoot(parentPath) ? conditionFunction.apply(selectFilterColumns) : this.getSubselectCondition(parentPath, conditionFunction, selectFilterColumns);
        List idColumns = parentPathTableInfo.idColumnInfos().toColumnList(subSelectTable);
        Select select = Select.builder().select((Collection)idColumns).from((TableLike)subSelectTable).where(innerCondition).build();
        return Conditions.in((Expression)this.toExpression(columns), (Select)select);
    }

    private Expression toExpression(Map<AggregatePath, Column> columnsMap) {
        return Expressions.of(new ArrayList<Column>(columnsMap.values()));
    }

    private BindMarker getBindMarker(SqlIdentifier columnName) {
        return SQL.bindMarker((String)(":" + BindParameterNameSanitizer.sanitize(this.renderReference(columnName))));
    }

    String getFindAllInList() {
        return (String)this.findAllInListSql.get();
    }

    String getFindAll() {
        return (String)this.findAllSql.get();
    }

    String getFindAll(Sort sort) {
        return this.render(this.selectBuilder(Collections.emptyList(), sort, Pageable.unpaged()).build());
    }

    String getFindAll(Pageable pageable) {
        return this.render(this.selectBuilder(Collections.emptyList(), pageable.getSort(), pageable).build());
    }

    String getFindAllByProperty(Identifier parentIdentifier, PersistentPropertyPath<? extends RelationalPersistentProperty> propertyPath) {
        Assert.notNull((Object)parentIdentifier, (String)"identifier must not be null");
        Assert.notNull(propertyPath, (String)"propertyPath must not be null");
        AggregatePath path = this.mappingContext.getAggregatePath(propertyPath);
        return this.getFindAllByProperty(parentIdentifier, path.getTableInfo().qualifierColumnInfo(), path.isOrdered());
    }

    String getFindAllByProperty(Identifier parentIdentifier, @Nullable AggregatePath.ColumnInfo keyColumn, boolean ordered) {
        Assert.isTrue((keyColumn != null || !ordered ? 1 : 0) != 0, (String)"If the SQL statement should be ordered a keyColumn to order by must be provided");
        Table table = this.getTable();
        SelectBuilder.SelectWhere builder = this.selectBuilder(keyColumn == null ? Collections.emptyList() : Collections.singleton(keyColumn.name()));
        Condition condition = this.buildConditionForBackReference(parentIdentifier, table);
        SelectBuilder.SelectWhereAndOr withWhereClause = builder.where(condition);
        Select select = ordered ? withWhereClause.orderBy(new Expression[]{table.column(keyColumn.name()).as(keyColumn.alias())}).build() : withWhereClause.build();
        return this.render(select);
    }

    private Condition buildConditionForBackReference(Identifier parentIdentifier, Table table) {
        Comparison condition = null;
        for (SqlIdentifier backReferenceColumn : parentIdentifier.toMap().keySet()) {
            Assert.isTrue((!SqlIdentifier.EMPTY.equals((Object)backReferenceColumn) ? 1 : 0) != 0, (String)"An empty SqlIdentifier can't be used in condition. Make sure that all composite primary keys are defined in the query");
            Comparison newCondition = table.column(backReferenceColumn).isEqualTo((Expression)this.getBindMarker(backReferenceColumn));
            condition = condition == null ? newCondition : condition.and((Condition)newCondition);
        }
        Assert.state((condition != null ? 1 : 0) != 0, (String)"We need at least one condition");
        return condition;
    }

    String getExists() {
        return (String)this.existsSql.get();
    }

    String getFindOne() {
        return (String)this.findOneSql.get();
    }

    String getAcquireLockById(LockMode lockMode) {
        return this.createAcquireLockById(lockMode);
    }

    String getAcquireLockAll(LockMode lockMode) {
        return this.createAcquireLockAll(lockMode);
    }

    String getInsert(Set<SqlIdentifier> additionalColumns) {
        return this.createInsertSql(additionalColumns);
    }

    String getUpdate() {
        return (String)this.updateSql.get();
    }

    String getUpdateWithVersion() {
        return (String)this.updateWithVersionSql.get();
    }

    String getCount() {
        return (String)this.countSql.get();
    }

    String getDeleteById() {
        return (String)this.deleteByIdSql.get();
    }

    String getDeleteByIdIn() {
        return (String)this.deleteByIdInSql.get();
    }

    String getDeleteByIdAndVersion() {
        return (String)this.deleteByIdAndVersionSql.get();
    }

    String getDeleteByList() {
        return (String)this.deleteByListSql.get();
    }

    String createDeleteAllSql(@Nullable PersistentPropertyPath<RelationalPersistentProperty> path) {
        Table table = this.getTable();
        DeleteBuilder.DeleteWhere deleteAll = Delete.builder().from(table);
        if (path == null) {
            return this.render(deleteAll.build());
        }
        return this.createDeleteByPathAndCriteria(this.mappingContext.getAggregatePath(path), this::isNotNullCondition);
    }

    String createDeleteByPath(PersistentPropertyPath<RelationalPersistentProperty> path) {
        return this.createDeleteByPathAndCriteria(this.mappingContext.getAggregatePath(path), this::equalityCondition);
    }

    String createDeleteInByPath(PersistentPropertyPath<RelationalPersistentProperty> path) {
        return this.createDeleteByPathAndCriteria(this.mappingContext.getAggregatePath(path), this::inCondition);
    }

    private Condition inCondition(Map<AggregatePath, Column> columnMap) {
        Collection<Column> columns = columnMap.values();
        return Conditions.in((Expression)(columns.size() == 1 ? (Expression)columns.iterator().next() : TupleExpression.create(columns)), (Expression)this.getBindMarker(IDS_SQL_PARAMETER));
    }

    private Condition equalityCondition(Map<AggregatePath, Column> columnMap) {
        Assert.isTrue((!columnMap.isEmpty() ? 1 : 0) != 0, (String)"Column map must not be empty");
        AggregatePath.ColumnInfos idColumnInfos = this.mappingContext.getAggregatePath(this.entity).getTableInfo().idColumnInfos();
        return SqlGenerator.createPredicate(columnMap, (aggregatePath, column) -> column.isEqualTo((Expression)this.getBindMarker(idColumnInfos.get(aggregatePath).name())));
    }

    private Condition isNotNullCondition(Map<AggregatePath, Column> columnMap) {
        return SqlGenerator.createPredicate(columnMap, (aggregatePath, column) -> column.isNotNull());
    }

    private static Condition createPredicate(Map<AggregatePath, Column> columnMap, BiFunction<AggregatePath, Column, Condition> conditionFunction) {
        Condition result = null;
        for (Map.Entry<AggregatePath, Column> entry : columnMap.entrySet()) {
            Condition singleCondition = conditionFunction.apply(entry.getKey(), entry.getValue());
            result = result == null ? singleCondition : result.and(singleCondition);
        }
        Assert.state((result != null ? 1 : 0) != 0, (String)"We need at least one condition");
        return result;
    }

    private String createFindOneSql() {
        return this.render(this.selectBuilder().where(this.equalityIdWhereCondition()).build());
    }

    private Condition equalityIdWhereCondition() {
        return this.equalityIdWhereCondition(this.getIdColumns());
    }

    private Condition equalityIdWhereCondition(Iterable<Column> columns) {
        Assert.isTrue((boolean)columns.iterator().hasNext(), (String)"Identifier columns must not be empty");
        Comparison aggregate = null;
        for (Column column : columns) {
            Comparison condition = column.isEqualTo((Expression)this.getBindMarker(column.getName()));
            aggregate = aggregate == null ? condition : aggregate.and((Condition)condition);
        }
        Assert.state((aggregate != null ? 1 : 0) != 0, (String)"We need at least one id column");
        return aggregate;
    }

    private String createAcquireLockById(LockMode lockMode) {
        Table table = this.getTable();
        Select select = StatementBuilder.select((Expression)this.getSingleNonNullColumn()).from((TableLike)table).where(this.equalityIdWhereCondition()).lock(lockMode).build();
        return this.render(select);
    }

    private String createAcquireLockAll(LockMode lockMode) {
        Table table = this.getTable();
        Select select = StatementBuilder.select((Expression)this.getSingleNonNullColumn()).from((TableLike)table).lock(lockMode).build();
        return this.render(select);
    }

    private String createFindAllSql() {
        return this.render(this.selectBuilder().build());
    }

    private SelectBuilder.SelectWhere selectBuilder() {
        return this.selectBuilder(Collections.emptyList(), Query.empty());
    }

    private SelectBuilder.SelectWhere selectBuilder(Query query) {
        return this.selectBuilder(Collections.emptyList(), query);
    }

    private SelectBuilder.SelectWhere selectBuilder(Collection<SqlIdentifier> keyColumns) {
        return this.selectBuilder(keyColumns, Query.empty());
    }

    private SelectBuilder.SelectWhere selectBuilder(Collection<SqlIdentifier> keyColumns, Query query) {
        return this.createSelectBuilder(this.getTable(), ap -> false, keyColumns, query);
    }

    private SelectBuilder.SelectWhere createSelectBuilder(Table table, Predicate<AggregatePath> pathFilter, Collection<SqlIdentifier> keyColumns, Query query) {
        Projection projection = this.getProjection(pathFilter, keyColumns, query, table);
        SelectBuilder.SelectFromAndJoin baseSelect = StatementBuilder.select(projection.columns()).from((TableLike)table);
        return (SelectBuilder.SelectWhere)SqlGenerator.addJoins((SelectBuilder.SelectJoin)baseSelect, projection.joins());
    }

    private static SelectBuilder.SelectJoin addJoins(SelectBuilder.SelectJoin baseSelect, Joins joins) {
        return joins.reduce(baseSelect, (join, select) -> select.leftOuterJoin((TableLike)join.joinTable).on(join.condition));
    }

    private Projection getProjection(Predicate<AggregatePath> pathFilter, Collection<SqlIdentifier> keyColumns, Query query, Table table) {
        AggregatePath aggregatePath;
        LinkedHashSet<Expression> columns = new LinkedHashSet<Expression>();
        LinkedHashSet<Join> joins = new LinkedHashSet<Join>();
        for (SqlIdentifier columnName : query.getColumns()) {
            try {
                aggregatePath = this.mappingContext.getAggregatePath(this.mappingContext.getPersistentPropertyPath(columnName.getReference(), this.entity.getTypeInformation()));
                this.includeColumnAndJoin(aggregatePath, pathFilter, joins, columns);
            }
            catch (InvalidPersistentPropertyPath e) {
                columns.add((Expression)Column.create((SqlIdentifier)columnName, (Table)table));
            }
        }
        if (columns.isEmpty()) {
            for (PersistentPropertyPath path : this.mappingContext.findPersistentPropertyPaths(this.entity.getType(), Predicates.isTrue())) {
                aggregatePath = this.mappingContext.getAggregatePath(path);
                if (pathFilter.test(aggregatePath)) continue;
                this.includeColumnAndJoin(aggregatePath, pathFilter, joins, columns);
            }
        }
        for (SqlIdentifier keyColumn : keyColumns) {
            columns.add((Expression)table.column(keyColumn).as(keyColumn));
        }
        return new Projection(columns, Joins.of(joins));
    }

    private void includeColumnAndJoin(AggregatePath aggregatePath, Predicate<AggregatePath> pathFilter, Collection<Join> joins, Collection<Expression> columns) {
        if (aggregatePath.isEmbedded()) {
            RelationalPersistentEntity entity = aggregatePath.getRequiredLeafEntity();
            for (RelationalPersistentProperty property : entity) {
                AggregatePath nested = aggregatePath.append(property);
                if (pathFilter.test(nested)) continue;
                this.includeColumnAndJoin(nested, pathFilter, joins, columns);
            }
            return;
        }
        joins.addAll(this.getJoins(aggregatePath));
        Column column = this.getColumn(aggregatePath);
        if (column != null) {
            columns.add((Expression)column);
        }
    }

    private SelectBuilder.SelectOrdered selectBuilder(Collection<SqlIdentifier> keyColumns, Sort sort, Pageable pageable) {
        SelectBuilder.SelectWhere sortable = this.selectBuilder(keyColumns);
        sortable = this.applyPagination(pageable, (SelectBuilder.SelectOrdered)sortable);
        return sortable.orderBy(this.extractOrderByFields(sort));
    }

    private SelectBuilder.SelectOrdered applyPagination(Pageable pageable, SelectBuilder.SelectOrdered select) {
        if (!pageable.isPaged()) {
            return select;
        }
        Assert.isTrue((boolean)(select instanceof SelectBuilder.SelectLimitOffset), () -> String.format("Can't apply limit clause to statement of type %s", select.getClass()));
        SelectBuilder.SelectLimitOffset limitable = (SelectBuilder.SelectLimitOffset)select;
        SelectBuilder.SelectLimitOffset limitResult = limitable.limitOffset((long)pageable.getPageSize(), pageable.getOffset());
        Assert.state((boolean)(limitResult instanceof SelectBuilder.SelectOrdered), (String)String.format("The result of applying the limit-clause must be of type SelectOrdered in order to apply the order-by-clause but is of type %s", select.getClass()));
        return (SelectBuilder.SelectOrdered)limitResult;
    }

    @Nullable
    Column getColumn(AggregatePath path) {
        if (path.isEmbedded() || path.getParentPath().isMultiValued()) {
            return null;
        }
        if (path.isEntity()) {
            if (path.isQualified() || path.isCollectionLike() || path.hasIdProperty()) {
                return null;
            }
            return this.sqlContext.getAnyReverseColumn(path);
        }
        return this.sqlContext.getColumn(path);
    }

    List<Join> getJoins(AggregatePath path) {
        ArrayList<Join> joins = new ArrayList<Join>();
        while (!path.isRoot()) {
            Join join = this.getJoin(path);
            if (join != null) {
                joins.add(join);
            }
            path = path.getParentPath();
        }
        return joins;
    }

    @Nullable
    Join getJoin(AggregatePath path) {
        if (!path.isEntity() || path.isEmbedded() || path.isMultiValued()) {
            return null;
        }
        Table currentTable = this.sqlContext.getTable(path);
        AggregatePath.ColumnInfos backRefColumnInfos = path.getTableInfo().backReferenceColumnInfos();
        AggregatePath idDefiningParentPath = path.getIdDefiningParentPath();
        Table parentTable = this.sqlContext.getTable(idDefiningParentPath);
        AggregatePath.ColumnInfos idColumnInfos = idDefiningParentPath.getTableInfo().idColumnInfos();
        Condition joinCondition = (Condition)backRefColumnInfos.reduce((Object)Conditions.unrestricted(), (aggregatePath, columnInfo) -> currentTable.column(columnInfo.name()).isEqualTo((Expression)parentTable.column(idColumnInfos.get(aggregatePath).name())), Condition::and);
        return new Join(currentTable, joinCondition);
    }

    private String createFindAllInListSql() {
        In condition = this.idInWhereClause();
        Select select = this.selectBuilder().where((Condition)condition).build();
        return this.render(select);
    }

    private In idInWhereClause() {
        List<Column> idColumns = this.getIdColumns();
        TupleExpression expression = idColumns.size() == 1 ? (Expression)idColumns.get(0) : TupleExpression.create(idColumns);
        return Conditions.in((Expression)expression, (Expression)this.getBindMarker(IDS_SQL_PARAMETER));
    }

    private String createExistsSql() {
        Table table = this.getTable();
        Select select = StatementBuilder.select((Expression)Functions.count((Expression[])new Expression[]{this.getSingleNonNullColumn()})).from((TableLike)table).where(this.equalityIdWhereCondition()).build();
        return this.render(select);
    }

    private String createCountSql() {
        Table table = this.getTable();
        Select select = StatementBuilder.select((Expression)Functions.count((Expression[])new Expression[]{Expressions.asterisk()})).from((TableLike)table).build();
        return this.render(select);
    }

    private String createInsertSql(Set<SqlIdentifier> additionalColumns) {
        Table table = this.getTable();
        TreeSet<SqlIdentifier> columnNamesForInsert = new TreeSet<SqlIdentifier>(Comparator.comparing(SqlIdentifier::getReference));
        columnNamesForInsert.addAll(this.columns.getInsertableColumns());
        columnNamesForInsert.addAll(additionalColumns);
        InsertBuilder.InsertIntoColumnsAndValuesWithBuild insert = Insert.builder().into(table);
        for (SqlIdentifier cn : columnNamesForInsert) {
            insert = insert.column(table.column(cn));
        }
        if (columnNamesForInsert.isEmpty()) {
            return this.render(insert.build());
        }
        InsertBuilder.InsertValuesWithBuild insertWithValues = null;
        for (SqlIdentifier cn : columnNamesForInsert) {
            insertWithValues = ((InsertBuilder.InsertValues)(insertWithValues == null ? insert : insertWithValues)).values(new Expression[]{this.getBindMarker(cn)});
        }
        return this.render(insertWithValues.build());
    }

    private String createUpdateSql() {
        return this.render(this.createBaseUpdate().build());
    }

    private String createUpdateWithVersionSql() {
        Update update = this.createBaseUpdate().and((Condition)this.getVersionColumn().isEqualTo((Expression)this.getBindMarker(VERSION_SQL_PARAMETER))).build();
        return this.render(update);
    }

    private UpdateBuilder.UpdateWhereAndOr createBaseUpdate() {
        Table table = this.getTable();
        List assignments = this.columns.getUpdatableColumns().stream().map(columnName -> Assignments.value((Column)table.column(columnName), (Expression)this.getBindMarker((SqlIdentifier)columnName))).collect(Collectors.toList());
        return Update.builder().table(table).set(assignments).where(this.equalityIdWhereCondition());
    }

    private String createDeleteByIdSql() {
        return this.render(this.createBaseDeleteById(this.getTable()).build());
    }

    private String createDeleteByIdInSql() {
        return this.render(this.createBaseDeleteByIdIn(this.getTable()).build());
    }

    private String createDeleteByIdAndVersionSql() {
        Delete delete = this.createBaseDeleteById(this.getTable()).and((Condition)this.getVersionColumn().isEqualTo((Expression)this.getBindMarker(VERSION_SQL_PARAMETER))).build();
        return this.render(delete);
    }

    private DeleteBuilder.DeleteWhereAndOr createBaseDeleteById(Table table) {
        return Delete.builder().from(table).where(this.equalityIdWhereCondition());
    }

    private DeleteBuilder.DeleteWhereAndOr createBaseDeleteByIdIn(Table table) {
        return Delete.builder().from(table).where((Condition)this.idInWhereClause());
    }

    private String createDeleteByPathAndCriteria(AggregatePath path, Function<Map<AggregatePath, Column>, Condition> multiIdCondition) {
        Delete delete;
        Table table = Table.create((SqlIdentifier)path.getTableInfo().qualifiedTableName());
        DeleteBuilder.DeleteWhere builder = Delete.builder().from(table);
        AggregatePath.ColumnInfos columnInfos = path.getTableInfo().backReferenceColumnInfos();
        Map columns = columnInfos.toMap(table);
        if (SqlGenerator.isFirstNonRoot(path)) {
            delete = builder.where(multiIdCondition.apply(columns)).build();
        } else {
            Condition condition = this.getSubselectCondition(path, multiIdCondition, columns);
            delete = builder.where(condition).build();
        }
        return this.render(delete);
    }

    private String createDeleteByListSql() {
        Table table = this.getTable();
        Delete delete = Delete.builder().from(table).where((Condition)this.idInWhereClause()).build();
        return this.render(delete);
    }

    private String render(Select select) {
        return this.sqlRenderer.render(select);
    }

    private String render(Insert insert) {
        return this.sqlRenderer.render(insert);
    }

    private String render(Update update) {
        return this.sqlRenderer.render(update);
    }

    private String render(Delete delete) {
        return this.sqlRenderer.render(delete);
    }

    private Table getTable() {
        return this.sqlContext.getTable();
    }

    private Column getSingleNonNullColumn() {
        return this.doGetColumn(AggregatePath.ColumnInfos::any);
    }

    private List<Column> getIdColumns() {
        return this.doGetColumn(AggregatePath.ColumnInfos::toColumnList);
    }

    private <T> T doGetColumn(BiFunction<AggregatePath.ColumnInfos, BiFunction<AggregatePath, AggregatePath.ColumnInfo, Column>, T> columnListFunction) {
        AggregatePath.ColumnInfos columnInfos = this.mappingContext.getAggregatePath(this.entity).getTableInfo().idColumnInfos();
        return columnListFunction.apply(columnInfos, (aggregatePath, columnInfo) -> this.sqlContext.getColumn((AggregatePath)aggregatePath));
    }

    private Column getVersionColumn() {
        return this.sqlContext.getVersionColumn();
    }

    private String renderReference(SqlIdentifier identifier) {
        return identifier.getReference();
    }

    private List<OrderByField> extractOrderByFields(Sort sort) {
        return sort.stream().map(this::orderToOrderByField).collect(Collectors.toList());
    }

    private OrderByField orderToOrderByField(Sort.Order order) {
        SqlIdentifier columnName = this.getColumnNameToSortBy(order);
        Column column = Column.create((SqlIdentifier)columnName, (Table)this.getTable());
        return OrderByField.from((Expression)column, (Sort.Direction)order.getDirection()).withNullHandling(order.getNullHandling());
    }

    private SqlIdentifier getColumnNameToSortBy(Sort.Order order) {
        RelationalPersistentProperty propertyToSortBy = (RelationalPersistentProperty)this.entity.getPersistentProperty(order.getProperty());
        if (propertyToSortBy != null) {
            return propertyToSortBy.getColumnName();
        }
        PersistentPropertyPath persistentPropertyPath = this.mappingContext.getPersistentPropertyPath(order.getProperty(), this.entity.getTypeInformation());
        propertyToSortBy = (RelationalPersistentProperty)persistentPropertyPath.getBaseProperty();
        Assert.state((propertyToSortBy != null && propertyToSortBy.isEmbedded() ? 1 : 0) != 0, () -> String.format("Specified sorting property '%s' is expected to be the property, named '%s', of embedded entity '%s', but field '%s' is not marked with @Embedded", order.getProperty(), this.extractFieldNameFromEmbeddedProperty(order), this.extractEmbeddedPropertyName(order), this.extractEmbeddedPropertyName(order)));
        RelationalPersistentEntity embeddedEntity = (RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(propertyToSortBy.getType());
        return ((RelationalPersistentProperty)embeddedEntity.getRequiredPersistentProperty(this.extractFieldNameFromEmbeddedProperty(order))).getColumnName();
    }

    public String extractEmbeddedPropertyName(Sort.Order order) {
        return order.getProperty().substring(0, order.getProperty().indexOf("."));
    }

    public String extractFieldNameFromEmbeddedProperty(Sort.Order order) {
        return order.getProperty().substring(order.getProperty().indexOf(".") + 1);
    }

    public String selectByQuery(Query query, MapSqlParameterSource parameterSource) {
        Assert.notNull((Object)parameterSource, (String)"parameterSource must not be null");
        SelectBuilder.SelectWhere selectBuilder = this.selectBuilder(query);
        Select select = this.applyQueryOnSelect(query, parameterSource, selectBuilder).build();
        return this.render(select);
    }

    public String selectByQuery(Query query, MapSqlParameterSource parameterSource, Pageable pageable) {
        Assert.notNull((Object)parameterSource, (String)"parameterSource must not be null");
        SelectBuilder.SelectWhere selectBuilder = this.selectBuilder();
        SelectBuilder.SelectOrdered selectOrdered = this.applyQueryOnSelect(query, parameterSource, selectBuilder);
        selectOrdered = this.applyPagination(pageable, selectOrdered);
        selectOrdered = selectOrdered.orderBy(this.extractOrderByFields(pageable.getSort()));
        Select select = selectOrdered.build();
        return this.render(select);
    }

    public String existsByQuery(Query query, MapSqlParameterSource parameterSource) {
        SelectBuilder.SelectJoin baseSelect = this.getExistsSelect();
        Select select = this.applyQueryOnSelect(query, parameterSource, (SelectBuilder.SelectWhere)baseSelect).build();
        return this.render(select);
    }

    public String countByQuery(Query query, MapSqlParameterSource parameterSource) {
        Expression countExpression = Expressions.just((String)"1");
        SelectBuilder.SelectJoin baseSelect = this.getSelectCountWithExpression(countExpression);
        Select select = this.applyQueryOnSelect(query, parameterSource, (SelectBuilder.SelectWhere)baseSelect).build();
        return this.render(select);
    }

    private SelectBuilder.SelectJoin getExistsSelect() {
        Table table = this.getTable();
        SelectBuilder.SelectFromAndJoin baseSelect = StatementBuilder.select((Expression)this.dialect.getExistsFunction()).from((TableLike)table);
        ArrayList<Join> joins = new ArrayList<Join>();
        for (PersistentPropertyPath path : this.mappingContext.findPersistentPropertyPaths(this.entity.getType(), p -> true)) {
            AggregatePath aggregatePath = this.mappingContext.getAggregatePath(path);
            Join join = this.getJoin(aggregatePath);
            if (join == null) continue;
            joins.add(join);
        }
        return SqlGenerator.addJoins((SelectBuilder.SelectJoin)baseSelect, Joins.of(joins));
    }

    private SelectBuilder.SelectJoin getSelectCountWithExpression(Expression ... countExpressions) {
        Assert.notNull((Object)countExpressions, (String)"countExpressions must not be null");
        Assert.state((countExpressions.length >= 1 ? 1 : 0) != 0, (String)"countExpressions must contain at least one expression");
        Table table = this.getTable();
        SelectBuilder.SelectFromAndJoin baseSelect = StatementBuilder.select((Expression)Functions.count((Expression[])countExpressions)).from((TableLike)table);
        ArrayList<Join> joins = new ArrayList<Join>();
        for (PersistentPropertyPath path : this.mappingContext.findPersistentPropertyPaths(this.entity.getType(), p -> true)) {
            AggregatePath extPath = this.mappingContext.getAggregatePath(path);
            Join join = this.getJoin(extPath);
            if (join == null) continue;
            joins.add(join);
        }
        return SqlGenerator.addJoins((SelectBuilder.SelectJoin)baseSelect, Joins.of(joins));
    }

    private SelectBuilder.SelectOrdered applyQueryOnSelect(Query query, MapSqlParameterSource parameterSource, SelectBuilder.SelectWhere selectBuilder) {
        Table table = Table.create((SqlIdentifier)this.entity.getQualifiedTableName());
        SelectBuilder.SelectOrdered selectOrdered = query.getCriteria().map(item -> this.applyCriteria((CriteriaDefinition)item, selectBuilder, parameterSource, table)).orElse((SelectBuilder.SelectOrdered)selectBuilder);
        if (query.isSorted()) {
            List<OrderByField> sort = this.queryMapper.getMappedSort(table, query.getSort(), this.entity);
            selectOrdered = selectOrdered.orderBy(sort);
        }
        SelectBuilder.SelectLimitOffset limitable = (SelectBuilder.SelectLimitOffset)selectOrdered;
        if (query.getLimit() > 0) {
            limitable = limitable.limit((long)query.getLimit());
        }
        if (query.getOffset() > 0L) {
            limitable = limitable.offset(query.getOffset());
        }
        return (SelectBuilder.SelectOrdered)limitable;
    }

    SelectBuilder.SelectOrdered applyCriteria(@Nullable CriteriaDefinition criteria, SelectBuilder.SelectWhere whereBuilder, MapSqlParameterSource parameterSource, Table table) {
        return criteria == null || criteria.isEmpty() ? whereBuilder : whereBuilder.where(this.queryMapper.getMappedObject(parameterSource, criteria, table, this.entity));
    }

    static class Columns {
        private final MappingContext<RelationalPersistentEntity<?>, RelationalPersistentProperty> mappingContext;
        private final JdbcConverter converter;
        private final List<SqlIdentifier> columnNames = new ArrayList<SqlIdentifier>();
        private final List<SqlIdentifier> idColumnNames = new ArrayList<SqlIdentifier>();
        private final List<SqlIdentifier> nonIdColumnNames = new ArrayList<SqlIdentifier>();
        private final Set<SqlIdentifier> readOnlyColumnNames = new HashSet<SqlIdentifier>();
        private final Set<SqlIdentifier> insertOnlyColumnNames = new HashSet<SqlIdentifier>();
        private final Set<SqlIdentifier> insertableColumns;
        private final Set<SqlIdentifier> updatableColumns;

        Columns(RelationalPersistentEntity<?> entity, MappingContext<RelationalPersistentEntity<?>, RelationalPersistentProperty> mappingContext, JdbcConverter converter) {
            this.mappingContext = mappingContext;
            this.converter = converter;
            this.populateColumnNameCache(entity, "");
            LinkedHashSet<SqlIdentifier> insertable = new LinkedHashSet<SqlIdentifier>(this.nonIdColumnNames);
            insertable.removeAll(this.readOnlyColumnNames);
            this.insertableColumns = Collections.unmodifiableSet(insertable);
            LinkedHashSet<SqlIdentifier> updatable = new LinkedHashSet<SqlIdentifier>(this.columnNames);
            updatable.removeAll(this.idColumnNames);
            updatable.removeAll(this.readOnlyColumnNames);
            updatable.removeAll(this.insertOnlyColumnNames);
            this.updatableColumns = Collections.unmodifiableSet(updatable);
        }

        private void populateColumnNameCache(RelationalPersistentEntity<?> entity, String prefix) {
            entity.doWithAll(property -> {
                if (!property.isEntity()) {
                    this.initSimpleColumnName((RelationalPersistentProperty)property, prefix);
                } else if (property.isEmbedded()) {
                    this.initEmbeddedColumnNames((RelationalPersistentProperty)property, prefix);
                }
            });
        }

        private void initSimpleColumnName(RelationalPersistentProperty property, String prefix) {
            SqlIdentifier columnName = property.getColumnName().transform(prefix::concat);
            this.columnNames.add(columnName);
            if (!property.getOwner().isIdProperty((PersistentProperty)property)) {
                this.nonIdColumnNames.add(columnName);
            } else {
                this.idColumnNames.add(columnName);
            }
            if (!property.isWritable()) {
                this.readOnlyColumnNames.add(columnName);
            }
            if (property.isInsertOnly()) {
                this.insertOnlyColumnNames.add(columnName);
            }
        }

        private void initEmbeddedColumnNames(RelationalPersistentProperty property, String prefix) {
            String embeddedPrefix = property.getEmbeddedPrefix();
            RelationalPersistentEntity embeddedEntity = (RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(this.converter.getColumnType(property));
            this.populateColumnNameCache(embeddedEntity, prefix + embeddedPrefix);
        }

        Set<SqlIdentifier> getInsertableColumns() {
            return this.insertableColumns;
        }

        Set<SqlIdentifier> getUpdatableColumns() {
            return this.updatableColumns;
        }
    }

    record Projection(Collection<Expression> columns, Joins joins) {
    }

    record Joins(Collection<Join> joins) {
        public static Joins of(Collection<Join> joins) {
            return new Joins(joins);
        }

        public <T> T reduce(T identity, BiFunction<Join, T, T> accumulator) {
            T result = identity;
            for (Join join : this.joins) {
                result = accumulator.apply(join, (Join)result);
            }
            return result;
        }
    }

    record Join(Table joinTable, Condition condition) {
    }
}

