/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.DefaultDataAccessStrategy;
import org.springframework.data.jdbc.core.convert.InsertStrategyFactory;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.QueryMappingConfiguration;
import org.springframework.data.jdbc.core.convert.SingleQueryFallbackDataAccessStrategy;
import org.springframework.data.jdbc.core.convert.SqlGeneratorSource;
import org.springframework.data.jdbc.core.convert.SqlParametersFactory;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.util.Assert;

public class DataAccessStrategyFactory {
    private final SqlGeneratorSource sqlGeneratorSource;
    private final JdbcConverter converter;
    private final NamedParameterJdbcOperations operations;
    private final SqlParametersFactory sqlParametersFactory;
    private final InsertStrategyFactory insertStrategyFactory;
    private final QueryMappingConfiguration queryMappingConfiguration;

    public DataAccessStrategyFactory(SqlGeneratorSource sqlGeneratorSource, JdbcConverter converter, NamedParameterJdbcOperations operations, SqlParametersFactory sqlParametersFactory, InsertStrategyFactory insertStrategyFactory, QueryMappingConfiguration queryMappingConfiguration) {
        Assert.notNull((Object)sqlGeneratorSource, (String)"SqlGeneratorSource must not be null");
        Assert.notNull((Object)converter, (String)"JdbcConverter must not be null");
        Assert.notNull((Object)operations, (String)"NamedParameterJdbcOperations must not be null");
        Assert.notNull((Object)sqlParametersFactory, (String)"SqlParametersFactory must not be null");
        Assert.notNull((Object)insertStrategyFactory, (String)"InsertStrategyFactory must not be null");
        Assert.notNull((Object)queryMappingConfiguration, (String)"QueryMappingConfiguration must not be null");
        this.sqlGeneratorSource = sqlGeneratorSource;
        this.converter = converter;
        this.operations = operations;
        this.sqlParametersFactory = sqlParametersFactory;
        this.insertStrategyFactory = insertStrategyFactory;
        this.queryMappingConfiguration = queryMappingConfiguration;
    }

    public DataAccessStrategy create() {
        DefaultDataAccessStrategy defaultDataAccessStrategy = new DefaultDataAccessStrategy(this.sqlGeneratorSource, this.converter.getMappingContext(), this.converter, this.operations, this.sqlParametersFactory, this.insertStrategyFactory, this.queryMappingConfiguration);
        if (this.converter.getMappingContext().isSingleQueryLoadingEnabled()) {
            return new SingleQueryFallbackDataAccessStrategy(this.sqlGeneratorSource, this.converter, this.operations, defaultDataAccessStrategy);
        }
        return defaultDataAccessStrategy;
    }
}

