/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core;

import java.util.List;
import org.springframework.data.jdbc.core.JdbcAggregateChangeExecutionContext;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.relational.core.conversion.AggregateChange;
import org.springframework.data.relational.core.conversion.DbAction;

class AggregateChangeExecutor {
    private final JdbcConverter converter;
    private final DataAccessStrategy accessStrategy;

    AggregateChangeExecutor(JdbcConverter converter, DataAccessStrategy accessStrategy) {
        this.converter = converter;
        this.accessStrategy = accessStrategy;
    }

    <T> List<T> executeSave(AggregateChange<T> aggregateChange) {
        JdbcAggregateChangeExecutionContext executionContext = new JdbcAggregateChangeExecutionContext(this.converter, this.accessStrategy);
        aggregateChange.forEachAction(action -> this.execute((DbAction<?>)action, executionContext));
        return executionContext.populateIdsIfNecessary();
    }

    <T> void executeDelete(AggregateChange<T> aggregateChange) {
        JdbcAggregateChangeExecutionContext executionContext = new JdbcAggregateChangeExecutionContext(this.converter, this.accessStrategy);
        aggregateChange.forEachAction(action -> this.execute((DbAction<?>)action, executionContext));
    }

    private void execute(DbAction<?> action, JdbcAggregateChangeExecutionContext executionContext) {
        if (action instanceof DbAction.InsertRoot) {
            DbAction.InsertRoot insertRoot = (DbAction.InsertRoot)action;
            executionContext.executeInsertRoot(insertRoot);
        } else if (action instanceof DbAction.BatchInsertRoot) {
            DbAction.BatchInsertRoot batchInsertRoot = (DbAction.BatchInsertRoot)action;
            executionContext.executeBatchInsertRoot(batchInsertRoot);
        } else if (action instanceof DbAction.Insert) {
            DbAction.Insert insert = (DbAction.Insert)action;
            executionContext.executeInsert(insert);
        } else if (action instanceof DbAction.BatchInsert) {
            DbAction.BatchInsert batchInsert = (DbAction.BatchInsert)action;
            executionContext.executeBatchInsert(batchInsert);
        } else if (action instanceof DbAction.UpdateRoot) {
            DbAction.UpdateRoot updateRoot = (DbAction.UpdateRoot)action;
            executionContext.executeUpdateRoot(updateRoot);
        } else if (action instanceof DbAction.Delete) {
            DbAction.Delete delete = (DbAction.Delete)action;
            executionContext.executeDelete(delete);
        } else if (action instanceof DbAction.BatchDelete) {
            DbAction.BatchDelete batchDelete = (DbAction.BatchDelete)action;
            executionContext.executeBatchDelete(batchDelete);
        } else if (action instanceof DbAction.DeleteAll) {
            DbAction.DeleteAll deleteAll = (DbAction.DeleteAll)action;
            executionContext.executeDeleteAll(deleteAll);
        } else if (action instanceof DbAction.DeleteRoot) {
            DbAction.DeleteRoot deleteRoot = (DbAction.DeleteRoot)action;
            executionContext.executeDeleteRoot(deleteRoot);
        } else if (action instanceof DbAction.BatchDeleteRoot) {
            DbAction.BatchDeleteRoot batchDeleteRoot = (DbAction.BatchDeleteRoot)action;
            executionContext.executeBatchDeleteRoot(batchDeleteRoot);
        } else if (action instanceof DbAction.DeleteAllRoot) {
            DbAction.DeleteAllRoot deleteAllRoot = (DbAction.DeleteAllRoot)action;
            executionContext.executeDeleteAllRoot(deleteAllRoot);
        } else if (action instanceof DbAction.AcquireLockRoot) {
            DbAction.AcquireLockRoot acquireLockRoot = (DbAction.AcquireLockRoot)action;
            executionContext.executeAcquireLock(acquireLockRoot);
        } else if (action instanceof DbAction.AcquireLockAllRoot) {
            DbAction.AcquireLockAllRoot acquireLockAllRoot = (DbAction.AcquireLockAllRoot)action;
            executionContext.executeAcquireLockAllRoot(acquireLockAllRoot);
        } else {
            throw new RuntimeException("unexpected action");
        }
    }
}

