/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.data.expression.ValueEvaluationContext;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.jdbc.core.convert.JdbcColumnTypes;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.mapping.JdbcValue;
import org.springframework.data.jdbc.repository.query.AbstractJdbcQuery;
import org.springframework.data.jdbc.repository.query.JdbcParameters;
import org.springframework.data.jdbc.repository.query.JdbcQueryExecution;
import org.springframework.data.jdbc.repository.query.JdbcQueryMethod;
import org.springframework.data.jdbc.support.JdbcUtil;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.relational.repository.query.RelationalParametersParameterAccessor;
import org.springframework.data.repository.query.CachingValueExpressionDelegate;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.QueryMethodValueEvaluationContextAccessor;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.repository.query.ValueExpressionQueryRewriter;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeInformation;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class StringBasedJdbcQuery
extends AbstractJdbcQuery {
    private static final String PARAMETER_NEEDS_TO_BE_NAMED = "For queries with named parameters you need to provide names for method parameters; Use @Param for query method parameters, or use the javac flag -parameters";
    private final JdbcConverter converter;
    private final AbstractJdbcQuery.RowMapperFactory rowMapperFactory;
    private final ValueExpressionQueryRewriter.ParsedQuery parsedQuery;
    private final String query;
    private final CachedRowMapperFactory cachedRowMapperFactory;
    private final CachedResultSetExtractorFactory cachedResultSetExtractorFactory;
    private final ValueExpressionDelegate delegate;

    @Deprecated(since="3.4")
    public StringBasedJdbcQuery(JdbcQueryMethod queryMethod, NamedParameterJdbcOperations operations, @Nullable RowMapper<?> defaultRowMapper, JdbcConverter converter, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        this(queryMethod.getRequiredQuery(), queryMethod, operations, (Class<?> result) -> defaultRowMapper, converter, evaluationContextProvider);
    }

    @Deprecated(since="3.4")
    public StringBasedJdbcQuery(JdbcQueryMethod queryMethod, NamedParameterJdbcOperations operations, AbstractJdbcQuery.RowMapperFactory rowMapperFactory, JdbcConverter converter, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        this(queryMethod.getRequiredQuery(), queryMethod, operations, rowMapperFactory, converter, evaluationContextProvider);
    }

    public StringBasedJdbcQuery(JdbcQueryMethod queryMethod, NamedParameterJdbcOperations operations, AbstractJdbcQuery.RowMapperFactory rowMapperFactory, JdbcConverter converter, ValueExpressionDelegate delegate) {
        this(queryMethod.getRequiredQuery(), queryMethod, operations, rowMapperFactory, converter, delegate);
    }

    public StringBasedJdbcQuery(String query, JdbcQueryMethod queryMethod, NamedParameterJdbcOperations operations, AbstractJdbcQuery.RowMapperFactory rowMapperFactory, JdbcConverter converter, ValueExpressionDelegate delegate) {
        super(queryMethod, operations);
        Assert.hasText((String)query, (String)"Query must not be null or empty");
        Assert.notNull((Object)rowMapperFactory, (String)"RowMapperFactory must not be null");
        this.converter = converter;
        this.rowMapperFactory = rowMapperFactory;
        if (queryMethod.isSliceQuery()) {
            throw new UnsupportedOperationException("Slice queries are not supported using string-based queries; Offending method: " + queryMethod);
        }
        if (queryMethod.isPageQuery()) {
            throw new UnsupportedOperationException("Page queries are not supported using string-based queries; Offending method: " + queryMethod);
        }
        if (queryMethod.getParameters().hasLimitParameter()) {
            throw new UnsupportedOperationException("Queries with Limit are not supported using string-based queries; Offending method: " + queryMethod);
        }
        this.cachedRowMapperFactory = new CachedRowMapperFactory(() -> rowMapperFactory.create(queryMethod.getResultProcessor().getReturnedType().getReturnedType()));
        this.cachedResultSetExtractorFactory = new CachedResultSetExtractorFactory(this.cachedRowMapperFactory::getRowMapper);
        ValueExpressionQueryRewriter.EvaluatingValueExpressionQueryRewriter rewriter = ValueExpressionQueryRewriter.of((ValueExpressionDelegate)delegate, (counter, expression) -> String.format("__$synthetic$__%d", counter + 1), String::concat);
        this.query = query;
        this.parsedQuery = rewriter.parse(this.query);
        this.delegate = delegate;
    }

    @Deprecated(since="3.4")
    public StringBasedJdbcQuery(String query, JdbcQueryMethod queryMethod, NamedParameterJdbcOperations operations, AbstractJdbcQuery.RowMapperFactory rowMapperFactory, JdbcConverter converter, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        this(query, queryMethod, operations, rowMapperFactory, converter, (ValueExpressionDelegate)new CachingValueExpressionDelegate(new QueryMethodValueEvaluationContextAccessor((Environment)new StandardEnvironment(), rootObject -> evaluationContextProvider.getEvaluationContext((Parameters)queryMethod.getParameters(), new Object[]{rootObject})), ValueExpressionParser.create()));
    }

    public Object execute(Object[] objects) {
        RelationalParametersParameterAccessor accessor = new RelationalParametersParameterAccessor((QueryMethod)this.getQueryMethod(), objects);
        ResultProcessor processor = this.getQueryMethod().getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        JdbcQueryExecution<?> queryExecution = this.createJdbcQueryExecution((RelationalParameterAccessor)accessor, processor);
        MapSqlParameterSource parameterMap = this.bindParameters((RelationalParameterAccessor)accessor);
        return queryExecution.execute(this.evaluateExpressions(objects, accessor.getBindableParameters(), parameterMap), (SqlParameterSource)parameterMap);
    }

    private String evaluateExpressions(Object[] objects, Parameters<?, ?> bindableParameters, MapSqlParameterSource parameterMap) {
        if (this.parsedQuery.hasParameterBindings()) {
            ValueEvaluationContext evaluationContext = this.delegate.createValueContextProvider(bindableParameters).getEvaluationContext((Object)objects);
            this.parsedQuery.getParameterMap().forEach((paramName, valueExpression) -> parameterMap.addValue(paramName, valueExpression.evaluate(evaluationContext)));
            return this.parsedQuery.getQueryString();
        }
        return this.query;
    }

    private JdbcQueryExecution<?> createJdbcQueryExecution(RelationalParameterAccessor accessor, ResultProcessor processor) {
        if (this.getQueryMethod().isModifyingQuery()) {
            return this.createModifyingQueryExecutor();
        }
        Supplier<RowMapper<?>> rowMapper = () -> this.determineRowMapper(processor, accessor.findDynamicProjection() != null);
        ResultSetExtractor<Object> resultSetExtractor = this.determineResultSetExtractor(rowMapper);
        return this.createReadingQueryExecution(resultSetExtractor, rowMapper);
    }

    private MapSqlParameterSource bindParameters(RelationalParameterAccessor accessor) {
        Parameters bindableParameters = accessor.getBindableParameters();
        MapSqlParameterSource parameters = new MapSqlParameterSource(new LinkedHashMap(bindableParameters.getNumberOfParameters(), 1.0f));
        for (Parameter bindableParameter : bindableParameters) {
            Object value = accessor.getBindableValue(bindableParameter.getIndex());
            String parameterName = (String)bindableParameter.getName().orElseThrow(() -> new IllegalStateException(PARAMETER_NEEDS_TO_BE_NAMED));
            JdbcParameters.JdbcParameter parameter = this.getQueryMethod().getParameters().getParameter(bindableParameter.getIndex());
            JdbcValue jdbcValue = this.writeValue(value, parameter.getTypeInformation(), parameter);
            SQLType jdbcType = jdbcValue.getJdbcType();
            if (jdbcType == null) {
                parameters.addValue(parameterName, jdbcValue.getValue());
                continue;
            }
            parameters.addValue(parameterName, jdbcValue.getValue(), jdbcType.getVendorTypeNumber().intValue());
        }
        return parameters;
    }

    private JdbcValue writeValue(@Nullable Object value, TypeInformation<?> typeInformation, JdbcParameters.JdbcParameter parameter) {
        if (value == null) {
            return JdbcValue.of(value, parameter.getSqlType());
        }
        if (typeInformation.isCollectionLike() && value instanceof Collection) {
            Collection collection = (Collection)value;
            TypeInformation actualType = typeInformation.getActualType();
            if (actualType != null && actualType.getType().isArray() && !actualType.getType().equals(byte[].class)) {
                TypeInformation nestedElementType = actualType.getRequiredActualType();
                return this.writeCollection(collection, parameter.getActualSqlType(), array -> this.writeArrayValue(parameter, array, nestedElementType));
            }
            return this.writeCollection(collection, parameter.getActualSqlType(), it -> this.converter.writeJdbcValue(it, typeInformation.getRequiredActualType(), parameter.getActualSqlType()));
        }
        SQLType sqlType = parameter.getSqlType();
        return this.converter.writeJdbcValue(value, typeInformation, sqlType);
    }

    private JdbcValue writeCollection(Collection<?> value, SQLType defaultType, Function<Object, Object> mapper) {
        if (value.isEmpty()) {
            return JdbcValue.of(value, defaultType);
        }
        ArrayList<Object> mapped = new ArrayList<Object>(value.size());
        SQLType jdbcType = null;
        for (Object o : value) {
            Object mappedValue = mapper.apply(o);
            if (mappedValue instanceof JdbcValue) {
                JdbcValue jv = (JdbcValue)mappedValue;
                if (jdbcType == null) {
                    jdbcType = jv.getJdbcType();
                }
                mappedValue = jv.getValue();
            }
            mapped.add(mappedValue);
        }
        JdbcValue jdbcValue = JdbcValue.of(mapped, jdbcType == null ? defaultType : jdbcType);
        return jdbcValue;
    }

    private JdbcValue writeArrayValue(JdbcParameters.JdbcParameter parameter, Object array, TypeInformation<?> nestedElementType) {
        int length = Array.getLength(array);
        Object[] mappedArray = new Object[length];
        SQLType sqlType = null;
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(array, i);
            JdbcValue converted = this.converter.writeJdbcValue(element, nestedElementType, parameter.getActualSqlType());
            if (sqlType == null && converted.getJdbcType() != null) {
                sqlType = converted.getJdbcType();
            }
            mappedArray[i] = converted.getValue();
        }
        if (sqlType == null) {
            sqlType = JdbcUtil.targetSqlTypeFor(JdbcColumnTypes.INSTANCE.resolvePrimitiveType(nestedElementType.getType()));
        }
        return JdbcValue.of(mappedArray, sqlType);
    }

    RowMapper<Object> determineRowMapper(ResultProcessor resultProcessor, boolean hasDynamicProjection) {
        if (this.cachedRowMapperFactory.isConfiguredRowMapper()) {
            return this.cachedRowMapperFactory.getRowMapper();
        }
        if (hasDynamicProjection) {
            RowMapper<Object> rowMapperToUse = this.rowMapperFactory.create(resultProcessor.getReturnedType().getDomainType());
            JdbcQueryExecution.ResultProcessingConverter converter = new JdbcQueryExecution.ResultProcessingConverter(resultProcessor, (MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty>)this.converter.getMappingContext(), this.converter.getEntityInstantiators());
            return new AbstractJdbcQuery.ConvertingRowMapper<Object>(rowMapperToUse, converter);
        }
        return this.cachedRowMapperFactory.getRowMapper();
    }

    @Nullable
    ResultSetExtractor<Object> determineResultSetExtractor(Supplier<RowMapper<?>> rowMapper) {
        if (this.cachedResultSetExtractorFactory.isConfiguredResultSetExtractor()) {
            if (this.cachedResultSetExtractorFactory.requiresRowMapper() && !this.cachedRowMapperFactory.isConfiguredRowMapper()) {
                return this.cachedResultSetExtractorFactory.getResultSetExtractor(rowMapper);
            }
            return this.cachedResultSetExtractorFactory.getResultSetExtractor();
        }
        return null;
    }

    private static boolean isUnconfigured(@Nullable Class<?> configuredClass, Class<?> defaultClass) {
        return configuredClass == null || configuredClass == defaultClass;
    }

    @Deprecated(since="3.4")
    public void setBeanFactory(BeanFactory beanFactory) {
    }

    @Nullable
    static <T> Constructor<T> findPrimaryConstructor(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return BeanUtils.findPrimaryConstructor(clazz);
        }
        catch (LinkageError err) {
            throw new BeanInstantiationException(clazz, "Unresolvable class definition", (Throwable)err);
        }
    }

    class CachedRowMapperFactory {
        private final Lazy<RowMapper<Object>> cachedRowMapper;
        private final boolean configuredRowMapper;
        @Nullable
        private final Constructor<?> constructor;

        public CachedRowMapperFactory(Supplier<RowMapper<Object>> defaultMapper) {
            String rowMapperRef = StringBasedJdbcQuery.this.getQueryMethod().getRowMapperRef();
            Class<? extends RowMapper> rowMapperClass = StringBasedJdbcQuery.this.getQueryMethod().getRowMapperClass();
            if (!ObjectUtils.isEmpty((Object)rowMapperRef) && !StringBasedJdbcQuery.isUnconfigured(rowMapperClass, RowMapper.class)) {
                throw new IllegalArgumentException("Invalid RowMapper configuration. Configure either one but not both via @Query(rowMapperRef = \u2026, rowMapperClass = \u2026) for query method " + StringBasedJdbcQuery.this.getQueryMethod());
            }
            this.configuredRowMapper = !ObjectUtils.isEmpty((Object)rowMapperRef) || !StringBasedJdbcQuery.isUnconfigured(rowMapperClass, RowMapper.class);
            this.constructor = rowMapperClass != null ? StringBasedJdbcQuery.findPrimaryConstructor(rowMapperClass) : null;
            this.cachedRowMapper = Lazy.of(() -> {
                if (!ObjectUtils.isEmpty((Object)rowMapperRef)) {
                    return StringBasedJdbcQuery.this.rowMapperFactory.getRowMapper(rowMapperRef);
                }
                if (StringBasedJdbcQuery.isUnconfigured(rowMapperClass, RowMapper.class)) {
                    return (RowMapper)defaultMapper.get();
                }
                return (RowMapper)BeanUtils.instantiateClass(this.constructor, (Object[])new Object[0]);
            });
        }

        public boolean isConfiguredRowMapper() {
            return this.configuredRowMapper;
        }

        public RowMapper<Object> getRowMapper() {
            return (RowMapper)this.cachedRowMapper.get();
        }
    }

    class CachedResultSetExtractorFactory {
        private final Lazy<ResultSetExtractor<Object>> cachedResultSetExtractor;
        private final boolean configuredResultSetExtractor;
        @Nullable
        private final Constructor<? extends ResultSetExtractor> rowMapperConstructor;
        @Nullable
        private final Constructor<? extends ResultSetExtractor> constructor;
        private final Function<Supplier<RowMapper<?>>, ResultSetExtractor<Object>> resultSetExtractorFactory;

        public CachedResultSetExtractorFactory(Supplier<RowMapper<?>> resultSetExtractor) {
            String resultSetExtractorRef = StringBasedJdbcQuery.this.getQueryMethod().getResultSetExtractorRef();
            Class<? extends ResultSetExtractor> resultSetExtractorClass = StringBasedJdbcQuery.this.getQueryMethod().getResultSetExtractorClass();
            if (!ObjectUtils.isEmpty((Object)resultSetExtractorRef) && !StringBasedJdbcQuery.isUnconfigured(resultSetExtractorClass, ResultSetExtractor.class)) {
                throw new IllegalArgumentException("Invalid ResultSetExtractor configuration. Configure either one but not both via @Query(resultSetExtractorRef = \u2026, resultSetExtractorClass = \u2026) for query method " + StringBasedJdbcQuery.this.getQueryMethod());
            }
            this.configuredResultSetExtractor = !ObjectUtils.isEmpty((Object)resultSetExtractorRef) || !StringBasedJdbcQuery.isUnconfigured(resultSetExtractorClass, ResultSetExtractor.class);
            this.rowMapperConstructor = resultSetExtractorClass != null ? ClassUtils.getConstructorIfAvailable(resultSetExtractorClass, (Class[])new Class[]{RowMapper.class}) : null;
            this.constructor = resultSetExtractorClass != null ? StringBasedJdbcQuery.findPrimaryConstructor(resultSetExtractorClass) : null;
            this.resultSetExtractorFactory = rowMapper -> {
                if (!ObjectUtils.isEmpty((Object)resultSetExtractorRef)) {
                    return StringBasedJdbcQuery.this.rowMapperFactory.getResultSetExtractor(resultSetExtractorRef);
                }
                if (StringBasedJdbcQuery.isUnconfigured(resultSetExtractorClass, ResultSetExtractor.class)) {
                    throw new UnsupportedOperationException("This should not happen");
                }
                if (this.rowMapperConstructor != null) {
                    return (ResultSetExtractor)BeanUtils.instantiateClass(this.rowMapperConstructor, (Object[])new Object[]{rowMapper.get()});
                }
                return (ResultSetExtractor)BeanUtils.instantiateClass(this.constructor, (Object[])new Object[0]);
            };
            this.cachedResultSetExtractor = Lazy.of(() -> this.resultSetExtractorFactory.apply(resultSetExtractor));
        }

        public boolean isConfiguredResultSetExtractor() {
            return this.configuredResultSetExtractor;
        }

        public ResultSetExtractor<Object> getResultSetExtractor() {
            return (ResultSetExtractor)this.cachedResultSetExtractor.get();
        }

        public ResultSetExtractor<Object> getResultSetExtractor(Supplier<RowMapper<?>> rowMapperSupplier) {
            return this.resultSetExtractorFactory.apply(rowMapperSupplier);
        }

        public boolean requiresRowMapper() {
            return this.rowMapperConstructor != null;
        }
    }
}

