/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.config;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.data.jdbc.repository.support.JdbcRepositoryFactoryBean;
import org.springframework.data.relational.core.mapping.Table;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.util.StringUtils;

public class JdbcRepositoryConfigExtension
extends RepositoryConfigurationExtensionSupport {
    private static final String DEFAULT_TRANSACTION_MANAGER_BEAN_NAME = "transactionManager";

    public String getModuleName() {
        return "JDBC";
    }

    public String getRepositoryFactoryBeanClassName() {
        return JdbcRepositoryFactoryBean.class.getName();
    }

    protected String getModulePrefix() {
        return this.getModuleName().toLowerCase(Locale.US);
    }

    public String getModuleIdentifier() {
        return this.getModulePrefix();
    }

    public void postProcess(BeanDefinitionBuilder builder, RepositoryConfigurationSource source) {
        source.getAttribute("jdbcOperationsRef").filter(StringUtils::hasText).ifPresent(s -> builder.addPropertyReference("jdbcOperations", s));
        source.getAttribute("dataAccessStrategyRef").filter(StringUtils::hasText).ifPresent(s -> builder.addPropertyReference("dataAccessStrategy", s));
        Optional transactionManagerRef = source.getAttribute("transactionManagerRef");
        builder.addPropertyValue(DEFAULT_TRANSACTION_MANAGER_BEAN_NAME, (Object)transactionManagerRef.orElse(DEFAULT_TRANSACTION_MANAGER_BEAN_NAME));
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.singleton(Table.class);
    }
}

