/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;
import org.springframework.jdbc.core.namedparam.NamedParameterUtils;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class BatchJdbcOperations {
    private final JdbcOperations jdbcOperations;

    public BatchJdbcOperations(JdbcOperations jdbcOperations) {
        this.jdbcOperations = jdbcOperations;
    }

    int[] batchUpdate(String sql, SqlParameterSource[] batchArgs, KeyHolder generatedKeyHolder) {
        return this.batchUpdate(sql, batchArgs, generatedKeyHolder, null);
    }

    int[] batchUpdate(String sql, final SqlParameterSource[] batchArgs, KeyHolder generatedKeyHolder, @Nullable String[] keyColumnNames) {
        if (batchArgs.length == 0) {
            return new int[0];
        }
        final ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement((String)sql);
        SqlParameterSource paramSource = batchArgs[0];
        String sqlToUse = NamedParameterUtils.substituteNamedParameters((ParsedSql)parsedSql, (SqlParameterSource)paramSource);
        List declaredParameters = NamedParameterUtils.buildSqlParameterList((ParsedSql)parsedSql, (SqlParameterSource)paramSource);
        final PreparedStatementCreatorFactory pscf = new PreparedStatementCreatorFactory(sqlToUse, declaredParameters);
        if (keyColumnNames != null) {
            pscf.setGeneratedKeysColumnNames(keyColumnNames);
        } else {
            pscf.setReturnGeneratedKeys(true);
        }
        Object[] params = NamedParameterUtils.buildValueArray((ParsedSql)parsedSql, (SqlParameterSource)paramSource, null);
        PreparedStatementCreator psc = pscf.newPreparedStatementCreator(params);
        BatchPreparedStatementSetter bpss = new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                Object[] values = NamedParameterUtils.buildValueArray((ParsedSql)parsedSql, (SqlParameterSource)batchArgs[i], null);
                pscf.newPreparedStatementSetter(values).setValues(ps);
            }

            public int getBatchSize() {
                return batchArgs.length;
            }
        };
        PreparedStatementCallback preparedStatementCallback = ps -> {
            int batchSize = bpss.getBatchSize();
            generatedKeyHolder.getKeyList().clear();
            if (JdbcUtils.supportsBatchUpdates((Connection)ps.getConnection())) {
                for (int i = 0; i < batchSize; ++i) {
                    bpss.setValues(ps, i);
                    ps.addBatch();
                }
                int[] results = ps.executeBatch();
                this.storeGeneratedKeys(generatedKeyHolder, ps, batchSize);
                return results;
            }
            ArrayList<Integer> rowsAffected = new ArrayList<Integer>();
            for (int i = 0; i < batchSize; ++i) {
                bpss.setValues(ps, i);
                rowsAffected.add(ps.executeUpdate());
                this.storeGeneratedKeys(generatedKeyHolder, ps, 1);
            }
            int[] rowsAffectedArray = new int[rowsAffected.size()];
            for (int i = 0; i < rowsAffectedArray.length; ++i) {
                rowsAffectedArray[i] = (Integer)rowsAffected.get(i);
            }
            return rowsAffectedArray;
        };
        int[] result = (int[])this.jdbcOperations.execute(psc, preparedStatementCallback);
        Assert.state((result != null ? 1 : 0) != 0, (String)"No result array");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeGeneratedKeys(KeyHolder generatedKeyHolder, PreparedStatement ps, int rowsExpected) throws SQLException {
        List generatedKeys = generatedKeyHolder.getKeyList();
        ResultSet keys = ps.getGeneratedKeys();
        if (keys != null) {
            try {
                RowMapperResultSetExtractor rse = new RowMapperResultSetExtractor((RowMapper)new ColumnMapRowMapper(), rowsExpected);
                generatedKeys.addAll(rse.extractData(keys));
            }
            finally {
                JdbcUtils.closeResultSet((ResultSet)keys);
            }
        }
    }
}

