/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.jdbc.core.SqlGenerator;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;

public class SqlGeneratorSource {
    private final Map<Class, SqlGenerator> sqlGeneratorCache = new ConcurrentHashMap<Class, SqlGenerator>();
    private final RelationalMappingContext context;

    SqlGenerator getSqlGenerator(Class<?> domainType) {
        return this.sqlGeneratorCache.computeIfAbsent(domainType, t -> new SqlGenerator(this.context, (RelationalPersistentEntity)this.context.getRequiredPersistentEntity((Class)t), this));
    }

    public SqlGeneratorSource(RelationalMappingContext context) {
        this.context = context;
    }
}

