/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.support;

import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.springframework.data.jdbc.core.JdbcAggregateOperations;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.util.Streamable;

public class SimpleJdbcRepository<T, ID>
implements CrudRepository<T, ID> {
    @NonNull
    private final JdbcAggregateOperations entityOperations;
    @NonNull
    private final PersistentEntity<T, ?> entity;

    public <S extends T> S save(S instance) {
        return this.entityOperations.save(instance);
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        return Streamable.of(entities).stream().map(this::save).collect(Collectors.toList());
    }

    public Optional<T> findById(ID id) {
        return Optional.ofNullable(this.entityOperations.findById(id, this.entity.getType()));
    }

    public boolean existsById(ID id) {
        return this.entityOperations.existsById(id, this.entity.getType());
    }

    public Iterable<T> findAll() {
        return this.entityOperations.findAll(this.entity.getType());
    }

    public Iterable<T> findAllById(Iterable<ID> ids) {
        return this.entityOperations.findAllById(ids, this.entity.getType());
    }

    public long count() {
        return this.entityOperations.count(this.entity.getType());
    }

    public void deleteById(ID id) {
        this.entityOperations.deleteById(id, this.entity.getType());
    }

    public void delete(T instance) {
        this.entityOperations.delete(instance, this.entity.getType());
    }

    public void deleteAll(Iterable<? extends T> entities) {
        entities.forEach(it -> this.entityOperations.delete(it, it.getClass()));
    }

    public void deleteAll() {
        this.entityOperations.deleteAll(this.entity.getType());
    }

    public SimpleJdbcRepository(@NonNull JdbcAggregateOperations entityOperations, @NonNull PersistentEntity<T, ?> entity) {
        if (entityOperations == null) {
            throw new IllegalArgumentException("entityOperations is marked @NonNull but is null");
        }
        if (entity == null) {
            throw new IllegalArgumentException("entity is marked @NonNull but is null");
        }
        this.entityOperations = entityOperations;
        this.entity = entity;
    }
}

