/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

class SelectBuilder {
    private final List<Column> columns = new ArrayList<Column>();
    private final String tableName;
    private final List<Join> joins = new ArrayList<Join>();
    private final List<WhereCondition> conditions = new ArrayList<WhereCondition>();

    SelectBuilder(String tableName) {
        this.tableName = tableName;
    }

    SelectBuilder column(Function<Column.ColumnBuilder, Column.ColumnBuilder> columnSpec) {
        this.columns.add(columnSpec.apply(Column.builder()).build());
        return this;
    }

    SelectBuilder where(Function<WhereConditionBuilder, WhereConditionBuilder> whereSpec) {
        this.conditions.add(whereSpec.apply(new WhereConditionBuilder()).build());
        return this;
    }

    SelectBuilder join(Function<Join.JoinBuilder, Join.JoinBuilder> joinSpec) {
        this.joins.add(joinSpec.apply(Join.builder()).build());
        return this;
    }

    String build() {
        return this.selectFrom() + this.joinClause() + this.whereClause();
    }

    private String whereClause() {
        if (this.conditions.isEmpty()) {
            return "";
        }
        return this.conditions.stream().map(WhereCondition::toSql).collect(Collectors.joining("AND", " WHERE ", ""));
    }

    private String joinClause() {
        return this.joins.stream().map(j -> this.joinTable((Join)j) + this.joinConditions((Join)j)).collect(Collectors.joining(" "));
    }

    private String joinTable(Join j) {
        return String.format("%s JOIN %s AS %s", j.outerJoinModifier(), j.table, j.as);
    }

    private String joinConditions(Join j) {
        return j.conditions.stream().map(w -> String.format("%s %s %s", ((WhereCondition)w).fromExpression, ((WhereCondition)w).operation, ((WhereCondition)w).toExpression)).collect(Collectors.joining(" AND ", " ON ", ""));
    }

    private String selectFrom() {
        return this.columns.stream().map(Column::columnDefinition).collect(Collectors.joining(", ", "SELECT ", " FROM " + this.tableName));
    }

    static class Column {
        private final String tableAlias;
        private final String column;
        private final String as;

        String columnDefinition() {
            StringBuilder b = new StringBuilder();
            if (this.tableAlias != null) {
                b.append(this.tableAlias).append('.');
            }
            b.append(this.column);
            if (this.as != null) {
                b.append(" AS ").append(this.as);
            }
            return b.toString();
        }

        Column(String tableAlias, String column, String as) {
            this.tableAlias = tableAlias;
            this.column = column;
            this.as = as;
        }

        public static ColumnBuilder builder() {
            return new ColumnBuilder();
        }

        public static class ColumnBuilder {
            private String tableAlias;
            private String column;
            private String as;

            ColumnBuilder() {
            }

            public ColumnBuilder tableAlias(String tableAlias) {
                this.tableAlias = tableAlias;
                return this;
            }

            public ColumnBuilder column(String column) {
                this.column = column;
                return this;
            }

            public ColumnBuilder as(String as) {
                this.as = as;
                return this;
            }

            public Column build() {
                return new Column(this.tableAlias, this.column, this.as);
            }

            public String toString() {
                return "SelectBuilder.Column.ColumnBuilder(tableAlias=" + this.tableAlias + ", column=" + this.column + ", as=" + this.as + ")";
            }
        }
    }

    static class WhereCondition {
        private final String operation;
        private final String fromExpression;
        private final String toExpression;

        WhereCondition(String fromExpression, String operation, String toExpression) {
            this.fromExpression = fromExpression;
            this.toExpression = toExpression;
            this.operation = operation;
        }

        String toSql() {
            if (this.operation.equals("in")) {
                return String.format("%s %s(%s)", this.fromExpression, this.operation, this.toExpression);
            }
            return String.format("%s %s %s", this.fromExpression, this.operation, this.toExpression);
        }
    }

    static class Join {
        private final String table;
        private final String as;
        private final Outer outer;
        private final List<WhereCondition> conditions = new ArrayList<WhereCondition>();

        Join(String table, String as, List<WhereCondition> conditions, Outer outer) {
            this.table = table;
            this.as = as;
            this.outer = outer;
            this.conditions.addAll(conditions);
        }

        static JoinBuilder builder() {
            return new JoinBuilder();
        }

        private String outerJoinModifier() {
            switch (this.outer) {
                case NONE: {
                    return "";
                }
            }
            return String.format(" %s OUTER", this.outer.name());
        }

        private static enum Outer {
            NONE,
            RIGHT,
            LEFT;

        }

        public static class JoinBuilder {
            private String table;
            private String as;
            private List<WhereCondition> conditions = new ArrayList<WhereCondition>();
            private Outer outer = Outer.NONE;

            JoinBuilder() {
            }

            public JoinBuilder table(String table) {
                this.table = table;
                return this;
            }

            public JoinBuilder as(String as) {
                this.as = as;
                return this;
            }

            WhereConditionBuilder where(String column) {
                return new WhereConditionBuilder(this, column);
            }

            private JoinBuilder where(WhereCondition condition) {
                this.conditions.add(condition);
                return this;
            }

            Join build() {
                return new Join(this.table, this.as, this.conditions, this.outer);
            }

            public String toString() {
                return "org.springframework.data.jdbc.core.SelectBuilder.Join.JoinBuilder(table=" + this.table + ", as=" + this.as + ")";
            }

            JoinBuilder rightOuter() {
                this.outer = Outer.RIGHT;
                return this;
            }

            JoinBuilder leftOuter() {
                this.outer = Outer.LEFT;
                return this;
            }

            static class WhereConditionBuilder {
                private final JoinBuilder joinBuilder;
                private final String fromColumn;
                private String operation = "=";

                WhereConditionBuilder(JoinBuilder joinBuilder, String column) {
                    this.joinBuilder = joinBuilder;
                    this.fromColumn = column;
                }

                WhereConditionBuilder eq() {
                    this.operation = "=";
                    return this;
                }

                JoinBuilder column(String table, String column) {
                    return this.joinBuilder.where(new WhereCondition(this.joinBuilder.as + "." + this.fromColumn, this.operation, table + "." + column));
                }
            }
        }
    }

    static class WhereConditionBuilder {
        private String fromTable;
        private String fromColumn;
        private String operation = "=";
        private String expression;

        WhereConditionBuilder() {
        }

        WhereConditionBuilder eq() {
            this.operation = "=";
            return this;
        }

        public WhereConditionBuilder in() {
            this.operation = "in";
            return this;
        }

        WhereConditionBuilder tableAlias(String fromTable) {
            this.fromTable = fromTable;
            return this;
        }

        WhereConditionBuilder column(String fromColumn) {
            this.fromColumn = fromColumn;
            return this;
        }

        WhereConditionBuilder variable(String var) {
            this.expression = ":" + var;
            return this;
        }

        WhereCondition build() {
            return new WhereCondition(this.fromTable + "." + this.fromColumn, this.operation, this.expression);
        }
    }
}

