/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.boot;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.hadoop.boot.HadoopAutoConfiguration;
import org.springframework.data.hadoop.config.annotation.EnableHadoop;
import org.springframework.data.hadoop.fs.FsShell;

@Configuration
@ConditionalOnClass(value={EnableHadoop.class})
@ConditionalOnMissingBean(value={FsShell.class})
@AutoConfigureAfter(value={HadoopAutoConfiguration.class})
public class HadoopFsShellAutoConfiguration {
    @Autowired
    private org.apache.hadoop.conf.Configuration configuration;

    @Bean(name={"hadoopFsShell"})
    @ConditionalOnExpression(value="${spring.hadoop.fsshell.enabled:true}")
    public FsShell fsShell() {
        return new FsShell(this.configuration);
    }
}

