/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import org.apache.geode.CancelException;
import org.apache.geode.CopyException;
import org.apache.geode.GemFireCacheException;
import org.apache.geode.GemFireCheckedException;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.GemFireException;
import org.apache.geode.GemFireIOException;
import org.apache.geode.IncompatibleSystemException;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.InvalidValueException;
import org.apache.geode.NoSystemException;
import org.apache.geode.SystemConnectException;
import org.apache.geode.SystemIsRunningException;
import org.apache.geode.UnmodifiableException;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.RegionNotFoundException;
import org.apache.geode.admin.RuntimeAdminException;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.CacheExistsException;
import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.CacheRuntimeException;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.CacheXmlException;
import org.apache.geode.cache.CommitConflictException;
import org.apache.geode.cache.CommitIncompleteException;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.EntryExistsException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.FailedSynchronizationException;
import org.apache.geode.cache.OperationAbortedException;
import org.apache.geode.cache.PartitionedRegionDistributionException;
import org.apache.geode.cache.PartitionedRegionStorageException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.ResourceException;
import org.apache.geode.cache.RoleException;
import org.apache.geode.cache.StatisticsDisabledException;
import org.apache.geode.cache.SynchronizationCommitConflictException;
import org.apache.geode.cache.VersionException;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.query.CqClosedException;
import org.apache.geode.cache.query.IndexInvalidException;
import org.apache.geode.cache.query.IndexMaintenanceException;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.cache.query.QueryExecutionTimeoutException;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.distributed.LeaseExpiredException;
import org.apache.geode.security.GemFireSecurityException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.PermissionDeniedDataAccessException;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.data.gemfire.GemfireCancellationException;
import org.springframework.data.gemfire.GemfireIndexException;
import org.springframework.data.gemfire.GemfireQueryException;
import org.springframework.data.gemfire.GemfireSystemException;
import org.springframework.util.ClassUtils;

public abstract class GemfireCacheUtils {
    private static Class<?> CQ_EXCEPTION_CLASS;

    public static DataAccessException convertGemfireAccessException(GemFireException cause) {
        if (cause instanceof CacheException) {
            if (cause instanceof CacheExistsException) {
                return new DataIntegrityViolationException(cause.getMessage(), (Throwable)cause);
            }
            if (cause instanceof CommitConflictException) {
                return new DataIntegrityViolationException(cause.getMessage(), (Throwable)cause);
            }
            if (cause instanceof CommitIncompleteException) {
                return new DataIntegrityViolationException(cause.getMessage(), (Throwable)cause);
            }
            if (cause instanceof EntryExistsException) {
                return new DuplicateKeyException(cause.getMessage(), (Throwable)cause);
            }
            if (cause instanceof EntryNotFoundException) {
                return new DataRetrievalFailureException(cause.getMessage(), (Throwable)cause);
            }
            if (cause instanceof RegionExistsException) {
                return new DataIntegrityViolationException(cause.getMessage(), (Throwable)cause);
            }
        }
        if (cause instanceof CacheRuntimeException) {
            if (cause instanceof CacheXmlException) {
                return new GemfireSystemException(cause);
            }
            if (cause instanceof CancelException) {
                return new GemfireCancellationException((CancelException)cause);
            }
            if (cause instanceof CqClosedException) {
                return new InvalidDataAccessApiUsageException(cause.getMessage(), (Throwable)cause);
            }
            if (cause instanceof DiskAccessException) {
                return new DataAccessResourceFailureException(cause.getMessage(), (Throwable)cause);
            }
            if (cause instanceof EntryDestroyedException) {
                return new InvalidDataAccessApiUsageException(cause.getMessage(), (Throwable)cause);
            }
            if (cause instanceof FailedSynchronizationException) {
                return new PessimisticLockingFailureException(cause.getMessage(), (Throwable)cause);
            }
            if (cause instanceof IndexMaintenanceException) {
                return new GemfireIndexException((IndexMaintenanceException)cause);
            }
            if (cause instanceof OperationAbortedException) {
                if (cause instanceof CacheLoaderException) {
                    return new GemfireSystemException(cause);
                }
                if (cause instanceof CacheWriterException) {
                    return new GemfireSystemException(cause);
                }
                return new DataAccessResourceFailureException(cause.getMessage(), (Throwable)cause);
            }
            if (cause instanceof PartitionedRegionDistributionException) {
                return new DataAccessResourceFailureException(cause.getMessage(), (Throwable)cause);
            }
            if (cause instanceof PartitionedRegionStorageException) {
                return new DataAccessResourceFailureException(cause.getMessage(), (Throwable)cause);
            }
            if (cause instanceof QueryExecutionTimeoutException) {
                return new GemfireQueryException((QueryExecutionTimeoutException)cause);
            }
            if (cause instanceof RegionDestroyedException) {
                return new InvalidDataAccessResourceUsageException(cause.getMessage(), (Throwable)cause);
            }
            if (cause instanceof RegionNotFoundException) {
                return new InvalidDataAccessResourceUsageException(cause.getMessage(), (Throwable)cause);
            }
            if (cause instanceof ResourceException) {
                return new DataAccessResourceFailureException(cause.getMessage(), (Throwable)cause);
            }
            if (cause instanceof RoleException) {
                return new GemfireSystemException(cause);
            }
            if (cause instanceof StatisticsDisabledException) {
                return new GemfireSystemException(cause);
            }
            if (cause instanceof SynchronizationCommitConflictException) {
                return new PessimisticLockingFailureException(cause.getMessage(), (Throwable)cause);
            }
        }
        if (cause instanceof CopyException) {
            return new GemfireSystemException(cause);
        }
        if (cause instanceof FunctionException) {
            return new InvalidDataAccessApiUsageException(cause.getMessage(), (Throwable)cause);
        }
        if (cause instanceof GemFireCacheException) {
            return GemfireCacheUtils.convertGemfireAccessException((GemFireException)((GemFireCacheException)cause).getCacheException());
        }
        if (cause instanceof GemFireConfigException) {
            return new GemfireSystemException(cause);
        }
        if (cause instanceof GemFireIOException) {
            return new DataAccessResourceFailureException(cause.getMessage(), (Throwable)cause);
        }
        if (cause instanceof GemFireSecurityException) {
            return new PermissionDeniedDataAccessException(cause.getMessage(), (Throwable)cause);
        }
        if (cause instanceof IncompatibleSystemException) {
            return new GemfireSystemException(cause);
        }
        if (cause instanceof InternalGemFireException) {
            return new GemfireSystemException(cause);
        }
        if (cause instanceof InvalidValueException) {
            return new TypeMismatchDataAccessException(cause.getMessage(), (Throwable)cause);
        }
        if (cause instanceof LeaseExpiredException) {
            return new PessimisticLockingFailureException(cause.getMessage(), (Throwable)cause);
        }
        if (cause instanceof NoSystemException) {
            return new GemfireSystemException(cause);
        }
        if (cause instanceof RuntimeAdminException) {
            return new GemfireSystemException(cause);
        }
        if (cause instanceof ServerConnectivityException) {
            return new DataAccessResourceFailureException(cause.getMessage(), (Throwable)cause);
        }
        if (cause instanceof SystemConnectException) {
            return new DataAccessResourceFailureException(cause.getMessage(), (Throwable)cause);
        }
        if (cause instanceof SystemIsRunningException) {
            return new GemfireSystemException(cause);
        }
        if (cause instanceof UnmodifiableException) {
            return new GemfireSystemException(cause);
        }
        DataAccessException dataAccessException = GemfireCacheUtils.convertQueryExceptions((RuntimeException)cause);
        if (dataAccessException != null) {
            return dataAccessException;
        }
        return new GemfireSystemException(cause);
    }

    public static DataAccessException convertGemfireAccessException(GemFireCheckedException cause) {
        if (cause instanceof AdminException) {
            return new GemfireSystemException(cause);
        }
        if (cause instanceof QueryException) {
            return new GemfireQueryException((QueryException)cause);
        }
        if (cause instanceof VersionException) {
            return new DataAccessResourceFailureException(cause.getMessage(), (Throwable)cause);
        }
        return new GemfireSystemException(cause);
    }

    public static DataAccessException convertGemfireAccessException(IndexInvalidException cause) {
        return new GemfireIndexException(cause);
    }

    public static DataAccessException convertGemfireAccessException(QueryInvalidException cause) {
        return new GemfireQueryException(cause);
    }

    static boolean isCqInvalidException(RuntimeException cause) {
        return CQ_EXCEPTION_CLASS != null && CQ_EXCEPTION_CLASS.isInstance(cause);
    }

    static DataAccessException convertQueryExceptions(RuntimeException cause) {
        if (cause instanceof IndexInvalidException) {
            return GemfireCacheUtils.convertGemfireAccessException((IndexInvalidException)cause);
        }
        if (cause instanceof QueryInvalidException) {
            return GemfireCacheUtils.convertGemfireAccessException((QueryInvalidException)cause);
        }
        if (GemfireCacheUtils.isCqInvalidException(cause)) {
            return GemfireCacheUtils.convertCqInvalidException(cause);
        }
        return new GemfireSystemException(cause);
    }

    static DataAccessException convertCqInvalidException(RuntimeException cause) {
        return new GemfireQueryException(cause);
    }

    static {
        Class type = null;
        try {
            type = ClassUtils.resolveClassName((String)"org.apache.geode.cache.query.CqInvalidException", (ClassLoader)GemfireCacheUtils.class.getClassLoader());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        CQ_EXCEPTION_CLASS = type;
    }
}

