/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function;

import java.util.List;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;

public class FunctionServiceFactoryBean
implements FactoryBean<FunctionService>,
InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(FunctionServiceFactoryBean.class);
    private List<Function> functions;

    public void afterPropertiesSet() throws Exception {
        if (!CollectionUtils.isEmpty(this.functions)) {
            for (Function function : this.functions) {
                if (logger.isInfoEnabled()) {
                    logger.info("registering Function with ID [{}]", (Object)function.getId());
                }
                FunctionService.registerFunction((Function)function);
            }
        }
    }

    public void setFunctions(List<Function> functions) {
        this.functions = functions;
    }

    public FunctionService getObject() throws Exception {
        return null;
    }

    public Class<?> getObjectType() {
        return FunctionService.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

