/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.query.SelectResults;
import org.springframework.data.domain.Pageable;
import org.springframework.data.gemfire.repository.query.AbstractSelectResults;
import org.springframework.data.gemfire.repository.query.support.PagingUtils;
import org.springframework.data.util.Lazy;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class PagedSelectResults<T>
extends AbstractSelectResults<T> {
    protected static final String NON_NULL_PAGEABLE_MESSAGE = "Pageable must not be null";
    private Lazy<List<T>> pagedList;
    private Pageable pageRequest;

    public PagedSelectResults(@NonNull SelectResults<T> selectResults, @NonNull Pageable pageable) {
        super(selectResults);
        Assert.notNull((Object)pageable, (String)NON_NULL_PAGEABLE_MESSAGE);
        this.pageRequest = pageable;
        this.pagedList = this.newLazyPagedList();
    }

    private Lazy<List<T>> newLazyPagedList() {
        return Lazy.of(() -> PagingUtils.getPagedList(this.getSelectResults().asList(), this.getPageRequest()));
    }

    @NonNull
    protected Pageable getPageRequest() {
        return this.pageRequest;
    }

    @Override
    public Set<T> asSet() {
        return new HashSet<T>(this.asList());
    }

    @Override
    public List<T> asList() {
        return (List)this.pagedList.get();
    }

    @Override
    public Iterator<T> iterator() {
        return Collections.unmodifiableList(this.asList()).iterator();
    }

    @Override
    public int size() {
        return this.asList().size();
    }

    public PagedSelectResults<T> with(@NonNull Pageable pageRequest) {
        Assert.notNull((Object)pageRequest, (String)NON_NULL_PAGEABLE_MESSAGE);
        this.pageRequest = pageRequest;
        this.pagedList = this.newLazyPagedList();
        return this;
    }
}

