/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.support;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.InterestPolicy;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.wan.GatewaySender;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.gemfire.IndexMaintenancePolicyConverter;
import org.springframework.data.gemfire.IndexMaintenancePolicyType;
import org.springframework.data.gemfire.IndexType;
import org.springframework.data.gemfire.IndexTypeConverter;
import org.springframework.data.gemfire.InterestPolicyConverter;
import org.springframework.data.gemfire.ScopeConverter;
import org.springframework.data.gemfire.client.InterestResultPolicyConverter;
import org.springframework.data.gemfire.eviction.EvictionActionConverter;
import org.springframework.data.gemfire.eviction.EvictionPolicyConverter;
import org.springframework.data.gemfire.eviction.EvictionPolicyType;
import org.springframework.data.gemfire.expiration.ExpirationActionConverter;
import org.springframework.data.gemfire.server.SubscriptionEvictionPolicy;
import org.springframework.data.gemfire.server.SubscriptionEvictionPolicyConverter;
import org.springframework.data.gemfire.support.AbstractPropertyEditorConverterSupport;
import org.springframework.data.gemfire.support.ConnectionEndpoint;
import org.springframework.data.gemfire.support.ConnectionEndpointList;
import org.springframework.data.gemfire.wan.OrderPolicyConverter;

public class CustomEditorBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
Ordered {
    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        beanFactory.addPropertyEditorRegistrar((PropertyEditorRegistrar)new CustomEditorPropertyEditorRegistrar());
    }

    private void registerCustomEditors(ConfigurableListableBeanFactory beanFactory) {
        if (beanFactory != null) {
            beanFactory.registerCustomEditor(ConnectionEndpoint.class, StringToConnectionEndpointConverter.class);
            beanFactory.registerCustomEditor(ConnectionEndpointList.class, StringToConnectionEndpointListConverter.class);
            beanFactory.registerCustomEditor(EvictionAction.class, EvictionActionConverter.class);
            beanFactory.registerCustomEditor(EvictionPolicyType.class, EvictionPolicyConverter.class);
            beanFactory.registerCustomEditor(ExpirationAction.class, ExpirationActionConverter.class);
            beanFactory.registerCustomEditor(IndexMaintenancePolicyType.class, IndexMaintenancePolicyConverter.class);
            beanFactory.registerCustomEditor(IndexType.class, IndexTypeConverter.class);
            beanFactory.registerCustomEditor(InterestPolicy.class, InterestPolicyConverter.class);
            beanFactory.registerCustomEditor(InterestResultPolicy.class, InterestResultPolicyConverter.class);
            beanFactory.registerCustomEditor(GatewaySender.OrderPolicy.class, OrderPolicyConverter.class);
            beanFactory.registerCustomEditor(Scope.class, ScopeConverter.class);
            beanFactory.registerCustomEditor(SubscriptionEvictionPolicy.class, SubscriptionEvictionPolicyConverter.class);
        }
    }

    public static class StringToConnectionEndpointListConverter
    extends AbstractPropertyEditorConverterSupport<ConnectionEndpointList> {
        public ConnectionEndpointList convert(String source) {
            return this.assertConverted(source, ConnectionEndpointList.parse(0, source.split(",")), ConnectionEndpointList.class);
        }
    }

    public static class StringToConnectionEndpointConverter
    extends AbstractPropertyEditorConverterSupport<ConnectionEndpoint> {
        public ConnectionEndpoint convert(String source) {
            return this.assertConverted(source, ConnectionEndpoint.parse(source), ConnectionEndpoint.class);
        }
    }

    public static class ConnectionEndpointArrayToIterableConverter
    extends PropertyEditorSupport
    implements Converter<ConnectionEndpoint[], Iterable<?>> {
        public Iterable convert(ConnectionEndpoint[] source) {
            return ConnectionEndpointList.from(source);
        }
    }

    public static class CustomEditorPropertyEditorRegistrar
    implements PropertyEditorRegistrar {
        public void registerCustomEditors(PropertyEditorRegistry registry) {
            if (registry != null) {
                registry.registerCustomEditor(ConnectionEndpoint.class, (PropertyEditor)new StringToConnectionEndpointConverter());
                registry.registerCustomEditor(ConnectionEndpointList.class, (PropertyEditor)new StringToConnectionEndpointListConverter());
                registry.registerCustomEditor(EvictionAction.class, (PropertyEditor)new EvictionActionConverter());
                registry.registerCustomEditor(EvictionPolicyType.class, (PropertyEditor)new EvictionPolicyConverter());
                registry.registerCustomEditor(ExpirationAction.class, (PropertyEditor)new ExpirationActionConverter());
                registry.registerCustomEditor(IndexMaintenancePolicyType.class, (PropertyEditor)new IndexMaintenancePolicyConverter());
                registry.registerCustomEditor(IndexType.class, (PropertyEditor)new IndexTypeConverter());
                registry.registerCustomEditor(InterestPolicy.class, (PropertyEditor)new InterestPolicyConverter());
                registry.registerCustomEditor(InterestResultPolicy.class, (PropertyEditor)new InterestResultPolicyConverter());
                registry.registerCustomEditor(GatewaySender.OrderPolicy.class, (PropertyEditor)new OrderPolicyConverter());
                registry.registerCustomEditor(Scope.class, (PropertyEditor)new ScopeConverter());
                registry.registerCustomEditor(SubscriptionEvictionPolicy.class, (PropertyEditor)new SubscriptionEvictionPolicyConverter());
            }
        }
    }
}

