/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.ProcessBean;
import org.apache.geode.cache.Region;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.gemfire.mapping.GemfireMappingContext;
import org.springframework.data.gemfire.repository.cdi.GemfireRepositoryBean;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.data.repository.cdi.CdiRepositoryExtensionSupport;

public class GemfireRepositoryExtension
extends CdiRepositoryExtensionSupport {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    final Map<Set<Annotation>, Bean<GemfireMappingContext>> mappingContexts = new HashMap<Set<Annotation>, Bean<GemfireMappingContext>>();
    final Set<Bean<Region>> regionBeans = new HashSet<Bean<Region>>();

    public GemfireRepositoryExtension() {
        this.logger.info("Activating CDI extension for Spring Data GemFire Repositories");
    }

    <X> void processBean(@Observes ProcessBean<X> processBean) {
        Bean bean = processBean.getBean();
        for (Type type : bean.getTypes()) {
            Type resolvedType = type instanceof ParameterizedType ? ((ParameterizedType)type).getRawType() : type;
            if (!(resolvedType instanceof Class)) continue;
            Class classType = (Class)resolvedType;
            if (Region.class.isAssignableFrom(classType)) {
                this.logger.debug("Found Region bean with name {}", (Object)bean.getName());
                this.regionBeans.add((Bean<Region>)bean);
                continue;
            }
            if (!GemfireMappingContext.class.isAssignableFrom(classType)) continue;
            this.logger.debug("Discovered {} bean with types {} having qualifiers {}", new Object[]{GemfireMappingContext.class.getName(), bean.getTypes(), bean.getQualifiers()});
            this.mappingContexts.put(bean.getQualifiers(), (Bean<GemfireMappingContext>)bean);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (Map.Entry entry : this.getRepositoryTypes()) {
            Class repositoryType = (Class)entry.getKey();
            Set qualifiers = (Set)entry.getValue();
            CdiRepositoryBean repositoryBean = this.createRepositoryBean(beanManager, repositoryType, qualifiers);
            this.logger.info("Registering bean for '{}' with qualifiers {}.", (Object)repositoryType.getName(), (Object)qualifiers);
            this.registerBean(repositoryBean);
            afterBeanDiscovery.addBean(repositoryBean);
        }
    }

    <T> CdiRepositoryBean<T> createRepositoryBean(BeanManager beanManager, Class<T> repositoryType, Set<Annotation> qualifiers) {
        Bean<GemfireMappingContext> gemfireMappingContextBean = this.mappingContexts.get(qualifiers);
        return new GemfireRepositoryBean<T>(beanManager, repositoryType, qualifiers, this.getCustomImplementationDetector(), gemfireMappingContextBean, this.regionBeans);
    }
}

