/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.execution;

import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.function.execution.AbstractFunctionExecution;
import org.springframework.data.gemfire.function.execution.GemfireFunctionCallback;
import org.springframework.data.gemfire.function.execution.GemfireFunctionOperations;

abstract class AbstractFunctionTemplate
implements GemfireFunctionOperations,
InitializingBean {
    private volatile long timeout;
    private volatile ResultCollector<?, ?> resultCollector;

    AbstractFunctionTemplate() {
    }

    public void afterPropertiesSet() throws Exception {
    }

    @Override
    public <T> Iterable<T> execute(Function function, Object ... args) {
        AbstractFunctionExecution functionExecution = this.getFunctionExecution().setArguments(args).setFunction(function);
        return this.execute(functionExecution);
    }

    @Override
    public <T> T executeAndExtract(Function function, Object ... args) {
        AbstractFunctionExecution functionExecution = this.getFunctionExecution().setArguments(args).setFunction(function);
        return this.executeAndExtract(functionExecution);
    }

    @Override
    public <T> Iterable<T> execute(String functionId, Object ... args) {
        AbstractFunctionExecution functionExecution = this.getFunctionExecution().setArguments(args).setFunctionId(functionId);
        return this.execute(functionExecution);
    }

    @Override
    public <T> T executeAndExtract(String functionId, Object ... args) {
        AbstractFunctionExecution functionExecution = this.getFunctionExecution().setArguments(args).setFunctionId(functionId);
        return this.executeAndExtract(functionExecution);
    }

    @Override
    public void executeWithNoResult(String functionId, Object ... args) {
        AbstractFunctionExecution functionExecution = this.getFunctionExecution().setArguments(args).setFunctionId(functionId);
        this.execute(functionExecution, false);
    }

    @Override
    public <T> T execute(GemfireFunctionCallback<T> callback) {
        return callback.doInGemfire(this.getFunctionExecution().getExecution());
    }

    protected <T> Iterable<T> execute(AbstractFunctionExecution functionExecution) {
        return this.prepare(functionExecution).execute();
    }

    protected <T> Iterable<T> execute(AbstractFunctionExecution functionExecution, boolean returnResult) {
        return this.prepare(functionExecution).execute(returnResult);
    }

    protected <T> T executeAndExtract(AbstractFunctionExecution functionExecution) {
        return this.prepare(functionExecution).executeAndExtract();
    }

    AbstractFunctionExecution prepare(AbstractFunctionExecution functionExecution) {
        return functionExecution.setResultCollector(this.getResultCollector()).setTimeout(this.getTimeout());
    }

    protected abstract AbstractFunctionExecution getFunctionExecution();

    public void setResultCollector(ResultCollector<?, ?> resultCollector) {
        this.resultCollector = resultCollector;
    }

    public ResultCollector<?, ?> getResultCollector() {
        return this.resultCollector;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }
}

