/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.mapping.GemfirePersistentProperty;
import org.springframework.data.gemfire.repository.Query;
import org.springframework.data.gemfire.repository.query.annotation.Hint;
import org.springframework.data.gemfire.repository.query.annotation.Import;
import org.springframework.data.gemfire.repository.query.annotation.Limit;
import org.springframework.data.gemfire.repository.query.annotation.Trace;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GemfireQueryMethod
extends QueryMethod {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final GemfirePersistentEntity<?> entity;
    private final Method method;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;

    public GemfireQueryMethod(@NonNull Method method, @NonNull RepositoryMetadata metadata, @NonNull ProjectionFactory projectionFactory, @NonNull MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> mappingContext) {
        this(method, metadata, projectionFactory, mappingContext, null);
    }

    public GemfireQueryMethod(@NonNull Method method, @NonNull RepositoryMetadata metadata, @NonNull ProjectionFactory projectionFactory, @NonNull MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> mappingContext, @Nullable QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, metadata, projectionFactory);
        Assert.notNull(mappingContext, (String)"MappingContext must not be null");
        this.method = method;
        this.entity = (GemfirePersistentEntity)mappingContext.getPersistentEntity(this.getDomainClass());
        this.evaluationContextProvider = evaluationContextProvider;
    }

    @NonNull
    protected Method getMethod() {
        return this.method;
    }

    @NonNull
    public GemfirePersistentEntity<?> getPersistentEntity() {
        return this.entity;
    }

    public boolean hasAnnotatedQuery() {
        return StringUtils.hasText((String)this.getAnnotatedQuery());
    }

    @Nullable
    public String getAnnotatedQuery() {
        Query query = this.getMethod().getAnnotation(Query.class);
        String queryString = query != null ? (String)AnnotationUtils.getValue((Annotation)query) : null;
        return StringUtils.hasText((String)queryString) ? queryString : null;
    }

    public boolean hasHint() {
        return this.getMethod().isAnnotationPresent(Hint.class);
    }

    public String[] getHints() {
        Hint hint = this.getMethod().getAnnotation(Hint.class);
        return hint != null ? hint.value() : EMPTY_STRING_ARRAY;
    }

    public boolean hasImport() {
        return this.getMethod().isAnnotationPresent(Import.class);
    }

    public String getImport() {
        Import importStatement = this.getMethod().getAnnotation(Import.class);
        return importStatement != null ? importStatement.value() : null;
    }

    public boolean hasLimit() {
        return this.getMethod().isAnnotationPresent(Limit.class);
    }

    public int getLimit() {
        Limit limit = this.getMethod().getAnnotation(Limit.class);
        return limit != null ? limit.value() : Integer.MAX_VALUE;
    }

    public boolean hasTrace() {
        return this.getMethod().isAnnotationPresent(Trace.class);
    }
}

