/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.schema.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.geode.cache.GemFireCache;
import org.springframework.context.ApplicationContext;
import org.springframework.data.gemfire.config.schema.SchemaObjectCollector;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.lang.Nullable;

public final class ComposableSchemaObjectCollector
implements SchemaObjectCollector<Object>,
Iterable<SchemaObjectCollector<?>> {
    private final List<SchemaObjectCollector<?>> schemaObjectCollectors;

    @Nullable
    public static SchemaObjectCollector<?> compose(SchemaObjectCollector<?> ... schemaObjectCollectors) {
        return ComposableSchemaObjectCollector.compose(Arrays.asList(ArrayUtils.nullSafeArray(schemaObjectCollectors, SchemaObjectCollector.class)));
    }

    @Nullable
    public static SchemaObjectCollector<?> compose(Iterable<SchemaObjectCollector<?>> schemaObjectCollectors) {
        List<SchemaObjectCollector<?>> schemaObjectCollectorList = StreamSupport.stream(CollectionUtils.nullSafeIterable(schemaObjectCollectors).spliterator(), false).filter(Objects::nonNull).collect(Collectors.toList());
        return schemaObjectCollectorList.isEmpty() ? null : (schemaObjectCollectorList.size() == 1 ? (SchemaObjectCollector)schemaObjectCollectorList.iterator().next() : new ComposableSchemaObjectCollector(schemaObjectCollectorList));
    }

    private ComposableSchemaObjectCollector(List<SchemaObjectCollector<?>> schemaObjectCollectors) {
        this.schemaObjectCollectors = Collections.unmodifiableList(schemaObjectCollectors);
    }

    @Override
    public Iterable<Object> collectFrom(ApplicationContext applicationContext) {
        return this.collectFrom((SchemaObjectCollector<?> collector) -> collector.collectFrom(applicationContext));
    }

    @Override
    public Iterable<Object> collectFrom(GemFireCache gemfireCache) {
        return this.collectFrom((SchemaObjectCollector<?> collector) -> collector.collectFrom(gemfireCache));
    }

    private Iterable<Object> collectFrom(Function<SchemaObjectCollector<?>, Iterable<?>> schemaObjectSource) {
        return this.schemaObjectCollectors.stream().flatMap(collector -> StreamSupport.stream(((Iterable)schemaObjectSource.apply((SchemaObjectCollector<?>)collector)).spliterator(), false)).collect(Collectors.toList());
    }

    @Override
    public Iterator<SchemaObjectCollector<?>> iterator() {
        return Collections.unmodifiableList(this.schemaObjectCollectors).iterator();
    }
}

