/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import java.util.Optional;
import java.util.Properties;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.distributed.DistributedSystem;
import org.springframework.data.gemfire.AbstractConfigurableCacheFactoryBean;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.lang.NonNull;

public abstract class AbstractResolvableCacheFactoryBean
extends AbstractConfigurableCacheFactoryBean {
    private volatile String cacheResolutionMessagePrefix;

    @Override
    protected GemFireCache doGetObject() {
        return this.init();
    }

    protected GemFireCache init() {
        ClassLoader currentThreadContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getBeanClassLoader());
            this.setCache((GemFireCache)this.resolveCache());
            this.logCacheInitialization();
            Object t = this.getCache();
            return t;
        }
        catch (Exception cause) {
            throw RuntimeExceptionFactory.newRuntimeException(cause, "Error occurred while initializing the cache", new Object[0]);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentThreadContextClassLoader);
        }
    }

    private void logCacheInitialization() {
        this.getOptionalCache().filter(cache -> this.isInfoLoggingEnabled()).ifPresent(cache -> {
            this.logInfo(() -> String.format("%1$s %2$s version [%3$s] Cache [%4$s]", this.cacheResolutionMessagePrefix, GemfireUtils.apacheGeodeProductName(), GemfireUtils.apacheGeodeVersion(), cache.getName()));
            Optional.ofNullable(cache.getDistributedSystem()).map(DistributedSystem::getDistributedMember).ifPresent(member -> {
                String message = "Connected to Distributed System [%1$s] as Member [%2$s] in Group(s) [%3$s] with Role(s) [%4$s] on Host [%5$s] having PID [%6$d]";
                this.logInfo(() -> String.format(message, cache.getDistributedSystem().getName(), member.getId(), member.getGroups(), member.getRoles(), member.getHost(), member.getProcessId()));
            });
        });
    }

    protected <T extends GemFireCache> T resolveCache() {
        try {
            this.cacheResolutionMessagePrefix = "Found existing";
            Object cache = this.fetchCache();
            cache = this.postProcess((T)cache);
            return cache;
        }
        catch (CacheClosedException cause) {
            this.cacheResolutionMessagePrefix = "Created new";
            Properties gemfireProperties = this.resolveProperties();
            Object factory = this.createFactory(gemfireProperties);
            factory = this.initializeFactory(factory);
            factory = this.configureFactory(factory);
            factory = this.postProcess(factory);
            T cache = this.createCache(factory);
            cache = this.postProcess(cache);
            return cache;
        }
    }

    @NonNull
    protected abstract Object createFactory(@NonNull Properties var1);

    @NonNull
    protected Object configureFactory(@NonNull Object factory) {
        return factory;
    }

    @Override
    protected Object initializeFactory(Object factory) {
        return super.initializeFactory(factory);
    }

    @NonNull
    protected Object postProcess(@NonNull Object factory) {
        return factory;
    }

    @NonNull
    protected abstract <T extends GemFireCache> T createCache(@NonNull Object var1);

    @NonNull
    protected <T extends GemFireCache> T postProcess(@NonNull T cache) {
        this.loadCacheXml(cache);
        Optional.ofNullable(this.getCopyOnRead()).ifPresent(arg_0 -> cache.setCopyOnRead(arg_0));
        this.configureHeapPercentages(cache);
        this.configureOffHeapPercentages(cache);
        this.registerTransactionListeners(cache);
        this.registerTransactionWriter(cache);
        return cache;
    }
}

