/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import java.util.Optional;
import java.util.function.Function;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.data.gemfire.support.AbstractFactoryBeanSupport;
import org.springframework.data.gemfire.support.GemfireFunctions;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class ResolvableRegionFactoryBean<K, V>
extends AbstractFactoryBeanSupport<Region<K, V>>
implements InitializingBean {
    protected static final String CREATING_REGION_LOG_MESSAGE = "Creating Region [%1$s] in Cache [%2$s]";
    protected static final String REGION_FOUND_LOG_MESSAGE = "Found Region [%1$s] in Cache [%2$s]";
    protected static final String REGION_NOT_FOUND_ERROR_MESSAGE = "Region [%1$s] in Cache [%2$s] not found";
    private Boolean lookupEnabled = false;
    private GemFireCache cache;
    private Region<?, ?> parent;
    private Resource snapshot;
    private volatile Region<K, V> region;
    private String name;
    private String regionName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        GemFireCache cache = this.requireCache();
        String regionName = this.requireRegionName();
        GemFireCache gemFireCache = cache;
        synchronized (gemFireCache) {
            this.setRegion(this.resolveRegion(cache, regionName));
            if (this.getRegion() != null) {
                this.logInfo(REGION_FOUND_LOG_MESSAGE, regionName, cache.getName());
            } else {
                this.logInfo(CREATING_REGION_LOG_MESSAGE, regionName, cache.getName());
                this.setRegion(this.postProcess(this.loadSnapshot(this.createRegion(cache, regionName))));
            }
        }
    }

    @NonNull
    private GemFireCache requireCache() {
        GemFireCache cache = this.getCache();
        Assert.notNull((Object)cache, (String)"Cache is required");
        return cache;
    }

    @NonNull
    String requireRegionName() {
        String regionName = this.resolveRegionName();
        Assert.hasText((String)regionName, (String)"regionName, name or the beanName property must be set");
        return regionName;
    }

    @Nullable
    private Region<K, V> resolveRegion(@NonNull GemFireCache cache, @NonNull String regionName) {
        return this.isLookupEnabled() ? Optional.ofNullable(this.getParent()).map(GemfireFunctions.getSubregionFromRegion(regionName)).orElseGet(GemfireFunctions.getRegionFromCache(cache, regionName)) : null;
    }

    public String resolveRegionName() {
        String name = this.name;
        String regionName = this.regionName;
        return StringUtils.hasText((String)regionName) ? regionName : (StringUtils.hasText((String)name) ? name : this.getBeanName());
    }

    protected Region<K, V> createRegion(GemFireCache cache, String regionName) throws Exception {
        throw new BeanInitializationException(String.format(REGION_NOT_FOUND_ERROR_MESSAGE, regionName, cache));
    }

    @NonNull
    protected Region<K, V> loadSnapshot(@NonNull Region<K, V> region) {
        Resource snapshot = this.snapshot;
        if (snapshot != null) {
            SpringUtils.VoidReturningThrowableOperation operation = () -> region.loadSnapshot(snapshot.getInputStream());
            Function<Throwable, RuntimeException> exceptionHandler = cause -> RuntimeExceptionFactory.newRuntimeException(cause, "Failed to load snapshot [%s]", snapshot);
            SpringUtils.safeRunOperation(operation, exceptionHandler);
        }
        return region;
    }

    protected Region<K, V> postProcess(Region<K, V> region) {
        return region;
    }

    public Region<K, V> getObject() throws Exception {
        return this.getRegion();
    }

    public Class<?> getObjectType() {
        Region<K, V> region = this.getRegion();
        return region != null ? region.getClass() : Region.class;
    }

    public GemFireCache getCache() {
        return this.cache;
    }

    public void setCache(GemFireCache cache) {
        this.cache = cache;
    }

    public void setLookupEnabled(@Nullable Boolean lookupEnabled) {
        this.lookupEnabled = lookupEnabled;
    }

    @Nullable
    public Boolean getLookupEnabled() {
        return this.lookupEnabled;
    }

    public boolean isLookupEnabled() {
        return Boolean.TRUE.equals(this.getLookupEnabled());
    }

    public void setName(@NonNull String name) {
        this.name = name;
    }

    public void setParent(@Nullable Region<?, ?> parent) {
        this.parent = parent;
    }

    @Nullable
    protected Region<?, ?> getParent() {
        return this.parent;
    }

    protected void setRegion(@Nullable Region<K, V> region) {
        this.region = region;
    }

    @Nullable
    public Region<K, V> getRegion() {
        return this.region;
    }

    public void setRegionName(@Nullable String regionName) {
        this.regionName = regionName;
    }

    public void setSnapshot(@Nullable Resource snapshot) {
        this.snapshot = snapshot;
    }
}

