/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.xml;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.geode.internal.datasource.ConfigProperty;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.config.support.CustomEditorBeanFactoryPostProcessor;
import org.springframework.data.gemfire.config.support.GemfireFeature;
import org.springframework.data.gemfire.config.support.PdxDiskStoreAwareBeanFactoryPostProcessor;
import org.springframework.data.gemfire.config.xml.ParsingUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

class CacheParser
extends AbstractSingleBeanDefinitionParser {
    CacheParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return CacheFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder cacheBuilder) {
        Element transactionWriter;
        List transactionListeners;
        super.doParse(element, cacheBuilder);
        this.registerGemFirePropertyEditorRegistrarWithBeanFactory(this.getRegistry(parserContext));
        ParsingUtils.setPropertyValue(element, cacheBuilder, "cache-xml-location", "cacheXml");
        ParsingUtils.setPropertyReference(element, cacheBuilder, "properties-ref", "properties");
        ParsingUtils.setPropertyValue(element, cacheBuilder, "use-bean-factory-locator");
        ParsingUtils.setPropertyValue(element, cacheBuilder, "close");
        ParsingUtils.setPropertyValue(element, cacheBuilder, "copy-on-read");
        ParsingUtils.setPropertyValue(element, cacheBuilder, "critical-heap-percentage");
        ParsingUtils.setPropertyValue(element, cacheBuilder, "critical-off-heap-percentage");
        ParsingUtils.setPropertyValue(element, cacheBuilder, "eviction-heap-percentage");
        ParsingUtils.setPropertyValue(element, cacheBuilder, "eviction-off-heap-percentage");
        ParsingUtils.setPropertyValue(element, cacheBuilder, "enable-auto-reconnect");
        ParsingUtils.setPropertyValue(element, cacheBuilder, "lock-lease");
        ParsingUtils.setPropertyValue(element, cacheBuilder, "lock-timeout");
        ParsingUtils.setPropertyValue(element, cacheBuilder, "message-sync-interval");
        ParsingUtils.setPropertyValue(element, cacheBuilder, "pdx-ignore-unread-fields");
        ParsingUtils.setPropertyValue(element, cacheBuilder, "pdx-read-serialized");
        ParsingUtils.setPropertyValue(element, cacheBuilder, "pdx-persistent");
        ParsingUtils.setPropertyReference(element, cacheBuilder, "pdx-serializer-ref", "pdxSerializer");
        ParsingUtils.setPropertyValue(element, cacheBuilder, "search-timeout");
        ParsingUtils.setPropertyValue(element, cacheBuilder, "use-cluster-configuration");
        this.parsePdxDiskStore(element, parserContext, cacheBuilder);
        this.parseJndiBindings(element, parserContext, cacheBuilder);
        Element gatewayConflictResolver = DomUtils.getChildElementByTagName((Element)element, (String)"gateway-conflict-resolver");
        if (gatewayConflictResolver != null) {
            ParsingUtils.throwExceptionWhenGemFireFeatureUnavailable(GemfireFeature.WAN, element.getLocalName(), "gateway-conflict-resolver", parserContext);
            cacheBuilder.addPropertyValue("gatewayConflictResolver", ParsingUtils.parseRefOrSingleNestedBeanDeclaration(gatewayConflictResolver, parserContext, cacheBuilder));
        }
        if (!CollectionUtils.isEmpty((Collection)(transactionListeners = DomUtils.getChildElementsByTagName((Element)element, (String)"transaction-listener")))) {
            ManagedList managedTransactionListeners = new ManagedList();
            for (Element transactionListener : transactionListeners) {
                managedTransactionListeners.add(ParsingUtils.parseRefOrNestedBeanDeclaration(transactionListener, parserContext, cacheBuilder));
            }
            cacheBuilder.addPropertyValue("transactionListeners", (Object)managedTransactionListeners);
        }
        if ((transactionWriter = DomUtils.getChildElementByTagName((Element)element, (String)"transaction-writer")) != null) {
            cacheBuilder.addPropertyValue("transactionWriter", ParsingUtils.parseRefOrNestedBeanDeclaration(transactionWriter, parserContext, cacheBuilder));
        }
    }

    @NonNull
    protected BeanDefinitionRegistry getRegistry(@NonNull ParserContext parserContext) {
        return parserContext.getRegistry();
    }

    @Nullable
    protected BeanFactory resolveBeanFactory(@Nullable BeanDefinitionRegistry registry) {
        return registry instanceof ConfigurableApplicationContext ? ((ConfigurableApplicationContext)registry).getBeanFactory() : (registry instanceof ApplicationContext ? ((ApplicationContext)registry).getAutowireCapableBeanFactory() : (registry instanceof ConfigurableListableBeanFactory ? (ConfigurableListableBeanFactory)registry : (registry instanceof BeanFactory ? (BeanFactory)registry : null)));
    }

    private void registerGemFirePropertyEditorRegistrarWithBeanFactory(BeanDefinitionRegistry registry) {
        Optional.ofNullable(registry).map(this::resolveBeanFactory).filter(ConfigurableListableBeanFactory.class::isInstance).map(ConfigurableListableBeanFactory.class::cast).ifPresent(beanFactory -> beanFactory.addPropertyEditorRegistrar((PropertyEditorRegistrar)new CustomEditorBeanFactoryPostProcessor.CustomEditorPropertyEditorRegistrar()));
    }

    private void parsePdxDiskStore(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ParsingUtils.setPropertyValue(element, builder, "pdx-disk-store", "pdxDiskStoreName");
        String pdxDiskStoreName = element.getAttribute("pdx-disk-store");
        if (StringUtils.hasText((String)pdxDiskStoreName)) {
            this.registerPdxDiskStoreAwareBeanFactoryPostProcessor(this.getRegistry(parserContext), pdxDiskStoreName);
        }
    }

    private void registerPdxDiskStoreAwareBeanFactoryPostProcessor(BeanDefinitionRegistry registry, String pdxDiskStoreName) {
        BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)this.createPdxDiskStoreAwareBeanFactoryPostProcessorBeanDefinition(pdxDiskStoreName), (BeanDefinitionRegistry)registry);
    }

    private AbstractBeanDefinition createPdxDiskStoreAwareBeanFactoryPostProcessorBeanDefinition(String pdxDiskStoreName) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(PdxDiskStoreAwareBeanFactoryPostProcessor.class);
        builder.addConstructorArgValue((Object)pdxDiskStoreName);
        return builder.getBeanDefinition();
    }

    private void parseJndiBindings(Element element, ParserContext parserContext, BeanDefinitionBuilder cacheBuilder) {
        List jndiBindings = DomUtils.getChildElementsByTagName((Element)element, (String)"jndi-binding");
        if (!CollectionUtils.isEmpty((Collection)jndiBindings)) {
            ManagedList jndiDataSources = new ManagedList(jndiBindings.size());
            for (Element jndiBinding : jndiBindings) {
                BeanDefinitionBuilder jndiDataSource = BeanDefinitionBuilder.genericBeanDefinition(CacheFactoryBean.JndiDataSource.class);
                NamedNodeMap attributes = jndiBinding.getAttributes();
                ManagedMap jndiAttributes = new ManagedMap(attributes.getLength());
                int length = attributes.getLength();
                for (int index = 0; index < length; ++index) {
                    Attr attribute = (Attr)attributes.item(index);
                    jndiAttributes.put((Object)attribute.getLocalName(), (Object)attribute.getValue());
                }
                jndiDataSource.addPropertyValue("attributes", (Object)jndiAttributes);
                List jndiProps = DomUtils.getChildElementsByTagName((Element)jndiBinding, (String)"jndi-prop");
                if (!CollectionUtils.isEmpty((Collection)jndiProps)) {
                    ManagedList props = new ManagedList(jndiProps.size());
                    for (Element jndiProp : jndiProps) {
                        String key = jndiProp.getAttribute("key");
                        String type = jndiProp.getAttribute("type");
                        String value = jndiProp.getTextContent();
                        type = StringUtils.hasText((String)type) ? type : String.class.getName();
                        props.add((Object)BeanDefinitionBuilder.genericBeanDefinition(ConfigProperty.class).addConstructorArgValue((Object)key).addConstructorArgValue((Object)value).addConstructorArgValue((Object)type).getBeanDefinition());
                    }
                    jndiDataSource.addPropertyValue("props", (Object)props);
                }
                jndiDataSources.add((Object)jndiDataSource.getBeanDefinition());
            }
            cacheBuilder.addPropertyValue("jndiDataSources", (Object)jndiDataSources);
        }
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String name = Optional.of(super.resolveId(element, definition, parserContext)).filter(StringUtils::hasText).map(StringUtils::trimWhitespace).orElse("gemfireCache");
        if (!"gemfire-cache".equals(name)) {
            parserContext.getRegistry().registerAlias(name, "gemfire-cache");
        }
        return name;
    }
}

